/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.ClassBuilder;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

public abstract class ExpressionClassBuilder
implements ExpressionClassBuilderInterface {
    protected static final String currentDatetimeFieldName = "cdt";
    protected ClassBuilder cb;
    protected GeneratedClass gc;
    protected int nextExprNum;
    protected int nextNonFastExpr;
    protected int nextFieldNum;
    protected MethodBuilder constructor;
    public CompilerContext myCompCtx;
    public MethodBuilder executeMethod;
    protected LocalField cdtField;
    protected MethodBuilder resultSetClosedMethod;
    private String currentRowScanResultSetName;
    private Object getDVF;
    private Object getRSF;
    private Object getEF;
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$store$access$ColumnOrdering;

    public abstract String getPackageName();

    public abstract int getRowCount() throws StandardException;

    public abstract void setNumSubqueries() throws StandardException;

    public abstract void getParameterReference(String var1, int var2, DataTypeDescriptor var3, MethodBuilder var4) throws StandardException;

    public abstract MethodBuilder beginExecuteMethod() throws StandardException;

    public abstract void finishExecuteMethod(boolean var1) throws StandardException;

    public abstract String getBaseClassName();

    public MethodBuilder getConstructor() {
        return this.constructor;
    }

    public ClassBuilder getClassBuilder() {
        return this.cb;
    }

    public MethodBuilder getExecuteMethod() {
        return this.executeMethod;
    }

    private final void beginConstructor() {
        MethodBuilder methodBuilder = this.cb.newConstructorBuilder(1);
        methodBuilder.callSuper();
        methodBuilder.methodReturn();
        methodBuilder.complete();
        this.constructor = this.cb.newMethodBuilder(1, "void", "postConstructor");
        this.constructor.addThrownException("org.apache.derby.iapi.error.StandardException");
    }

    public void finishConstructor() throws StandardException {
        this.setNumSubqueries();
        int n = this.getRowCount();
        if (n >= 1) {
            this.addNewArrayOfRows(n);
        }
        this.constructor.methodReturn();
        this.constructor.complete();
    }

    private void addNewArrayOfRows(int n) {
        this.constructor.pushThis();
        this.constructor.pushNewArray("org.apache.derby.iapi.sql.execute.ExecRow", n);
        this.constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "row", "org.apache.derby.iapi.sql.execute.ExecRow[]");
        this.constructor.endStatement();
    }

    public LocalField newFieldDeclaration(int n, String string, String string2) {
        return this.cb.addField(string, string2, n);
    }

    public LocalField newFieldDeclaration(int n, String string) {
        return this.cb.addField(string, this.newFieldName(), n);
    }

    public MethodBuilder newGeneratedFun(String string, int n) {
        return this.newGeneratedFun(string, n, null);
    }

    public MethodBuilder newGeneratedFun(String string, int n, String[] stringArray) {
        String string2 = "g".concat(Integer.toString(this.nextNonFastExpr++));
        return this.newGeneratedFun(string2, string, n, stringArray);
    }

    private MethodBuilder newGeneratedFun(String string, String string2, int n, String[] stringArray) {
        MethodBuilder methodBuilder = stringArray == null ? this.cb.newMethodBuilder(n, string2, string) : this.cb.newMethodBuilder(n, string2, string, stringArray);
        methodBuilder.addThrownException("org.apache.derby.iapi.error.StandardException");
        return methodBuilder;
    }

    public MethodBuilder newExprFun() {
        String string = "e".concat(Integer.toString(this.nextExprNum++));
        return this.newGeneratedFun(string, "java.lang.Object", 1, null);
    }

    public void pushMethodReference(MethodBuilder methodBuilder, MethodBuilder methodBuilder2) {
        methodBuilder.pushThis();
        methodBuilder.push(methodBuilder2.getName());
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.services.loader.GeneratedByteCode", "getMethod", "org.apache.derby.iapi.services.loader.GeneratedMethod", 1);
    }

    public MethodBuilder newUserExprFun() {
        MethodBuilder methodBuilder = this.newExprFun();
        methodBuilder.addThrownException("java.lang.Exception");
        return methodBuilder;
    }

    public void getCurrentDateExpression(MethodBuilder methodBuilder) {
        LocalField localField = this.getCurrentSetup();
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, null, "getCurrentDate", "java.sql.Date", 0);
    }

    public void getCurrentTimeExpression(MethodBuilder methodBuilder) {
        LocalField localField = this.getCurrentSetup();
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, null, "getCurrentTime", "java.sql.Time", 0);
    }

    public void getCurrentTimestampExpression(MethodBuilder methodBuilder) {
        LocalField localField = this.getCurrentSetup();
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, null, "getCurrentTimestamp", "java.sql.Timestamp", 0);
    }

    public FormatableArrayHolder getColumnOrdering(ResultColumnList resultColumnList) {
        int n = resultColumnList == null ? 0 : resultColumnList.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (!resultColumnList.getResultColumn(n3 + 1).isGeneratedForUnmatchedColumnInInsert()) {
                ++n2;
            }
            ++n3;
        }
        Object[] objectArray = new IndexColumnOrder[n2];
        n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            if (!resultColumnList.getResultColumn(n3 + 1).isGeneratedForUnmatchedColumnInInsert()) {
                objectArray[n4] = new IndexColumnOrder(n3);
                ++n4;
            }
            ++n3;
        }
        return new FormatableArrayHolder(objectArray);
    }

    public FormatableArrayHolder addColumnToOrdering(FormatableArrayHolder formatableArrayHolder, int n) {
        ColumnOrdering[] columnOrderingArray = (ColumnOrdering[])formatableArrayHolder.getArray(class$Lorg$apache$derby$iapi$store$access$ColumnOrdering != null ? class$Lorg$apache$derby$iapi$store$access$ColumnOrdering : (class$Lorg$apache$derby$iapi$store$access$ColumnOrdering = ExpressionClassBuilder.class$("org.apache.derby.iapi.store.access.ColumnOrdering")));
        int n2 = columnOrderingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (columnOrderingArray[n3].getColumnId() == n) {
                return formatableArrayHolder;
            }
            ++n3;
        }
        Object[] objectArray = new IndexColumnOrder[n2 + 1];
        System.arraycopy(columnOrderingArray, 0, objectArray, 0, n2);
        objectArray[n2] = new IndexColumnOrder(n);
        return new FormatableArrayHolder(objectArray);
    }

    public FormatableArrayHolder getColumnOrdering(OrderedColumnList orderedColumnList) {
        int n;
        int n2 = n = orderedColumnList == null ? 0 : orderedColumnList.size();
        if (n == 0) {
            return new FormatableArrayHolder(new IndexColumnOrder[0]);
        }
        return new FormatableArrayHolder(orderedColumnList.getColumnOrdering());
    }

    public int addItem(Object object) {
        return this.myCompCtx.addSavedObject(object);
    }

    public void pushDataValueFactory(MethodBuilder methodBuilder) {
        if (this.getDVF == null) {
            this.getDVF = methodBuilder.describeMethod((short)182, this.getBaseClassName(), "getDataValueFactory", "org.apache.derby.iapi.types.DataValueFactory");
        }
        methodBuilder.pushThis();
        methodBuilder.callMethod(this.getDVF);
    }

    public void pushGetResultSetFactoryExpression(MethodBuilder methodBuilder) {
        if (this.getRSF == null) {
            this.getRSF = methodBuilder.describeMethod((short)182, this.getBaseClassName(), "getResultSetFactory", "org.apache.derby.iapi.sql.execute.ResultSetFactory");
        }
        methodBuilder.pushThis();
        methodBuilder.callMethod(this.getRSF);
    }

    public void pushGetExecutionFactoryExpression(MethodBuilder methodBuilder) {
        if (this.getEF == null) {
            this.getEF = methodBuilder.describeMethod((short)182, this.getBaseClassName(), "getExecutionFactory", "org.apache.derby.iapi.sql.execute.ExecutionFactory");
        }
        methodBuilder.pushThis();
        methodBuilder.callMethod(this.getEF);
    }

    public void pushResultSetClosedMethodFieldAccess(MethodBuilder methodBuilder) {
        if (this.resultSetClosedMethod != null) {
            this.pushMethodReference(methodBuilder, this.resultSetClosedMethod);
        } else {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
    }

    public void pushColumnReference(MethodBuilder methodBuilder, int n, int n2) {
        methodBuilder.pushThis();
        methodBuilder.push(n);
        methodBuilder.push(n2);
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getColumnFromRow", "org.apache.derby.iapi.types.DataValueDescriptor", 2);
    }

    public void pushPVSReference(MethodBuilder methodBuilder) {
        methodBuilder.pushThis();
        methodBuilder.getField("org.apache.derby.impl.sql.execute.BaseActivation", "pvs", "org.apache.derby.iapi.sql.ParameterValueSet");
    }

    protected LocalField getCurrentSetup() {
        if (this.cdtField != null) {
            return this.cdtField;
        }
        this.cdtField = this.newFieldDeclaration(2, "org.apache.derby.impl.sql.execute.CurrentDatetime", currentDatetimeFieldName);
        this.constructor.pushNewStart("org.apache.derby.impl.sql.execute.CurrentDatetime");
        this.constructor.pushNewComplete(0);
        this.constructor.putField(this.cdtField);
        this.constructor.endStatement();
        return this.cdtField;
    }

    private String newFieldName() {
        return "f".concat(Integer.toString(this.nextFieldNum++));
    }

    protected TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.myCompCtx.getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    public GeneratedClass getGeneratedClass(ByteArray byteArray) throws StandardException {
        if (this.gc != null) {
            return this.gc;
        }
        if (byteArray != null) {
            ByteArray byteArray2 = this.cb.getClassBytecode();
            byteArray.setBytes(byteArray2.getArray());
            byteArray.setLength(byteArray2.getLength());
        }
        this.gc = this.cb.getGeneratedClass();
        return this.gc;
    }

    public void pushThisAsActivation(MethodBuilder methodBuilder) {
        methodBuilder.pushThis();
        methodBuilder.upCast("org.apache.derby.iapi.sql.Activation");
    }

    public void generateNull(MethodBuilder methodBuilder, TypeCompiler typeCompiler) {
        this.pushDataValueFactory(methodBuilder);
        methodBuilder.pushNull(typeCompiler.interfaceName());
        typeCompiler.generateNull(methodBuilder);
    }

    public void generateNullWithExpress(MethodBuilder methodBuilder, TypeCompiler typeCompiler) {
        this.pushDataValueFactory(methodBuilder);
        methodBuilder.swap();
        methodBuilder.cast(typeCompiler.interfaceName());
        typeCompiler.generateNull(methodBuilder);
    }

    public void generateDataValue(MethodBuilder methodBuilder, TypeCompiler typeCompiler, LocalField localField) {
        this.pushDataValueFactory(methodBuilder);
        methodBuilder.swap();
        typeCompiler.generateDataValue(methodBuilder, localField);
    }

    public String newRowLocationScanResultSetName() {
        this.currentRowScanResultSetName = this.newFieldName();
        return this.currentRowScanResultSetName;
    }

    public String getRowLocationScanResultSetName() {
        return this.currentRowScanResultSetName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ExpressionClassBuilder(String string, String string2, CompilerContext compilerContext) throws StandardException {
        int n = 17;
        this.myCompCtx = compilerContext;
        JavaFactory javaFactory = this.myCompCtx.getJavaFactory();
        if (string2 == null) {
            string2 = this.myCompCtx.getUniqueClassName();
        }
        this.cb = javaFactory.newClassBuilder(this.myCompCtx.getClassFactory(), this.getPackageName(), n, string2, string);
        this.beginConstructor();
    }
}

