/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.OrderedColumn;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class OrderByColumn
extends OrderedColumn {
    private ResultColumn resultCol;
    private String columnName;
    private String correlationName;
    private String schemaName;
    private boolean ascending = true;

    public void init(Object object, Object object2, Object object3) {
        this.columnName = (String)object;
        this.correlationName = (String)object2;
        this.schemaName = (String)object3;
    }

    public void init(Object object) {
        this.columnPosition = (Integer)object;
    }

    public String toString() {
        return "";
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setDescending() {
        this.ascending = false;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    ResultColumn getResultColumn() {
        return this.resultCol;
    }

    ValueNode getNonRedundantExpression() {
        ColumnReference columnReference = null;
        ResultColumn resultColumn = this.resultCol;
        while (resultColumn.isRedundant()) {
            ValueNode valueNode = resultColumn.getExpression();
            if (valueNode instanceof ColumnReference) {
                columnReference = (ColumnReference)valueNode;
            }
            resultColumn = columnReference.getSource();
        }
        return resultColumn.getExpression();
    }

    public void bindOrderByColumn(ResultSetNode resultSetNode) throws StandardException {
        Object object;
        int n = -1;
        ResultColumnList resultColumnList = resultSetNode.getResultColumns();
        if (resultSetNode instanceof UnionNode && this.correlationName != null) {
            String string = this.schemaName != null ? this.schemaName + "." + this.correlationName + "." + this.columnName : this.correlationName + "." + this.columnName;
            throw StandardException.newException("42877", string);
        }
        if (this.correlationName != null) {
            object = resultSetNode.getFromTableByName(this.correlationName, this.schemaName, true);
            if (object == null && (object = resultSetNode.getFromTableByName(this.correlationName, this.schemaName, false)) == null) {
                String string = this.schemaName != null ? this.schemaName + "." + this.correlationName : this.correlationName;
                throw StandardException.newException("42X10", string);
            }
            n = resultSetNode instanceof UnionNode ? ((FromTable)resultSetNode).getTableNumber() : ((FromTable)object).getTableNumber();
        }
        if (this.columnName != null) {
            this.resultCol = resultColumnList.getOrderByColumn(this.columnName, this.correlationName, n);
            if (this.resultCol == null || this.resultCol.isNameGenerated()) {
                object = this.correlationName == null ? this.columnName : this.correlationName + "." + this.columnName;
                throw StandardException.newException("42X78", object);
            }
            this.columnPosition = this.resultCol.getColumnPosition();
        } else {
            this.resultCol = resultColumnList.getOrderByColumn(this.columnPosition);
            if (this.resultCol == null) {
                throw StandardException.newException("42X77", String.valueOf(this.columnPosition));
            }
        }
        this.resultCol.verifyOrderable();
    }

    public void pullUpOrderByColumn(ResultSetNode resultSetNode) throws StandardException {
        if (this.columnName != null) {
            ResultColumnList resultColumnList = resultSetNode.getResultColumns();
            this.resultCol = resultColumnList.getOrderByColumn(this.columnName, this.correlationName);
            if (this.resultCol == null) {
                TableName tableName = null;
                if (this.schemaName != null || this.correlationName != null) {
                    tableName = (TableName)this.getNodeFactory().getNode(34, this.schemaName, this.correlationName, this.getContextManager());
                }
                ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, this.columnName, tableName, this.getContextManager());
                this.resultCol = (ResultColumn)this.getNodeFactory().getNode(80, this.columnName, columnReference, this.getContextManager());
                resultColumnList.addResultColumn(this.resultCol);
                resultColumnList.incOrderBySelect();
            }
        }
    }

    void resetToSourceRC() {
        VirtualColumnNode virtualColumnNode = (VirtualColumnNode)this.resultCol.getExpression();
        this.resultCol = virtualColumnNode.getSourceResultColumn();
    }

    boolean constantColumn(PredicateList predicateList) {
        ValueNode valueNode = this.resultCol.getExpression();
        return valueNode.constantExpression(predicateList);
    }

    void remapColumnReferencesToExpressions() throws StandardException {
        this.resultCol.setExpression(this.resultCol.getExpression().remapColumnReferencesToExpressions());
    }
}

