/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public abstract class UnaryOperatorNode
extends ValueNode {
    public static final int UNARY_PLUS = 1;
    public static final int UNARY_MINUS = 2;
    public static final int NOT = 3;
    public static final int IS_NULL = 4;
    String operator;
    String methodName;
    ValueNode operand;

    public void init(Object object, Object object2, Object object3) {
        this.operand = (ValueNode)object;
        this.operator = (String)object2;
        this.methodName = (String)object3;
    }

    public void init(Object object) {
        this.operand = (ValueNode)object;
    }

    void setOperator(String string) {
        this.operator = string;
    }

    String getOperatorString() {
        return this.operator;
    }

    void setMethodName(String string) {
        this.methodName = string;
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public ValueNode getOperand() {
        return this.operand;
    }

    public void setClause(int n) {
        super.setClause(n);
        if (this.operand != null) {
            this.operand.setClause(n);
        }
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        return this.bindUnaryOperator(fromList, subqueryList, vector);
    }

    protected ValueNode bindUnaryOperator(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        if (this.operand == null) {
            return this;
        }
        this.operand = this.operand.bindExpression(fromList, subqueryList, vector);
        if (this.operand.isParameterNode()) {
            this.bindParameter();
        }
        if (!(this.operand instanceof UntypedNullConstantNode || this.operand.getTypeId().systemBuiltIn() || this instanceof IsNullNode)) {
            this.operand = this.operand.genSQLJavaSQLTree();
        }
        return this;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.preprocess(n, fromList, subqueryList, predicateList);
        }
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.operand == null ? false : this.operand.categorize(jBitSet, bl);
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.remapColumnReferencesToExpressions();
        }
        return this;
    }

    public boolean isConstantExpression() {
        return this.operand == null ? true : this.operand.isConstantExpression();
    }

    public boolean constantExpression(PredicateList predicateList) {
        return this.operand == null ? true : this.operand.constantExpression(predicateList);
    }

    void bindParameter() throws StandardException {
        if (this.operand.getTypeServices() == null) {
            throw StandardException.newException("42X36", this.operator);
        }
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.operand == null) {
            return;
        }
        String string = this.getTypeCompiler().interfaceName();
        boolean bl = !this.getTypeId().isBooleanTypeId();
        String string2 = this.getReceiverInterfaceName();
        this.operand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.cast(string2);
        if (bl) {
            LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
            methodBuilder.getField(localField);
            methodBuilder.callMethod((short)185, null, this.methodName, string, 1);
            methodBuilder.putField(localField);
        } else {
            methodBuilder.callMethod((short)185, null, this.methodName, string, 0);
        }
    }

    public String getReceiverInterfaceName() throws StandardException {
        return this.operand.getTypeCompiler().interfaceName();
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.operand != null ? this.operand.getOrderableVariantType() : 3;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (this.operand != null && !visitor.stopTraversal()) {
            this.operand = (ValueNode)this.operand.accept(visitor);
        }
        return visitable;
    }
}

