/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public class AutoincrementCounter {
    private Long start;
    private long increment;
    private String identity;
    private long finalValue;
    private String schemaName;
    private String tableName;
    private String columnName;
    private long counter;
    private int columnPosition;
    private boolean initialized = false;

    public static String makeIdentity(String string, String string2, String string3) {
        return string + "." + string2 + "." + string3;
    }

    public static String makeIdentity(TableDescriptor tableDescriptor, ColumnDescriptor columnDescriptor) {
        return tableDescriptor.getSchemaName() + "." + tableDescriptor.getName() + "." + columnDescriptor.getColumnName();
    }

    public void reset(boolean bl) {
        if (bl) {
            this.initialized = false;
        } else {
            this.counter = this.finalValue;
            this.initialized = true;
        }
    }

    public long update(long l) {
        this.counter = l;
        this.initialized = true;
        return this.counter;
    }

    public long update() throws StandardException {
        if (!this.initialized) {
            this.initialized = true;
            if (this.start == null) {
                throw StandardException.newException("42Z25");
            }
            this.counter = this.start;
        } else {
            this.counter += this.increment;
        }
        return this.counter;
    }

    public Long getCurrentValue() {
        if (!this.initialized) {
            return null;
        }
        return new Long(this.counter);
    }

    public String getIdentity() {
        return this.identity;
    }

    public void flushToDisk(TransactionController transactionController, DataDictionary dataDictionary, UUID uUID) throws StandardException {
        dataDictionary.setAutoincrementValue(transactionController, uUID, this.columnName, this.counter, true);
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public Long getStartValue() {
        return this.start;
    }

    public String toString() {
        return "counter: " + this.identity + " current: " + this.counter + " start: " + this.start + " increment: " + this.increment + " final: " + this.finalValue;
    }

    public AutoincrementCounter(Long l, long l2, long l3, String string, String string2, String string3, int n) {
        this.increment = l2;
        this.start = l;
        this.initialized = false;
        this.identity = AutoincrementCounter.makeIdentity(string, string2, string3);
        this.finalValue = l3;
        this.schemaName = string;
        this.tableName = string2;
        this.columnName = string3;
        this.columnPosition = n;
    }
}

