/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;

class CreateIndexConstantAction
extends IndexConstantAction {
    private boolean unique;
    private String indexType;
    private long conglomId;
    private String[] columnNames;
    private boolean[] isAscending;
    private boolean isConstraint;
    private UUID conglomerateUUID;
    private Properties properties;
    private ExecRow indexTemplateRow;

    public String toString() {
        return "CREATE INDEX " + this.indexName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeConstantAction(Activation activation) throws StandardException {
        Object object;
        Object object2;
        int n;
        Object object3;
        IndexRowGenerator indexRowGenerator = null;
        int n2 = -1;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        boolean bl = activation.getForCreateTable();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true);
        TableDescriptor tableDescriptor = activation.getDDLTableDescriptor();
        if (tableDescriptor == null) {
            tableDescriptor = this.tableId != null ? dataDictionary.getTableDescriptor(this.tableId) : dataDictionary.getTableDescriptor(this.tableName, schemaDescriptor);
        }
        if (tableDescriptor == null) {
            throw StandardException.newException("X0Y38.S", this.indexName, (Object)this.tableName);
        }
        if (tableDescriptor.getTableType() == 1) {
            throw StandardException.newException("X0Y28.S", this.indexName, (Object)this.tableName);
        }
        this.lockTableForDDL(transactionController, tableDescriptor.getHeapConglomerateId(), false);
        if (!bl) {
            dependencyManager.invalidateFor(tableDescriptor, 3, languageConnectionContext);
        }
        int[] nArray = new int[this.columnNames.length];
        int n3 = 0;
        while (n3 < this.columnNames.length) {
            ClassFactory classFactory;
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.columnNames[n3]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", this.columnNames[n3], (Object)this.tableName);
            }
            TypeId typeId = columnDescriptor.getType().getTypeId();
            boolean bl2 = typeId.orderable(classFactory = languageConnectionContext.getLanguageConnectionFactory().getClassFactory());
            if (bl2 && typeId.userType()) {
                object3 = typeId.getCorrespondingJavaTypeName();
                try {
                    if (classFactory.isApplicationClass(classFactory.loadApplicationClass((String)object3))) {
                        bl2 = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl2 = false;
                }
            }
            if (!bl2) {
                throw StandardException.newException("X0X67.S", typeId.getSQLTypeName());
            }
            nArray[n3] = columnDescriptor.getPosition();
            if (n2 < nArray[n3]) {
                n2 = nArray[n3];
            }
            ++n3;
        }
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        boolean bl3 = false;
        int n4 = 0;
        while (n4 < conglomerateDescriptorArray.length) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n4];
            if (conglomerateDescriptor.isIndex()) {
                object3 = conglomerateDescriptor.getIndexDescriptor();
                int[] nArray2 = ((IndexRowGenerator)object3).baseColumnPositions();
                boolean[] blArray = ((IndexRowGenerator)object3).isAscending();
                n = 0;
                if (nArray2.length == nArray.length && (((IndexRowGenerator)object3).isUnique() || !this.unique) && this.indexType.equals(((IndexRowGenerator)object3).indexType())) {
                    while (n < nArray2.length) {
                        if (nArray2[n] != nArray[n] || blArray[n] != this.isAscending[n]) break;
                        ++n;
                    }
                }
                if (n == nArray.length) {
                    if (!this.isConstraint) {
                        activation.addWarning(StandardException.newWarning("01504", conglomerateDescriptor.getConglomerateName()));
                        return;
                    }
                    this.conglomId = conglomerateDescriptor.getConglomerateNumber();
                    indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
                    this.conglomerateUUID = conglomerateDescriptor.getUUID();
                    bl3 = true;
                    break;
                }
            }
            ++n4;
        }
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (bl3) {
            ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, tableDescriptor.getUUID(), schemaDescriptor.getUUID());
            dataDictionary.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
            object3 = tableDescriptor.getConglomerateDescriptorList();
            ((ArrayList)object3).add(conglomerateDescriptor);
        }
        Properties properties = this.properties != null ? this.properties : new Properties();
        ((Hashtable)properties).put("baseConglomerateId", Long.toString(tableDescriptor.getHeapConglomerateId()));
        ((Hashtable)properties).put("nUniqueColumns", Integer.toString(this.unique ? nArray.length : nArray.length + 1));
        ((Hashtable)properties).put("rowLocationColumn", Integer.toString(nArray.length));
        ((Hashtable)properties).put("nKeyFields", Integer.toString(nArray.length + 1));
        if (!bl3) {
            indexRowGenerator = new IndexRowGenerator(this.indexType, this.unique, nArray, this.isAscending, nArray.length);
        }
        RowSource rowSource = null;
        long l = 0L;
        boolean bl4 = false;
        int n5 = bl ? 1 : 16;
        int n6 = tableDescriptor.getNumberOfColumns();
        n = 0;
        FormatableBitSet formatableBitSet = new FormatableBitSet(n6 + 1);
        int n7 = 0;
        while (n7 < nArray.length) {
            formatableBitSet.set(nArray[n7]);
            ++n7;
        }
        FormatableBitSet formatableBitSet2 = RowUtil.shift(formatableBitSet, 1);
        GroupFetchScanController groupFetchScanController = transactionController.openGroupFetchScan(tableDescriptor.getHeapConglomerateId(), false, 0, 7, 5, formatableBitSet2, null, 0, null, null, 0);
        ExecRow[] execRowArray = new ExecRow[n5];
        ExecIndexRow[] execIndexRowArray = new ExecIndexRow[n5];
        ExecRow[] execRowArray2 = new ExecRow[n5];
        try {
            ColumnOrdering[] columnOrderingArray;
            Object object4;
            int n8 = 0;
            while (n8 < n5) {
                execRowArray[n8] = activation.getExecutionFactory().getValueRow(n2);
                execIndexRowArray[n8] = indexRowGenerator.getIndexRowTemplate();
                execRowArray2[n8] = activation.getExecutionFactory().getValueRow(nArray.length);
                ++n8;
            }
            this.indexTemplateRow = execIndexRowArray[0];
            object2 = tableDescriptor.getColumnDescriptorList();
            int n9 = ((ArrayList)object2).size();
            int n10 = 0;
            int n11 = 0;
            while (n10 < n9) {
                if (formatableBitSet2.get(n10)) {
                    ++n11;
                    object4 = ((ColumnDescriptorList)object2).elementAt(n10);
                    columnOrderingArray = ((ColumnDescriptor)object4).getType();
                    int n12 = 0;
                    while (n12 < n5) {
                        execRowArray[n12].setColumn(n10 + 1, columnOrderingArray.getNull());
                        execRowArray2[n12].setColumn(n11, execRowArray[n12].getColumn(n10 + 1));
                        ++n12;
                    }
                    n += columnOrderingArray.getTypeId().getApproximateLengthInBytes((DataTypeDescriptor)columnOrderingArray);
                }
                ++n10;
            }
            object = new RowLocation[n5];
            n11 = 0;
            while (n11 < n5) {
                object[n11] = groupFetchScanController.newRowLocationTemplate();
                indexRowGenerator.getIndexRow(execRowArray2[n11], object[n11], execIndexRowArray[n11], formatableBitSet);
                ++n11;
            }
            if (bl3) {
                Object var32_58 = null;
                if (groupFetchScanController != null) {
                    groupFetchScanController.close();
                }
                if (rowSource != null) {
                    rowSource.closeRowSource();
                }
                if (bl4) {
                    transactionController.dropSort(l);
                }
                return;
            }
            object4 = null;
            if (this.unique) {
                n11 = nArray.length;
                columnOrderingArray = this.indexName;
                if (this.conglomerateUUID != null) {
                    ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.conglomerateUUID);
                    if (this.isConstraint && conglomerateDescriptor != null && conglomerateDescriptor.getUUID() != null && tableDescriptor != null) {
                        ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
                        columnOrderingArray = constraintDescriptor.getConstraintName();
                    }
                }
                object4 = new UniqueIndexSortObserver(true, this.isConstraint, (String)columnOrderingArray, this.indexTemplateRow, true, tableDescriptor.getName());
            } else {
                n11 = nArray.length + 1;
                object4 = new BasicSortObserver(true, false, this.indexTemplateRow, true);
            }
            columnOrderingArray = new ColumnOrdering[n11];
            int n13 = 0;
            while (n13 < n11) {
                columnOrderingArray[n13] = new IndexColumnOrder(n13, this.unique || n13 < n11 - 1 ? this.isAscending[n13] : true);
                ++n13;
            }
            l = transactionController.createSort(null, this.indexTemplateRow.getRowArrayClone(), columnOrderingArray, (SortObserver)object4, false, groupFetchScanController.getEstimatedRowCount(), n);
            bl4 = true;
            rowSource = this.loadSorter(execRowArray, execIndexRowArray, transactionController, groupFetchScanController, l, (RowLocation[])object);
            this.conglomId = transactionController.createAndLoadConglomerate(this.indexType, this.indexTemplateRow.getRowArray(), columnOrderingArray, properties, 0, (RowLocationRetRowSource)rowSource, null);
        }
        finally {
            Object var32_59 = null;
            if (groupFetchScanController != null) {
                groupFetchScanController.close();
            }
            if (rowSource != null) {
                rowSource.closeRowSource();
            }
            if (bl4) {
                transactionController.dropSort(l);
            }
        }
        object2 = transactionController.openConglomerate(this.conglomId, false, 0, 7, 5);
        if (!object2.isKeyed()) {
            object2.close();
            throw StandardException.newException("X0X85.S", this.indexName, (Object)this.indexType);
        }
        object2.close();
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, tableDescriptor.getUUID(), schemaDescriptor.getUUID());
        dataDictionary.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        object = tableDescriptor.getConglomerateDescriptorList();
        ((ArrayList)object).add(conglomerateDescriptor);
        CardinalityCounter cardinalityCounter = (CardinalityCounter)rowSource;
        long l2 = cardinalityCounter.getRowCount();
        if (l2 > 0L) {
            long[] lArray = cardinalityCounter.getCardinality();
            int n14 = 0;
            while (n14 < lArray.length) {
                StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), conglomerateDescriptor.getUUID(), tableDescriptor.getUUID(), "I", new StatisticsImpl(l2, lArray[n14]), n14 + 1);
                dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, transactionController);
                ++n14;
            }
        }
    }

    ExecRow getIndexTemplateRow() {
        return this.indexTemplateRow;
    }

    private void statementExceptionCleanup(ScanController scanController, ConglomerateController conglomerateController) throws StandardException {
        if (conglomerateController != null) {
            conglomerateController.close();
        }
        if (scanController != null) {
            scanController.close();
        }
    }

    private RowLocationRetRowSource loadSorter(ExecRow[] execRowArray, ExecIndexRow[] execIndexRowArray, TransactionController transactionController, GroupFetchScanController groupFetchScanController, long l, RowLocation[] rowLocationArray) throws StandardException {
        long l2 = 0L;
        SortController sortController = transactionController.openSort(l);
        try {
            int n = execRowArray.length;
            DataValueDescriptor[][] dataValueDescriptorArray = new DataValueDescriptor[n][];
            int n2 = 0;
            while (n2 < n) {
                dataValueDescriptorArray[n2] = execRowArray[n2].getRowArray();
                ++n2;
            }
            n2 = 0;
            while ((n2 = groupFetchScanController.fetchNextGroup(dataValueDescriptorArray, rowLocationArray)) > 0) {
                int n3 = 0;
                while (n3 < n2) {
                    sortController.insert(execIndexRowArray[n3].getRowArray());
                    ++l2;
                    ++n3;
                }
            }
            groupFetchScanController.setEstimatedRowCount(l2);
        }
        finally {
            Object var12_13 = null;
            sortController.close();
        }
        return new CardinalityCounter(transactionController.openSortRowSource(l));
    }

    CreateIndexConstantAction(boolean bl, String string, String string2, String string3, String string4, UUID uUID, long l, String[] stringArray, boolean[] blArray, boolean bl2, UUID uUID2, Properties properties) {
        super(uUID, string3, string4, string2);
        this.unique = bl;
        this.indexType = string;
        this.conglomId = l;
        this.columnNames = stringArray;
        this.isAscending = blArray;
        this.isConstraint = bl2;
        this.conglomerateUUID = uUID2;
        this.properties = properties;
    }
}

