/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropSchemaConstantAction
extends DDLConstantAction {
    private final String schemaName;

    public String toString() {
        return "DROP SCHEMA " + this.schemaName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, null, true);
        if (this.schemaName.equals("SESSION") && schemaDescriptor != null && schemaDescriptor.getUUID() == null) {
            throw StandardException.newException("42Y07", this.schemaName);
        }
        if (!dataDictionary.isSchemaEmpty(schemaDescriptor)) {
            throw StandardException.newException("X0Y54.S", this.schemaName);
        }
        dependencyManager.invalidateFor(schemaDescriptor, 32, languageConnectionContext);
        dataDictionary.dropSchemaDescriptor(this.schemaName, transactionController);
        schemaDescriptor = languageConnectionContext.getDefaultSchema();
        if (schemaDescriptor != null && this.schemaName.equals(schemaDescriptor.getSchemaName())) {
            languageConnectionContext.setDefaultSchema(null);
        }
    }

    DropSchemaConstantAction(String string) {
        this.schemaName = string;
    }
}

