/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.IndexChanger;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

public class IndexSetChanger {
    private static final int NO_INDEXES = 0;
    private static final int UPDATE_INDEXES = 1;
    private static final int ALL_INDEXES = 2;
    IndexRowGenerator[] irgs;
    long[] indexCIDS;
    private DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    private StaticCompiledOpenConglomInfo[] indexSCOCIs;
    String[] indexNames;
    ConglomerateController baseCC;
    FormatableBitSet baseRowReadMap;
    TransactionController tc;
    TemporaryRowHolderImpl rowHolder;
    IndexChanger[] indexChangers;
    private int lockMode;
    boolean[] fixOnUpdate;
    boolean isOpen = false;
    private int whatIsOpen = 0;
    private int isolationLevel;
    private Activation activation;

    public void open(boolean[] blArray) throws StandardException {
        this.fixOnUpdate = blArray;
        this.isOpen = true;
    }

    public void setRowHolder(TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this.rowHolder = temporaryRowHolderImpl;
    }

    private void openIndexes(int n) throws StandardException {
        if (this.whatIsOpen >= n) {
            return;
        }
        int n2 = 0;
        while (n2 < this.indexChangers.length) {
            if (n != 1 || this.fixOnUpdate[n2]) {
                if (this.indexChangers[n2] == null) {
                    this.indexChangers[n2] = new IndexChanger(this.irgs[n2], this.indexCIDS[n2], this.indexSCOCIs == null ? null : this.indexSCOCIs[n2], this.indexDCOCIs == null ? null : this.indexDCOCIs[n2], this.indexNames == null ? null : this.indexNames[n2], this.baseCC, this.tc, this.lockMode, this.baseRowReadMap, this.isolationLevel, this.activation);
                    this.indexChangers[n2].setRowHolder(this.rowHolder);
                } else {
                    this.indexChangers[n2].setBaseCC(this.baseCC);
                }
                this.indexChangers[n2].open();
            }
            ++n2;
        }
        this.whatIsOpen = n;
    }

    public void delete(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.openIndexes(2);
        int n = 0;
        while (n < this.indexChangers.length) {
            this.indexChangers[n].delete(execRow, rowLocation);
            ++n;
        }
    }

    public void insert(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.openIndexes(2);
        int n = 0;
        while (n < this.indexChangers.length) {
            this.indexChangers[n].insert(execRow, rowLocation);
            ++n;
        }
    }

    public void update(ExecRow execRow, ExecRow execRow2, RowLocation rowLocation) throws StandardException {
        this.openIndexes(1);
        int n = 0;
        while (n < this.indexChangers.length) {
            if (this.fixOnUpdate[n]) {
                this.indexChangers[n].update(execRow, execRow2, rowLocation);
            }
            ++n;
        }
    }

    public void setBaseCC(ConglomerateController conglomerateController) {
        int n = 0;
        while (n < this.indexChangers.length) {
            if (this.indexChangers[n] != null) {
                this.indexChangers[n].setBaseCC(conglomerateController);
            }
            ++n;
        }
        this.baseCC = conglomerateController;
    }

    public void finish() throws StandardException {
        int n = 0;
        while (n < this.indexChangers.length) {
            if (this.indexChangers[n] != null) {
                this.indexChangers[n].finish();
            }
            ++n;
        }
    }

    public void close() throws StandardException {
        this.whatIsOpen = 0;
        int n = 0;
        while (n < this.indexChangers.length) {
            if (this.indexChangers[n] != null) {
                this.indexChangers[n].close();
            }
            ++n;
        }
        this.fixOnUpdate = null;
        this.isOpen = false;
        this.rowHolder = null;
    }

    public String toString() {
        return null;
    }

    public IndexSetChanger(IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, DynamicCompiledOpenConglomInfo[] dynamicCompiledOpenConglomInfoArray, String[] stringArray, ConglomerateController conglomerateController, TransactionController transactionController, int n, FormatableBitSet formatableBitSet, int n2, Activation activation) throws StandardException {
        this.irgs = indexRowGeneratorArray;
        this.indexCIDS = lArray;
        this.indexSCOCIs = staticCompiledOpenConglomInfoArray;
        this.indexDCOCIs = dynamicCompiledOpenConglomInfoArray;
        this.indexNames = stringArray;
        this.baseCC = conglomerateController;
        this.tc = transactionController;
        this.lockMode = n;
        this.baseRowReadMap = formatableBitSet;
        this.isolationLevel = n2;
        this.activation = activation;
        this.indexChangers = new IndexChanger[indexRowGeneratorArray.length];
    }
}

