/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

public class UpdateVTIResultSet
extends DMLVTIResultSet {
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void openCore() throws StandardException {
        Object object;
        int n = -1;
        boolean bl = true;
        this.rs = this.activation.getTargetVTI();
        this.row = this.getNextRowCore(this.sourceResultSet);
        if (this.row != null) {
            n = this.row.nColumns();
        }
        if (!this.firstExecute) {
            this.lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.rowHolder == null && this.constants.deferred) {
            object = new Properties();
            this.rowHolder = new TemporaryRowHolderImpl(this.tc, (Properties)object, this.resultDescription);
        }
        try {
            while (this.row != null) {
                if (this.constants.deferred) {
                    if (bl) {
                        this.row.getColumn(n).setValue(this.rs.getRow());
                        bl = false;
                    } else {
                        object = this.row.cloneColumn(n);
                        object.setValue(this.rs.getRow());
                        this.row.setColumn(n, (DataValueDescriptor)object);
                    }
                    this.rowHolder.insert(this.row);
                } else {
                    this.updateVTI(this.rs);
                }
                ++this.rowCount;
                if (this.constants.singleRowSource) {
                    this.row = null;
                    continue;
                }
                this.row = this.getNextRowCore(this.sourceResultSet);
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        if (this.constants.deferred) {
            object = this.rowHolder.getResultSet();
            try {
                try {
                    ExecRow execRow = null;
                    object.open();
                    while ((execRow = object.getNextRow()) != null) {
                        this.row = execRow;
                        int n2 = this.row.getColumn(n).getInt();
                        this.rs.absolute(n2);
                        this.updateVTI(this.rs);
                    }
                }
                catch (Throwable throwable) {
                    throw StandardException.unexpectedUserException(throwable);
                }
                Object var5_9 = null;
                this.sourceResultSet.clearCurrentRow();
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.sourceResultSet.clearCurrentRow();
                object.close();
                throw throwable;
            }
            object.close();
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }

    private void updateVTI(ResultSet resultSet) throws StandardException {
        int[] nArray = this.constants.changedColumnIds;
        try {
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                DataValueDescriptor dataValueDescriptor = this.row.getColumn(n + 1);
                if (dataValueDescriptor.isNull()) {
                    resultSet.updateNull(n2);
                } else {
                    dataValueDescriptor.setInto(resultSet, n2);
                }
                ++n;
            }
            resultSet.updateRow();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public UpdateVTIResultSet(NoPutResultSet noPutResultSet, Activation activation) throws StandardException {
        super(noPutResultSet, activation);
    }
}

