/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.sql.Timestamp;
import java.util.Vector;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;

public final class RunTimeStatisticsImpl
implements RunTimeStatistics {
    public String statementText;
    public String statementName;
    public String spsName;
    public long parseTime;
    public long bindTime;
    public long optimizeTime;
    public long generateTime;
    public long compileTime;
    public long executeTime;
    public Timestamp beginCompilationTimestamp;
    public Timestamp endCompilationTimestamp;
    public Timestamp beginExecutionTimestamp;
    public Timestamp endExecutionTimestamp;
    public ResultSetStatistics topResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public long getCompileTimeInMillis() {
        return this.compileTime;
    }

    public long getParseTimeInMillis() {
        return this.parseTime;
    }

    public long getBindTimeInMillis() {
        return this.bindTime;
    }

    public long getOptimizeTimeInMillis() {
        return this.optimizeTime;
    }

    public long getGenerateTimeInMillis() {
        return this.generateTime;
    }

    public long getExecuteTimeInMillis() {
        return this.executeTime;
    }

    public Timestamp getBeginCompilationTimestamp() {
        return this.beginCompilationTimestamp;
    }

    public Timestamp getEndCompilationTimestamp() {
        return this.endCompilationTimestamp;
    }

    public Timestamp getBeginExecutionTimestamp() {
        return this.beginExecutionTimestamp;
    }

    public Timestamp getEndExecutionTimestamp() {
        return this.endExecutionTimestamp;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public String getSPSName() {
        return this.spsName;
    }

    public String getStatementText() {
        return this.statementText;
    }

    public double getEstimatedRowCount() {
        if (this.topResultSetStatistics == null) {
            return 0.0;
        }
        return this.topResultSetStatistics.getEstimatedRowCount();
    }

    public String getStatementExecutionPlanText() {
        if (this.topResultSetStatistics == null) {
            return null;
        }
        String string = "";
        if (this.subqueryTrackingArray != null) {
            boolean bl = false;
            int n = 0;
            while (n < this.subqueryTrackingArray.length) {
                if (this.subqueryTrackingArray[n] != null) {
                    if (!bl) {
                        string = MessageService.getTextMessage("43Y21.U") + ":\n";
                        bl = true;
                    }
                    string = string + this.subqueryTrackingArray[n].getStatementExecutionPlanText(1);
                }
                ++n;
            }
        }
        return string + this.topResultSetStatistics.getStatementExecutionPlanText(0);
    }

    public String getScanStatisticsText() {
        return this.topResultSetStatistics == null ? null : this.topResultSetStatistics.getScanStatisticsText(null, 0);
    }

    public String getScanStatisticsText(String string) {
        if (this.topResultSetStatistics == null) {
            return null;
        }
        String string2 = this.topResultSetStatistics.getScanStatisticsText(string, 0);
        return string2.equals("") ? null : string2;
    }

    public String toString() {
        String string = this.spsName != null ? "Stored Prepared Statement Name: \n\t" + this.spsName + "\n" : "";
        return string + MessageService.getTextMessage("43Y22.U") + ": \n\t" + this.statementName + "\n" + MessageService.getTextMessage("43Y23.U") + ": \n\t" + this.statementText + "\n" + MessageService.getTextMessage("43Y24.U") + ": " + this.parseTime + "\n" + MessageService.getTextMessage("43Y25.U") + ": " + this.bindTime + "\n" + MessageService.getTextMessage("43Y26.U") + ": " + this.optimizeTime + "\n" + MessageService.getTextMessage("43Y27.U") + ": " + this.generateTime + "\n" + MessageService.getTextMessage("43Y28.U") + ": " + this.compileTime + "\n" + MessageService.getTextMessage("43Y29.U") + ": " + this.executeTime + "\n" + MessageService.getTextMessage("43Y30.U") + " : " + this.beginCompilationTimestamp + "\n" + MessageService.getTextMessage("43Y31.U") + " : " + this.endCompilationTimestamp + "\n" + MessageService.getTextMessage("43Y32.U") + " : " + this.beginExecutionTimestamp + "\n" + MessageService.getTextMessage("43Y33.U") + " : " + this.endExecutionTimestamp + "\n" + MessageService.getTextMessage("43Y44.U") + ": \n" + this.getStatementExecutionPlanText();
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.topResultSetStatistics);
        return vector;
    }

    public RunTimeStatisticsImpl(String string, String string2, String string3, long l, long l2, long l3, long l4, long l5, long l6, Timestamp timestamp, Timestamp timestamp2, Timestamp timestamp3, Timestamp timestamp4, ResultSetStatistics[] resultSetStatisticsArray, ResultSetStatistics resultSetStatistics) {
        this.spsName = string;
        this.statementName = string2;
        this.statementText = string3;
        this.compileTime = l;
        this.parseTime = l2;
        this.bindTime = l3;
        this.optimizeTime = l4;
        this.generateTime = l5;
        this.executeTime = l6;
        this.beginCompilationTimestamp = timestamp;
        this.endCompilationTimestamp = timestamp2;
        this.beginExecutionTimestamp = timestamp3;
        this.endExecutionTimestamp = timestamp4;
        this.subqueryTrackingArray = resultSetStatisticsArray;
        this.topResultSetStatistics = resultSetStatistics;
    }
}

