/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BTreePostCommit;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.BTreeScanInfo;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;

public abstract class BTreeScan
extends OpenBTree
implements ScanManager {
    protected static final int SCAN_INIT = 1;
    protected static final int SCAN_INPROGRESS = 2;
    protected static final int SCAN_DONE = 3;
    protected static final int SCAN_HOLD_INIT = 4;
    protected static final int SCAN_HOLD_INPROGRESS = 5;
    protected Transaction init_rawtran = null;
    protected boolean init_forUpdate;
    protected FormatableBitSet init_scanColumnList;
    protected DataValueDescriptor[] init_template;
    protected DataValueDescriptor[] init_startKeyValue;
    protected int init_startSearchOperator = 0;
    protected Qualifier[][] init_qualifier = null;
    protected DataValueDescriptor[] init_stopKeyValue;
    protected int init_stopSearchOperator = 0;
    protected boolean init_hold;
    protected FetchDescriptor init_fetchDesc;
    protected FetchDescriptor init_lock_fetch_desc;
    BTreeRowPosition scan_position;
    protected boolean init_useUpdateLocks = false;
    protected int scan_state = 1;
    protected int stat_numpages_visited = 0;
    protected int stat_numrows_visited = 0;
    protected int stat_numrows_qualified = 0;
    protected int stat_numdeleted_rows_visited = 0;
    protected int lock_operation;
    protected DataValueDescriptor[][] fetchNext_one_slot_array = new DataValueDescriptor[1][];

    protected abstract int fetchRows(BTreeRowPosition var1, DataValueDescriptor[][] var2, RowLocation[] var3, BackingStoreHashtable var4, long var5, int[] var7) throws StandardException;

    private void initScanParams(DataValueDescriptor[] dataValueDescriptorArray, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n2) throws StandardException {
        this.init_startKeyValue = dataValueDescriptorArray;
        if (RowUtil.isRowEmpty(this.init_startKeyValue, null)) {
            this.init_startKeyValue = null;
        }
        this.init_startSearchOperator = n;
        if (qualifierArray != null && qualifierArray.length == 0) {
            qualifierArray = null;
        }
        this.init_qualifier = qualifierArray;
        this.init_stopKeyValue = dataValueDescriptorArray2;
        if (RowUtil.isRowEmpty(this.init_stopKeyValue, null)) {
            this.init_stopKeyValue = null;
        }
        this.init_stopSearchOperator = n2;
        this.scan_position = new BTreeRowPosition();
        this.scan_position.init();
        this.scan_position.current_lock_template = new DataValueDescriptor[this.init_template.length];
        this.scan_position.current_lock_row_loc = (RowLocation)((RowLocation)this.init_template[this.init_template.length - 1]).cloneObject();
        this.scan_position.current_lock_template[this.init_template.length - 1] = this.scan_position.current_lock_row_loc;
    }

    protected void positionAtStartForForwardScan(BTreeRowPosition bTreeRowPosition) throws StandardException {
        while (true) {
            boolean bl;
            ControlRow controlRow = ControlRow.Get(this, 1L);
            this.stat_numpages_visited += controlRow.getLevel() + 1;
            boolean bl2 = true;
            if (this.init_startKeyValue == null) {
                bTreeRowPosition.current_leaf = (LeafControlRow)controlRow.searchLeft(this);
                bTreeRowPosition.current_slot = 0;
                bl = false;
            } else {
                SearchParameters searchParameters = new SearchParameters(this.init_startKeyValue, this.init_startSearchOperator == 1 ? 1 : -1, this.init_template, this, false);
                bTreeRowPosition.current_leaf = (LeafControlRow)controlRow.search(searchParameters);
                bTreeRowPosition.current_slot = searchParameters.resultSlot;
                bl = searchParameters.resultExact;
                if (bl && this.init_startSearchOperator == 1) {
                    --bTreeRowPosition.current_slot;
                    if (this.getConglomerate().nUniqueColumns < this.getConglomerate().nKeyFields) {
                        bl2 = false;
                    }
                }
            }
            boolean bl3 = false;
            if (bl2) {
                bl3 = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), bTreeRowPosition, true, this.init_lock_fetch_desc, bTreeRowPosition.current_lock_template, bTreeRowPosition.current_lock_row_loc, true, this.init_forUpdate, this.lock_operation);
            } else {
                boolean bl4 = bl3 = !this.getLockingPolicy().lockScan(bTreeRowPosition.current_leaf, null, false, this.lock_operation);
            }
            if (!bl3) break;
            bTreeRowPosition.current_leaf = null;
        }
        this.scan_state = 2;
        bTreeRowPosition.current_scan_pageno = bTreeRowPosition.current_leaf.page.getPageNumber();
        bTreeRowPosition.current_slot = bTreeRowPosition.current_slot;
    }

    protected void positionAtStartForBackwardScan(BTreeRowPosition bTreeRowPosition) throws StandardException {
        while (true) {
            boolean bl;
            boolean bl2;
            ControlRow controlRow = ControlRow.Get(this, 1L);
            this.stat_numpages_visited += controlRow.getLevel() + 1;
            if (this.init_startKeyValue == null) {
                bTreeRowPosition.current_leaf = (LeafControlRow)controlRow.searchRight(this);
                bTreeRowPosition.current_slot = bTreeRowPosition.current_leaf.page.recordCount();
                bl2 = false;
            } else {
                SearchParameters searchParameters = new SearchParameters(this.init_startKeyValue, this.init_startSearchOperator == 1 ? -1 : 1, this.init_template, this, false);
                bTreeRowPosition.current_leaf = (LeafControlRow)controlRow.search(searchParameters);
                bTreeRowPosition.current_slot = searchParameters.resultSlot;
                bl2 = searchParameters.resultExact;
                if (bl2) {
                    if (this.init_startSearchOperator == 1) {
                        ++bTreeRowPosition.current_slot;
                    }
                } else {
                    ++bTreeRowPosition.current_slot;
                }
            }
            boolean bl3 = bl = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), bTreeRowPosition, true, this.init_lock_fetch_desc, bTreeRowPosition.current_lock_template, bTreeRowPosition.current_lock_row_loc, true, this.init_forUpdate, this.lock_operation);
            if (!bl) break;
            bTreeRowPosition.current_leaf = null;
        }
        this.scan_state = 2;
        bTreeRowPosition.current_scan_pageno = bTreeRowPosition.current_leaf.page.getPageNumber();
    }

    protected void positionAtNextPage(BTreeRowPosition bTreeRowPosition) throws StandardException {
        boolean bl;
        while ((bTreeRowPosition.next_leaf = (LeafControlRow)bTreeRowPosition.current_leaf.getRightSibling(this)) != null && (bl = !this.getLockingPolicy().lockScan(bTreeRowPosition.next_leaf, null, false, 0))) {
        }
        if (bTreeRowPosition.current_rh != null) {
            this.getLockingPolicy().unlockScanRecordAfterRead(bTreeRowPosition, this.init_forUpdate);
        }
        this.getLockingPolicy().unlockScan(bTreeRowPosition.current_leaf.page.getPageNumber());
        bTreeRowPosition.current_leaf.release();
        bTreeRowPosition.current_leaf = bTreeRowPosition.next_leaf;
        bTreeRowPosition.current_scan_pageno = bTreeRowPosition.next_leaf == null ? 0L : bTreeRowPosition.next_leaf.page.getPageNumber();
        bTreeRowPosition.current_slot = 0;
        bTreeRowPosition.current_rh = null;
    }

    abstract void positionAtStartPosition(BTreeRowPosition var1) throws StandardException;

    protected void positionAtDoneScanFromClose(BTreeRowPosition bTreeRowPosition) throws StandardException {
        if (!(bTreeRowPosition.current_rh == null || bTreeRowPosition.current_rh_qualified || bTreeRowPosition.current_leaf != null && bTreeRowPosition.current_leaf.page != null)) {
            if (!this.reposition(bTreeRowPosition, false)) {
                // empty if block
            }
            this.getLockingPolicy().unlockScanRecordAfterRead(bTreeRowPosition, this.init_forUpdate);
            bTreeRowPosition.current_rh = null;
            bTreeRowPosition.current_leaf.release();
            bTreeRowPosition.current_leaf = null;
        }
        if (bTreeRowPosition.current_scan_pageno != 0L) {
            this.getLockingPolicy().unlockScan(bTreeRowPosition.current_scan_pageno);
            bTreeRowPosition.current_scan_pageno = 0L;
        }
        bTreeRowPosition.current_slot = -1;
        bTreeRowPosition.current_rh = null;
        bTreeRowPosition.current_positionKey = null;
        this.scan_state = 3;
    }

    protected void positionAtDoneScan(BTreeRowPosition bTreeRowPosition) throws StandardException {
        if (bTreeRowPosition.current_scan_pageno != 0L) {
            this.getLockingPolicy().unlockScan(bTreeRowPosition.current_scan_pageno);
            bTreeRowPosition.current_scan_pageno = 0L;
        }
        bTreeRowPosition.current_slot = -1;
        bTreeRowPosition.current_rh = null;
        bTreeRowPosition.current_positionKey = null;
        this.scan_state = 3;
    }

    protected boolean process_qualifier(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        Qualifier qualifier;
        boolean bl = true;
        int n = 0;
        while (n < this.init_qualifier[0].length) {
            bl = false;
            qualifier = this.init_qualifier[0][n];
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[qualifier.getColumnId()];
            bl = dataValueDescriptor.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl2 = bl = !bl;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        n = 1;
        while (n < this.init_qualifier.length) {
            bl = false;
            int n2 = 0;
            while (n2 < this.init_qualifier[n].length) {
                qualifier = this.init_qualifier[n][n2];
                DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[qualifier.getColumnId()];
                bl = dataValueDescriptor.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
                if (qualifier.negateCompareResult()) {
                    boolean bl3 = bl = !bl;
                }
                if (bl) break;
                ++n2;
            }
            if (!bl) break;
            ++n;
        }
        return bl;
    }

    protected boolean reposition(BTreeRowPosition bTreeRowPosition, boolean bl) throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSCB4.S", new Integer(this.scan_state));
        }
        if (bTreeRowPosition.current_rh == null != (bTreeRowPosition.current_positionKey != null)) {
            throw StandardException.newException("XSCB7.S", new Boolean(bTreeRowPosition.current_rh == null), (Object)new Boolean(bTreeRowPosition.current_positionKey == null));
        }
        if (bTreeRowPosition.current_positionKey == null) {
            bTreeRowPosition.current_leaf = (LeafControlRow)ControlRow.Get(this, bTreeRowPosition.current_rh.getPageNumber());
            bTreeRowPosition.current_slot = bTreeRowPosition.current_leaf.page.getSlotNumber(bTreeRowPosition.current_rh);
        } else {
            boolean bl2;
            SearchParameters searchParameters = new SearchParameters(bTreeRowPosition.current_positionKey, 1, this.init_template, this, false);
            do {
                bTreeRowPosition.current_leaf = (LeafControlRow)ControlRow.Get(this, 1L).search(searchParameters);
                if (!searchParameters.resultExact && !bl) {
                    bTreeRowPosition.current_leaf.release();
                    bTreeRowPosition.current_leaf = null;
                    return false;
                }
                bl2 = !this.getLockingPolicy().lockScan(bTreeRowPosition.current_leaf, null, false, 0);
            } while (bl2);
            bTreeRowPosition.current_scan_pageno = bTreeRowPosition.current_leaf.page.getPageNumber();
            bTreeRowPosition.current_slot = searchParameters.resultSlot;
            bTreeRowPosition.current_positionKey = null;
        }
        return true;
    }

    public void init(TransactionManager transactionManager, Transaction transaction, boolean bl, int n, int n2, BTreeLockingPolicy bTreeLockingPolicy, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n3, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n4, BTree bTree, LogicalUndo logicalUndo, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        super.init(transactionManager, transactionManager, null, transaction, bl, n, n2, bTreeLockingPolicy, bTree, logicalUndo, dynamicCompiledOpenConglomInfo);
        this.init_rawtran = transaction;
        this.init_forUpdate = (n & 4) == 4;
        this.init_useUpdateLocks = (n & 0x1000) != 0;
        this.init_hold = bl;
        this.init_template = this.runtime_mem.get_template();
        this.init_scanColumnList = formatableBitSet;
        this.init_lock_fetch_desc = RowUtil.getFetchDescriptorConstant(this.init_template.length - 1);
        this.init_fetchDesc = new FetchDescriptor(this.init_template.length, this.init_scanColumnList, null);
        this.initScanParams(dataValueDescriptorArray, n3, qualifierArray, dataValueDescriptorArray2, n4);
        int n5 = this.lock_operation = this.init_forUpdate ? 1 : 0;
        if (this.init_useUpdateLocks) {
            this.lock_operation |= 8;
        }
    }

    public void close() throws StandardException {
        this.positionAtDoneScanFromClose(this.scan_position);
        super.close();
        this.init_rawtran = null;
        this.init_template = null;
        this.init_startKeyValue = null;
        this.init_qualifier = null;
        this.init_stopKeyValue = null;
        this.getXactMgr().closeMe(this);
    }

    public boolean delete() throws StandardException {
        boolean bl;
        block8: {
            bl = false;
            if (this.scan_state != 2) {
                throw StandardException.newException("XSAM5.S");
            }
            try {
                if (!this.reposition(this.scan_position, false)) {
                    throw StandardException.newException("XSAM6.S", new Long(this.err_containerid), (Object)new Long(this.scan_position.current_rh.getId()));
                }
                if (this.init_useUpdateLocks) {
                    boolean bl2;
                    boolean bl3 = bl2 = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), this.scan_position, false, this.init_lock_fetch_desc, this.scan_position.current_lock_template, this.scan_position.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                    if (bl2 && this.reposition(this.scan_position, false)) {
                        throw StandardException.newException("XSAM6.S", new Long(this.err_containerid), (Object)new Long(this.scan_position.current_rh.getId()));
                    }
                }
                RecordHandle recordHandle = this.scan_position.current_leaf.page.fetchFromSlot(null, this.scan_position.current_slot, RowUtil.EMPTY_ROW, null, true);
                bl = this.scan_position.current_leaf.page.delete(recordHandle, this.btree_undo);
                if (this.scan_position.current_leaf.page.nonDeletedRecordCount() != 1 || this.scan_position.current_leaf.getIsRoot() && this.scan_position.current_leaf.getLevel() == 0) break block8;
                this.getXactMgr().addPostCommitWork(new BTreePostCommit(this.getXactMgr().getAccessManager(), this.getConglomerate(), this.scan_position.current_leaf.page.getPageNumber()));
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                if (this.scan_position.current_leaf != null) {
                    this.scan_position.current_leaf.release();
                    this.scan_position.current_leaf = null;
                }
                throw throwable;
            }
        }
        Object var3_4 = null;
        if (this.scan_position.current_leaf != null) {
            this.scan_position.current_leaf.release();
            this.scan_position.current_leaf = null;
        }
        return bl;
    }

    public void didNotQualify() throws StandardException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doesCurrentPositionQualify() throws StandardException {
        boolean bl;
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        try {
            if (!this.reposition(this.scan_position, false)) {
                boolean bl2 = false;
                Object var2_3 = null;
                if (this.scan_position.current_leaf == null) return bl2;
                this.scan_position.current_leaf.release();
                this.scan_position.current_leaf = null;
                return bl2;
            }
            bl = !this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot);
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            if (this.scan_position.current_leaf == null) throw throwable;
            this.scan_position.current_leaf.release();
            this.scan_position.current_leaf = null;
            throw throwable;
        }
        Object var2_4 = null;
        if (this.scan_position.current_leaf == null) return bl;
        this.scan_position.current_leaf.release();
        this.scan_position.current_leaf = null;
        return bl;
    }

    public void fetch(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        try {
            if (!this.reposition(this.scan_position, false)) {
                throw StandardException.newException("XSAM6.S", new Long(this.err_containerid), (Object)new Long(this.scan_position.current_rh.getId()));
            }
            this.scan_position.current_rh = this.scan_position.current_leaf.page.fetchFromSlot(null, this.scan_position.current_slot, dataValueDescriptorArray, this.init_fetchDesc, true);
            if (this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot)) {
                // empty if block
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.scan_position.current_leaf != null) {
                this.scan_position.current_leaf.release();
                this.scan_position.current_leaf = null;
            }
            throw throwable;
        }
        Object var3_2 = null;
        if (this.scan_position.current_leaf != null) {
            this.scan_position.current_leaf.release();
            this.scan_position.current_leaf = null;
        }
    }

    public ScanInfo getScanInfo() throws StandardException {
        return new BTreeScanInfo(this);
    }

    public boolean isCurrentPositionDeleted() throws StandardException {
        boolean bl;
        block6: {
            if (this.scan_state != 2) {
                throw StandardException.newException("XSAM5.S");
            }
            try {
                if (this.reposition(this.scan_position, false)) {
                    bl = this.scan_position.current_leaf.page.isDeletedAtSlot(this.scan_position.current_slot);
                    break block6;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.scan_position.current_leaf != null) {
                    this.scan_position.current_leaf.release();
                    this.scan_position.current_leaf = null;
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (this.scan_position.current_leaf != null) {
            this.scan_position.current_leaf.release();
            this.scan_position.current_leaf = null;
        }
        return bl;
    }

    public boolean isKeyed() {
        return true;
    }

    public boolean next() throws StandardException {
        this.fetchNext_one_slot_array[0] = this.runtime_mem.get_scratch_row();
        boolean bl = this.fetchRows(this.scan_position, this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return bl;
    }

    public boolean fetchNext(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        this.fetchNext_one_slot_array[0] = dataValueDescriptorArray;
        boolean bl = this.fetchRows(this.scan_position, this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return bl;
    }

    public int fetchNextGroup(DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray) throws StandardException {
        return this.fetchRows(this.scan_position, dataValueDescriptorArray, rowLocationArray, null, dataValueDescriptorArray.length, null);
    }

    public void fetchSet(long l, int[] nArray, BackingStoreHashtable backingStoreHashtable) throws StandardException {
        this.fetchRows(this.scan_position, null, null, backingStoreHashtable, l, nArray);
    }

    public final void reopenScan(DataValueDescriptor[] dataValueDescriptorArray, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n2) throws StandardException {
        if (this.scan_position.current_rh != null) {
            if (!this.reposition(this.scan_position, false)) {
                // empty if block
            }
            this.getLockingPolicy().unlockScanRecordAfterRead(this.scan_position, this.init_forUpdate);
            this.scan_position.current_rh = null;
            this.scan_position.current_leaf.release();
            this.scan_position.current_leaf = null;
        }
        if (this.scan_position.current_scan_pageno != 0L) {
            this.getLockingPolicy().unlockScan(this.scan_position.current_scan_pageno);
            this.scan_position.current_scan_pageno = 0L;
        }
        this.scan_position.current_slot = -1;
        this.scan_position.current_rh = null;
        this.scan_position.current_positionKey = null;
        this.initScanParams(dataValueDescriptorArray, n, qualifierArray, dataValueDescriptorArray2, n2);
        this.scan_state = !this.init_hold ? 1 : (this.container != null ? 1 : 4);
    }

    public void reopenScanByRowLocation(RowLocation rowLocation, Qualifier[][] qualifierArray) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public void fetchLocation(RowLocation rowLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean replace(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean closeForEndTransaction(boolean bl) throws StandardException {
        if (!this.init_hold || bl) {
            this.positionAtDoneScan(this.scan_position);
            super.close();
            this.init_rawtran = null;
            this.init_template = null;
            this.init_startKeyValue = null;
            this.init_qualifier = null;
            this.init_stopKeyValue = null;
            this.getXactMgr().closeMe(this);
            return true;
        }
        if (this.scan_state == 2) {
            if (this.scan_position.current_positionKey == null) {
                this.savePosition();
            }
            this.scan_state = 5;
        } else if (this.scan_state == 1) {
            this.scan_state = 4;
        }
        super.close();
        return false;
    }

    private void savePosition() throws StandardException {
        if (this.scan_state == 2) {
            block5: {
                try {
                    if (this.scan_position.current_rh == null || !this.reposition(this.scan_position, false)) break block5;
                    this.scan_position.current_positionKey = this.runtime_mem.get_row_for_export();
                    Page page = this.scan_position.current_leaf.getPage();
                    RecordHandle recordHandle = page.fetchFromSlot(null, page.getSlotNumber(this.scan_position.current_rh), this.scan_position.current_positionKey, null, true);
                    this.scan_position.current_rh = null;
                    this.scan_position.current_slot = -1;
                    if (this.scan_position.current_scan_pageno == 0L) break block5;
                    this.getLockingPolicy().unlockScan(this.scan_position.current_scan_pageno);
                    this.scan_position.current_scan_pageno = 0L;
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    if (this.scan_position.current_leaf != null) {
                        this.scan_position.current_leaf.release();
                        this.scan_position.current_leaf = null;
                    }
                    throw throwable;
                }
            }
            Object var2_3 = null;
            if (this.scan_position.current_leaf != null) {
                this.scan_position.current_leaf.release();
                this.scan_position.current_leaf = null;
            }
        }
    }

    public void savePosition(Conglomerate conglomerate, Page page) throws StandardException {
        if (this.getConglomerate() == conglomerate && this.scan_state == 2 && this.scan_position.current_rh != null && page.getPageNumber() == this.scan_position.current_rh.getPageNumber()) {
            this.scan_position.current_positionKey = this.runtime_mem.get_row_for_export();
            RecordHandle recordHandle = page.fetchFromSlot(null, page.getSlotNumber(this.scan_position.current_rh), this.scan_position.current_positionKey, null, true);
            this.scan_position.current_rh = null;
            this.scan_position.current_slot = -1;
            if (this.scan_position.current_scan_pageno != 0L) {
                this.getLockingPolicy().unlockScan(this.scan_position.current_scan_pageno);
                this.scan_position.current_scan_pageno = 0L;
            }
        }
    }

    public RecordHandle getCurrentRecordHandleForDebugging() {
        return this.scan_position.current_rh;
    }

    public String toString() {
        return null;
    }
}

