/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.store.access.btree.BTree;

public class BranchRow {
    public static final long DUMMY_PAGE_NUMBER = -1L;
    private DataValueDescriptor[] branchrow = null;

    private SQLLongint getChildPage() {
        return (SQLLongint)this.branchrow[this.branchrow.length - 1];
    }

    public static BranchRow createEmptyTemplate(BTree bTree) throws StandardException {
        BranchRow branchRow = new BranchRow(bTree);
        return new BranchRow(bTree);
    }

    public BranchRow createBranchRowFromOldBranchRow(long l) {
        BranchRow branchRow = new BranchRow();
        branchRow.branchrow = new DataValueDescriptor[this.branchrow.length];
        System.arraycopy(this.branchrow, 0, branchRow.branchrow, 0, branchRow.branchrow.length - 1);
        branchRow.branchrow[branchRow.branchrow.length - 1] = new SQLLongint(l);
        return branchRow;
    }

    public static BranchRow createBranchRowFromOldLeafRow(DataValueDescriptor[] dataValueDescriptorArray, long l) {
        BranchRow branchRow = new BranchRow();
        branchRow.branchrow = new DataValueDescriptor[dataValueDescriptorArray.length + 1];
        System.arraycopy(dataValueDescriptorArray, 0, branchRow.branchrow, 0, dataValueDescriptorArray.length);
        branchRow.branchrow[branchRow.branchrow.length - 1] = new SQLLongint(l);
        return branchRow;
    }

    protected DataValueDescriptor[] getRow() {
        return this.branchrow;
    }

    protected void setPageNumber(long l) {
        this.getChildPage().setValue(l);
    }

    public String toString() {
        return null;
    }

    private BranchRow() {
    }

    private BranchRow(BTree bTree) throws StandardException {
        SQLLongint sQLLongint = new SQLLongint(-1L);
        this.branchrow = bTree.createBranchTemplate(sQLLongint);
    }
}

