/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public class CopyRowsOperation
extends PhysicalPageOperation {
    protected int num_rows;
    protected int destSlot;
    protected int[] recordIds;
    protected int[] reservedSpace;
    protected transient ByteArray preparedLog;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.num_rows);
        CompressedNumber.writeInt(objectOutput, this.destSlot);
        int n = 0;
        while (n < this.num_rows) {
            CompressedNumber.writeInt(objectOutput, this.recordIds[n]);
            CompressedNumber.writeInt(objectOutput, this.reservedSpace[n]);
            ++n;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.num_rows = CompressedNumber.readInt(objectInput);
        this.destSlot = CompressedNumber.readInt(objectInput);
        this.recordIds = new int[this.num_rows];
        this.reservedSpace = new int[this.num_rows];
        int n = 0;
        while (n < this.num_rows) {
            this.recordIds[n] = CompressedNumber.readInt(objectInput);
            this.reservedSpace[n] = CompressedNumber.readInt(objectInput);
            ++n;
        }
    }

    public int getTypeFormatId() {
        return 210;
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n = 0;
        while (n < this.num_rows) {
            this.page.storeRecord(logInstant, this.destSlot + n, true, limitObjectInput);
            if (this.reservedSpace[n] > 0) {
                this.page.reserveSpaceForSlot(logInstant, this.destSlot + n, this.reservedSpace[n]);
            }
            ++n;
        }
    }

    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n = this.num_rows - 1;
        while (n >= 0) {
            int n2 = basePage.findRecordById(this.recordIds[n], n);
            basePage.purgeRecord(logInstant, n2, this.recordIds[n]);
            --n;
        }
        basePage.setAuxObject(null);
    }

    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.undoMe(transaction, basePage, logInstant, limitObjectInput);
    }

    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction, BasePage basePage, int n) throws StandardException, IOException {
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = rawTransaction.getLogBuffer();
        int n2 = dynamicByteArrayOutputStream.getPosition();
        int[] nArray = new int[this.num_rows];
        int n3 = dynamicByteArrayOutputStream.getPosition();
        int n4 = 0;
        while (n4 < this.num_rows) {
            basePage.logRecord(n4 + n, 0, this.recordIds[n4], null, dynamicByteArrayOutputStream, null);
            nArray[n4] = dynamicByteArrayOutputStream.getPosition() - n3;
            n3 = dynamicByteArrayOutputStream.getPosition();
            int n5 = n4;
            nArray[n5] = nArray[n5] + this.reservedSpace[n4];
            ++n4;
        }
        if (!this.page.spaceForCopy(this.num_rows, nArray)) {
            throw StandardException.newException("XSDA3.S");
        }
        n4 = dynamicByteArrayOutputStream.getPosition() - n2;
        dynamicByteArrayOutputStream.setPosition(n2);
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n2, n4);
    }

    public String toString() {
        return null;
    }

    public CopyRowsOperation(RawTransaction rawTransaction, BasePage basePage, BasePage basePage2, int n, int n2, int n3, int[] nArray) throws StandardException {
        super(basePage);
        this.num_rows = n2;
        this.destSlot = n;
        this.recordIds = nArray;
        try {
            this.reservedSpace = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.reservedSpace[n4] = basePage2.getReservedCount(n4 + n3);
                ++n4;
            }
            this.writeOptionalDataToBuffer(rawTransaction, basePage2, n3);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public CopyRowsOperation() {
    }
}

