/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.data.oda.jdbc.IConnectionFactory;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class JDBCDriverManager {
    private HashSet registeredDrivers = new HashSet();
    private HashMap cachedDriversMap = new HashMap();
    private HashMap driverExtensions = null;
    private DriverClassLoader extraDriverLoader = null;
    private static JDBCDriverManager instance;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    private JDBCDriverManager() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "JDBCDriverManager", "JDBCDriverManager starts up");
    }

    public static synchronized JDBCDriverManager getInstance() {
        if (instance == null) {
            instance = new JDBCDriverManager();
        }
        return instance;
    }

    public Connection getConnection(String driverClass, String url, Properties connectionProperties) throws SQLException, OdaException {
        if (url == null) {
            throw new NullPointerException("getConnection: url is null ");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Request JDBC Connection: driverClass=" + (driverClass == null ? "" : driverClass) + "; url=" + url);
        }
        return this.doConnect(driverClass, url, connectionProperties);
    }

    public Connection getConnection(String driverClass, String url, String user, String password) throws SQLException, OdaException {
        if (url == null) {
            throw new NullPointerException("getConnection: url is null ");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Request JDBC Connection: driverClass=" + (driverClass == null ? "" : driverClass) + "; url=" + url + "; user=" + (user == null ? "" : user));
        }
        Properties props = new Properties();
        if (user != null) {
            props.setProperty("user", user);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        return this.doConnect(driverClass, url, props);
    }

    private synchronized Connection doConnect(String driverClass, String url, Properties connectionProperties) throws SQLException, OdaException {
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        IConnectionFactory factory = this.getDriverConnectionFactory(driverClass);
        if (factory != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Calling IConnectionFactory.getConnection. driverClass=" + driverClass + ", url=" + url);
            }
            return factory.getConnection(driverClass, url, connectionProperties);
        }
        this.loadAndRegisterDriver(driverClass);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Calling DriverManager.getConnection. url=" + url);
        }
        return DriverManager.getConnection(url, connectionProperties);
    }

    private IConnectionFactory getDriverConnectionFactory(String driverClass) throws OdaException {
        this.loadDriverExtensions();
        IConnectionFactory factory = null;
        Object driverInfo = null;
        if (driverClass != null) {
            driverInfo = this.driverExtensions.get(driverClass);
        }
        if (driverInfo != null) {
            if (driverInfo instanceof IConfigurationElement) {
                String factoryClass = ((IConfigurationElement)driverInfo).getAttribute("connectionFactory");
                try {
                    factory = (IConnectionFactory)((IConfigurationElement)driverInfo).createExecutableExtension("connectionFactory");
                    logger.fine("Created connection factory class " + factoryClass + " for driverClass " + driverClass);
                }
                catch (FrameworkException e) {
                    JDBCException ex = new JDBCException("odajdbc.CannotInstantiateFactory", null, new Object[]{factoryClass, driverClass});
                    logger.log(Level.WARNING, "Failed to instantiate connection factory for driverClass " + driverClass, ex);
                    throw ex;
                }
                if (!$assertionsDisabled && factory == null) {
                    throw new AssertionError();
                }
                this.driverExtensions.put(driverClass, factory);
            } else {
                if (!$assertionsDisabled && !(driverInfo instanceof IConnectionFactory)) {
                    throw new AssertionError();
                }
                factory = driverInfo;
            }
        }
        return factory;
    }

    private void loadDriverExtensions() {
        if (this.driverExtensions != null) {
            return;
        }
        this.driverExtensions = new HashMap();
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint("org.eclipse.birt.report.data.oda.jdbc.driverinfo");
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        if (exts == null) {
            return;
        }
        int e = 0;
        while (e < exts.length) {
            IConfigurationElement[] configElems = exts[e].getConfigurationElements();
            if (configElems != null) {
                int i = 0;
                while (i < configElems.length) {
                    if (configElems[i].getName().equals("jdbcDriver")) {
                        String driverClass = configElems[i].getAttribute("driverClass");
                        String connectionFactory = configElems[i].getAttribute("connectionFactory");
                        logger.info("Found JDBC driverinfo extension: driverClass=" + driverClass + ", connectionFactory=" + connectionFactory);
                        if (driverClass != null && driverClass.length() > 0 && connectionFactory != null && connectionFactory.length() > 0) {
                            this.driverExtensions.put(driverClass, configElems[i]);
                        }
                    }
                    ++i;
                }
            }
            ++e;
        }
    }

    public boolean testConnection(String driverClassName, String connectionString, String userId, String password) throws OdaException {
        boolean canConnect = false;
        try {
            if (this.getDriverConnectionFactory(driverClassName) != null) {
                this.tryCreateConnection(driverClassName, connectionString, userId, password);
                return true;
            }
            this.loadAndRegisterDriver(driverClassName);
            if (this.cachedDriversMap.get(driverClassName) == null) {
                Enumeration<Driver> enumeration = DriverManager.getDrivers();
                while (enumeration.hasMoreElements()) {
                    Driver driver = enumeration.nextElement();
                    if (!this.isExpectedDriver(driver, driverClassName) || !driver.acceptsURL(connectionString)) continue;
                    this.cachedDriversMap.put(driverClassName, driver);
                    this.tryCreateConnection(driverClassName, connectionString, userId, password);
                    canConnect = true;
                    break;
                }
                if (!canConnect) {
                    throw new JDBCException("odajdbc.CannotParseURL", null);
                }
            } else if (((Driver)this.cachedDriversMap.get(driverClassName)).acceptsURL(connectionString)) {
                this.tryCreateConnection(driverClassName, connectionString, userId, password);
                canConnect = true;
            }
        }
        catch (SQLException e) {
            throw new JDBCException(e.getLocalizedMessage(), null);
        }
        if (!canConnect) {
            throw new JDBCException("odajdbc.NoSuitableDriver", null);
        }
        return true;
    }

    private boolean isExpectedDriver(Driver driver, String className) {
        String actual = driver instanceof WrappedDriver ? driver.toString() : driver.getClass().getName();
        return this.isExpectedDriverClass(actual, className);
    }

    private boolean isExpectedDriverClass(String actual, String expected) {
        String actualPkg = actual.substring(0, actual.lastIndexOf(46));
        String expectedPkg = expected.substring(0, expected.lastIndexOf(46));
        return actualPkg.equals(expectedPkg);
    }

    private void tryCreateConnection(String driverClassName, String connectionString, String userId, String password) throws SQLException, OdaException {
        Connection testConn = this.getConnection(driverClassName, connectionString, userId, password);
        if (!$assertionsDisabled && testConn == null) {
            throw new AssertionError();
        }
        testConn.close();
    }

    private void loadAndRegisterDriver(String className) throws OdaException {
        boolean driverInClassPath;
        Class driverClass;
        block12: {
            if (className == null || className.length() == 0) {
                return;
            }
            driverClass = null;
            if (this.registeredDrivers.contains(className)) {
                return;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Loading JDBC driver class: " + className);
            }
            driverInClassPath = false;
            try {
                Class.forName(className);
                logger.info("Loaded JDBC driver class in class path: " + className);
                driverInClassPath = true;
            }
            catch (ClassNotFoundException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.info("Driver class not in class path: " + className + ". Trying to locate driver in drivers directory");
                }
                if ((driverClass = this.loadExtraDriver(className, true)) != null) break block12;
                logger.warning("Failed to load JDBC driver class: " + className);
                throw new JDBCException("odajdbc.CannotLoadDriverClass", null, className);
            }
        }
        if (!driverInClassPath) {
            Driver driver = null;
            try {
                driver = (Driver)driverClass.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create new instance of JDBC driver:" + className, e);
                throw new JDBCException("odajdbc.CannotInstantiateDriverClass", null, className);
            }
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Registering with DriverManager: wrapped driver for " + className);
                }
                DriverManager.registerDriver(new WrappedDriver(driver, className));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Failed to register wrapped driver instance.", e);
            }
        }
        this.registeredDrivers.add(className);
    }

    private Class loadExtraDriver(String className, boolean refreshUrlsWhenFail) {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        if (this.extraDriverLoader == null) {
            this.extraDriverLoader = new DriverClassLoader();
        }
        try {
            return this.extraDriverLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (refreshUrlsWhenFail && this.extraDriverLoader.refreshURLs()) {
                return this.loadExtraDriver(className, false);
            }
            logger.log(Level.FINER, "Driver class not found in drivers directory: " + className);
            return null;
        }
    }

    private static class DriverClassLoader
    extends URLClassLoader {
        private IBundle bundle;
        private HashSet fileSet;
        static /* synthetic */ Class class$0;

        public DriverClassLoader() {
            URL[] uRLArray = new URL[]{};
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager$DriverClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(uRLArray, clazz.getClassLoader());
            this.fileSet = new HashSet();
            Logger logger = logger;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager$DriverClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.entering(clazz2.getName(), "constructor()");
            this.bundle = Platform.getBundle((String)"org.eclipse.birt.report.data.oda.jdbc");
            if (this.bundle == null) {
                logger.severe("Failed to get Bundle object");
            } else {
                this.refreshURLs();
            }
        }

        public boolean refreshURLs() {
            if (this.bundle == null) {
                return false;
            }
            boolean foundNew = false;
            Enumeration files = this.bundle.getEntryPaths("drivers");
            while (files.hasMoreElements()) {
                String fileName = (String)files.nextElement();
                if (!OdaJdbcDriver.isDriverFile(fileName) || this.fileSet.contains(fileName)) continue;
                foundNew = true;
                this.fileSet.add(fileName);
                URL fileURL = this.bundle.getEntry(fileName);
                this.addURL(fileURL);
                logger.info("JDBCDriverManager: found JAR file " + fileName + ". URL=" + fileURL);
            }
            return foundNew;
        }
    }

    private static class WrappedDriver
    implements Driver {
        private Driver driver;
        private String driverClass;
        static /* synthetic */ Class class$0;

        WrappedDriver(Driver d, String driverClass) {
            Logger logger = logger;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager$WrappedDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.entering(clazz.getName(), "WrappedDriver", driverClass);
            this.driver = d;
            this.driverClass = driverClass;
        }

        public boolean acceptsURL(String u) throws SQLException {
            boolean res = this.driver.acceptsURL(u);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "WrappedDriver(" + this.driverClass + ").acceptsURL(" + u + ")returns: " + res);
            }
            return res;
        }

        public Connection connect(String u, Properties p) throws SQLException {
            Logger logger = logger;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager$WrappedDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.entering(String.valueOf(clazz.getName()) + ":" + this.driverClass, "connect", u);
            return this.driver.connect(u, p);
        }

        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        public String toString() {
            return this.driverClass;
        }
    }
}

