/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public class OdaJdbcDriver
implements IDriver {
    private static String className;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
        logger = Logger.getLogger(className);
    }

    public IConnection getConnection(String connectionClassName) throws OdaException {
        logger.logp(Level.FINE, className, "getConnection", "JDBCConnectionFactory.getConnection( ) connectionClassName=" + connectionClassName);
        return new Connection();
    }

    public int getMaxConnections() throws OdaException {
        return 0;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void setLogConfiguration(LogConfiguration logConfig) throws OdaException {
        String formatterClassName;
        String methodName = "setLogConfiguration";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String className = clazz.getName();
        Logger pkgLogger = Logger.getLogger(className.substring(0, className.lastIndexOf(".")));
        switch (logConfig.getLogLevel()) {
            case -2147483648: {
                pkgLogger.setLevel(Level.ALL);
                break;
            }
            case 300: {
                pkgLogger.setLevel(Level.FINEST);
                break;
            }
            case 400: {
                pkgLogger.setLevel(Level.FINER);
                break;
            }
            case 500: {
                pkgLogger.setLevel(Level.FINE);
                break;
            }
            case 700: {
                pkgLogger.setLevel(Level.CONFIG);
                break;
            }
            case 800: {
                pkgLogger.setLevel(Level.INFO);
                break;
            }
            case 900: {
                pkgLogger.setLevel(Level.WARNING);
                break;
            }
            case 1000: {
                pkgLogger.setLevel(Level.SEVERE);
                break;
            }
            case 0x7FFFFFFF: {
                pkgLogger.setLevel(Level.OFF);
                break;
            }
            default: {
                if (logConfig.getLogLevel() > 1000) {
                    pkgLogger.setLevel(Level.OFF);
                    break;
                }
                logger.logp(Level.WARNING, className, "setLogConfiguration", String.valueOf(logConfig.getLogLevel()) + " is not a valid log level.");
            }
        }
        if (pkgLogger.getLevel() == Level.OFF) {
            return;
        }
        Handler handler = OdaJdbcDriver.setLogHandler(pkgLogger, logConfig);
        if (handler == null) {
            logger.logp(Level.WARNING, className, "setLogConfiguration", "Cannot create log handler for package.");
            return;
        }
        if (pkgLogger.getLevel() != null) {
            handler.setLevel(pkgLogger.getLevel());
        }
        if ((formatterClassName = logConfig.getFormatterClassName()) == null || formatterClassName.length() == 0) {
            return;
        }
        if (handler.getFormatter() != null && formatterClassName.equals(handler.getFormatter().getClass().getName())) {
            return;
        }
        try {
            Class<?> formatterClass = Class.forName(formatterClassName);
            handler.setFormatter((Formatter)formatterClass.newInstance());
        }
        catch (Exception ex) {
            logger.logp(Level.WARNING, className, "setLogConfiguration", "Cannot setup Formatter object.", ex);
        }
    }

    private static URL getInstallDirectory() throws OdaException, IOException {
        ExtensionManifest extMF = null;
        try {
            extMF = ManifestExplorer.getInstance().getExtensionManifest("org.eclipse.birt.report.data.oda.jdbc");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (extMF != null) {
            return extMF.getDriverLocation();
        }
        return null;
    }

    public static File getDriverDirectory() throws OdaException, IOException {
        URL url = OdaJdbcDriver.getInstallDirectory();
        if (url == null) {
            return null;
        }
        File result = null;
        try {
            URI uri = new URI(url.toString());
            result = new File(uri.getPath(), "drivers");
        }
        catch (URISyntaxException e) {
            result = new File(url.getFile(), "drivers");
        }
        return result;
    }

    public static List getDriverFileList() throws OdaException, IOException {
        File driverHomeDir = OdaJdbcDriver.getDriverDirectory();
        String[] files = driverHomeDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return OdaJdbcDriver.isDriverFile(name);
            }
        });
        ArrayList<File> retList = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            retList.add(new File(driverHomeDir, files[i]));
            ++i;
        }
        return retList;
    }

    static boolean isDriverFile(String fileName) {
        String lcName = fileName.toLowerCase();
        return lcName.endsWith(".jar") || lcName.endsWith(".zip");
    }

    private static Handler setLogHandler(Logger pkgLogger, LogConfiguration logConfig) {
        String methodName = "setLogHandler";
        Handler handler = null;
        Handler[] handlers = pkgLogger.getHandlers();
        int numHandlers = handlers.length;
        String logDirectory = logConfig.getLogDirectory();
        String logPrefix = logConfig.getLogPrefix();
        if (logDirectory == null || logDirectory.length() == 0 || logPrefix == null || logPrefix.length() == 0) {
            int i = 0;
            while (i < numHandlers) {
                handler = handlers[i];
                if (handler instanceof ConsoleHandler) {
                    return handler;
                }
                ++i;
            }
            handler = new ConsoleHandler();
            pkgLogger.addHandler(handler);
            return handler;
        }
        int i = 0;
        while (i < numHandlers) {
            handler = handlers[i];
            if (handler instanceof FileHandler) {
                return handler;
            }
            ++i;
        }
        try {
            handler = new FileHandler(OdaJdbcDriver.generateFileName(logDirectory, logPrefix), true);
            pkgLogger.addHandler(handler);
        }
        catch (Exception ex) {
            logger.logp(Level.WARNING, className, "setLogHandler", "Cannot create FileHandler.", ex);
        }
        return handler;
    }

    private static String generateFileName(String logDirectory, String logPrefix) {
        File logDir = new File(logDirectory);
        if (logDir.isDirectory() && !logDir.isAbsolute() || logDirectory.startsWith(".")) {
            try {
                URL url = OdaJdbcDriver.getInstallDirectory();
                if (url != null) {
                    String driverHomeDir = url.getPath();
                    logDir = new File(driverHomeDir, logDirectory);
                    logDirectory = logDir.getPath();
                }
            }
            catch (OdaException url) {
            }
            catch (IOException url) {
                // empty catch block
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String logfileName = logDirectory.endsWith("/") || logDirectory.endsWith("\\") ? logDirectory : String.valueOf(logDirectory) + "/";
        logfileName = String.valueOf(logfileName) + logPrefix + "-";
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        logfileName = String.valueOf(logfileName) + dateFormat.format(timestamp) + ".log";
        return logfileName;
    }

    public static final class Constants {
        public static final String DRIVER_DIRECTORY = "drivers";
        public static final String DATA_SOURCE_ID = "org.eclipse.birt.report.data.oda.jdbc";
        public static final String DRIVER_INFO_EXTENSION = "org.eclipse.birt.report.data.oda.jdbc.driverinfo";
        public static final String DRIVER_INFO_ATTR_NAME = "name";
        public static final String DRIVER_INFO_ATTR_DRIVERCLASS = "driverClass";
        public static final String DRIVER_INFO_ATTR_URLTEMPL = "urlTemplate";
        public static final String DRIVER_INFO_ATTR_CONNFACTORY = "connectionFactory";
        public static final String DRIVER_INFO_ELEM_JDBCDRIVER = "jdbcDriver";
    }
}

