/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;

public class SqlBlobUtil {
    public static Blob newBlob(InputStream inputStream) {
        return new BlobHelper(inputStream);
    }

    private static class BlobHelper
    implements Blob {
        private InputStream inputStream;
        private boolean isInit;
        private int length = -1;
        private byte[] bytes = null;

        BlobHelper(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        private void init() throws SQLException {
            if (this.isInit) {
                return;
            }
            ArrayList<Integer> byteList = new ArrayList<Integer>();
            try {
                int b;
                while ((b = this.inputStream.read()) != -1) {
                    byteList.add(new Integer(b));
                }
                this.inputStream.close();
            }
            catch (IOException e1) {
                throw new SQLException("can not read from blob data");
            }
            this.length = byteList.size();
            this.bytes = new byte[this.length];
            int i = 0;
            while (i < this.length) {
                this.bytes[i] = (byte)((Integer)byteList.get(i)).intValue();
                ++i;
            }
            byteList = null;
            this.isInit = true;
        }

        public long length() throws SQLException {
            this.init();
            return this.length;
        }

        public void truncate(long len) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        public byte[] getBytes(long pos, int length) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        public int setBytes(long pos, byte[] bytes) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        public long position(byte[] pattern, long start) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        public InputStream getBinaryStream() throws SQLException {
            this.init();
            return new ByteArrayInputStream(this.bytes);
        }

        public OutputStream setBinaryStream(long pos) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        public long position(Blob pattern, long start) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }
    }
}

