/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.ParameterMetaData;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;

public class Statement
implements IQuery {
    private PreparedStatement preStat;
    private Connection conn;
    private int maxrows;
    private boolean maxRowsUpToDate = false;
    private static final String ERRMSG_SET_PARAMETER = "Error setting value for SQL parameter #";
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    private void assertNotNull(Object o) throws OdaException {
        if (o == null) {
            throw new JDBCException("odajdbc.driver.StatementCannotNull", 117);
        }
    }

    public Statement(Connection connection) throws OdaException {
        if (connection == null) {
            throw new JDBCException("odajdbc.driver.ConnNotOpen", 111);
        }
        this.preStat = null;
        this.conn = connection;
        this.maxrows = 0;
    }

    public void prepare(String command) throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "prepare", "Statement.prepare( \"" + command + "\" )");
        try {
            if (command == null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.logp(Level.FINE, clazz2.getName(), "prepare", "Query text can not be null.");
                throw new OdaException("Query text can not be null.");
            }
            this.preStat = this.conn.prepareStatement(this.formatQueryText(command));
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.StatementCannotPrepared", e);
        }
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void setProperty(String name, String value) throws OdaException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.equals("queryTimeOut")) {
            if (value != null && value.length() > 0) {
                try {
                    double secs = Double.parseDouble(value);
                    this.preStat.setQueryTimeout((int)secs);
                }
                catch (SQLException e) {
                    logger.log(Level.FINE, "Statement.setQueryTimeout failed", e);
                }
            }
        } else {
            OdaException e = new OdaException("Unsupported query property: " + name);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz.getName(), "setProperty", "Unsupported property", e);
            throw e;
        }
    }

    public void close() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "close", "Statement.close( )");
        try {
            if (this.preStat != null) {
                this.preStat.close();
            }
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotClosePreparedStatement", e);
        }
    }

    public void setMaxRows(int max) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setMaxRows", "Statement.setMaxRows( " + max + " )");
        if (max != this.maxrows && max >= 0) {
            this.maxrows = max;
            this.maxRowsUpToDate = false;
        }
    }

    public int getMaxRows() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getMaxRows", "Statement.getMaxRows( )");
        return this.maxrows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getMetaData", "Statement.getMetaData( )");
        this.assertNotNull(this.preStat);
        ResultSetMetaData resultmd = null;
        try {
            resultmd = this.preStat.getMetaData();
        }
        finally {
            IResultSetMetaData pstmtResultMetaData = null;
        }
    }

    public IResultSet executeQuery() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "executeQuery", "Statement.executeQuery( )");
        this.assertNotNull(this.preStat);
        try {
            if (!this.maxRowsUpToDate) {
                try {
                    this.preStat.setMaxRows(this.maxrows);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.maxRowsUpToDate = true;
            }
            return new ResultSet(this.preStat.executeQuery());
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotReturn", e);
        }
    }

    boolean execute() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "execute", "Statement.execute( )");
        this.assertNotNull(this.preStat);
        try {
            if (!this.maxRowsUpToDate) {
                this.preStat.setMaxRows(this.maxrows);
                this.maxRowsUpToDate = true;
            }
            return this.preStat.execute();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.QueryExecuteFail", e);
        }
    }

    public void setInt(String parameterName, int value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setInt", "No named Parameter supported.", e);
        throw e;
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setInt(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetIntValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setDouble", "No named Parameter supported.", e);
        throw e;
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setDouble(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDoubleValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setBigDecimal", "No named Parameter supported.", e);
        throw e;
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setBigDecimal(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBigDecimalValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setString(String parameterName, String value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setString", "No named Parameter supported.", e);
        throw e;
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setString(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetStringValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setDate", "No named Parameter supported.", e);
        throw e;
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setDate(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDateValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setTime", "No named Parameter supported.", e);
        throw e;
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setTime(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimeValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setTimestamp", "No named Parameter supported.", e);
        throw e;
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setTimestamp(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimestampValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public int findInParameter(String parameterName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "findInParameter", "No named Parameter supported.", e);
        throw e;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            return new ParameterMetaData(this.preStat.getParameterMetaData());
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetParameterMetadata", e);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSortSpec is not supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "setSortSpec", "setSortSpec is not supported.", e);
        throw e;
    }

    public SortSpec getSortSpec() throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSortSpec is not supported.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getSortSpec", "getSortSpec is not supported.", e);
        throw e;
    }

    public void clearInParameters() throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.clearParameters();
        }
        catch (SQLException ex) {
            throw new JDBCException("odajdbc.ClearParametersError", ex);
        }
    }

    private String formatQueryText(String source) {
        return source.replaceAll("\n", " ");
    }

    private static void rethrowRunTimeException(RuntimeException e, String msg) throws OdaException {
        OdaException odaException = new OdaException(msg);
        odaException.initCause(e);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Statement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "rethrowRunTimeException", msg, odaException);
        throw odaException;
    }
}

