/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class TestUtil {
    static final String DEFAULT_DRIVER_CLASS = "net.sourceforge.jtds.jdbc.Driver";
    static final String[] DATA_TYPES;
    static final String[][] DATA_VALUES;
    static final String TABLE_NAME = "\"test_oda_jdbc\"";
    static final String PROCEDURE_BASE_NAME = "testProc";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.TestUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        DATA_TYPES = new String[]{"decimal", "date", "float", "int", "varchar(100)", "time", "timestamp"};
        DATA_VALUES = new String[][]{{"NULL", "'2000-01-01 00:00:00'", "0.0", "0", "'00'", "'1900-01-01 12:00:01'", "'2000-01-01 12:00:00'"}, {"1111", "NULL", "1.1", "1", "'11'", "'1900-01-01 12:00:01'", "'2001-01-01 12:00:00'"}, {"2222", "'2002-01-01 00:00:00'", "NULL", "2", "'22'", "'1900-01-01 12:00:02'", "'2002-01-01 12:00:00'"}, {"3333", "'2003-01-01 00:00:00'", "3.3", "NULL", "'33'", "'1900-01-01 12:00:03'", "'2003-01-01 12:00:00'"}, {"4444", "'2004-01-01 00:00:00'", "4.4", "4", "NULL", "'1900-01-01 12:00:04'", "'2004-01-01 12:00:00'"}, {"5555", "'2005-01-01 00:00:00'", "5.5", "5", "'55'", "NULL", "'2005-01-01 12:00:00'"}, {"6666", "'2006-01-01 00:00:00'", "6.6", "6", "'66'", "'1900-01-01 12:00:06'", "NULL"}};
    }

    static Connection openConnection() throws OdaException {
        Connection conn = new Connection();
        Properties props = new Properties();
        props.setProperty("odaURL", TestUtil.getURL());
        props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
        props.setProperty("odaUser", TestUtil.getUser());
        props.setProperty("odaPassword", TestUtil.getPassword());
        conn.open(props);
        return conn;
    }

    static java.sql.Connection openJDBCConnection() throws Exception {
        Class.forName(TestUtil.getDriverClassName());
        java.sql.Connection jdbcConn = DriverManager.getConnection(TestUtil.getURL(), TestUtil.getUser(), TestUtil.getPassword());
        return jdbcConn;
    }

    static void createTestData() throws Exception {
        java.sql.Connection jdbcConn = TestUtil.openJDBCConnection();
        Statement jdbcStmt = jdbcConn.createStatement();
        String sql = "drop table \"test_oda_jdbc\"";
        try {
            jdbcStmt.execute(sql);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sql = "create table \"test_oda_jdbc\"(";
        int i = 0;
        while (i < DATA_TYPES.length) {
            if (i > 0) {
                sql = String.valueOf(sql) + ", ";
            }
            sql = String.valueOf(sql) + "col" + i + " " + DATA_TYPES[i];
            ++i;
        }
        sql = String.valueOf(sql) + ")";
        jdbcStmt.execute(sql);
        i = 0;
        while (i < DATA_VALUES.length) {
            sql = "insert into \"test_oda_jdbc\" values(";
            int j = 0;
            while (j < DATA_VALUES[i].length) {
                if (j > 0) {
                    sql = String.valueOf(sql) + ", ";
                }
                sql = String.valueOf(sql) + DATA_VALUES[i][j];
                ++j;
            }
            sql = String.valueOf(sql) + ")";
            jdbcStmt.execute(sql);
            ++i;
        }
        jdbcStmt.close();
        jdbcConn.close();
    }

    static void createTestProcedure() throws Exception {
        java.sql.Connection jdbcConn = TestUtil.openJDBCConnection();
        String str = "";
        Statement jdbcStmt = jdbcConn.createStatement();
        int i = 0;
        while (i < DATA_TYPES.length) {
            str = "drop proceduretestProc" + i;
            try {
                jdbcStmt.execute(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        String str1 = "CREATE PROCEDURE ";
        String str2 = " PARAMETER STYLE JAVA READS SQL DATA LANGUAGE JAVA EXTERNAL NAME 'org.eclipse.birt.report.data.oda.jdbc.TestUtil.selectData'";
        String sql = "";
        int i2 = 0;
        while (i2 < DATA_TYPES.length) {
            sql = String.valueOf(str1) + PROCEDURE_BASE_NAME + i2 + " (IN param1 " + DATA_TYPES[i2] + " ,OUT param2 " + DATA_TYPES[i2] + " )" + str2;
            try {
                jdbcStmt.execute(sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        jdbcStmt.close();
        jdbcConn.close();
    }

    static void deleteTestData() throws Exception {
        java.sql.Connection jdbcConn = TestUtil.openJDBCConnection();
        Statement jdbcStmt = jdbcConn.createStatement();
        String sql = "drop table \"test_oda_jdbc\"";
        jdbcStmt.execute(sql);
        jdbcStmt.close();
        jdbcConn.close();
    }

    static void deleteTestProcedure() throws Exception {
        java.sql.Connection jdbcConn = TestUtil.openJDBCConnection();
        Statement jdbcStmt = jdbcConn.createStatement();
        String sql = "";
        int i = 0;
        while (i < DATA_TYPES.length) {
            sql = "drop proceduretestProc" + i;
            try {
                jdbcStmt.execute(sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        jdbcStmt.close();
        jdbcConn.close();
    }

    static String getDriverClassName() {
        return "org.apache.derby.jdbc.EmbeddedDriver";
    }

    static String getURL() {
        String url = System.getProperty("DTETest.url");
        if (url != null) {
            return url;
        }
        return "jdbc:derby:" + TestUtil.getDatabase() + ";create=true;user=" + TestUtil.getUser() + ";password=" + TestUtil.getPassword();
    }

    static String getUser() {
        String user = System.getProperty("DTETest.user");
        if (user != null) {
            return user;
        }
        return "Actuate";
    }

    static String getPassword() {
        String pwd = System.getProperty("DTETest.password");
        if (pwd != null) {
            return pwd;
        }
        return "Actuate";
    }

    static String getDatabase() {
        String database = System.getProperty("DTETest.database");
        if (database != null) {
            return database;
        }
        return "DTETest";
    }

    public static void selectData(int a, int[] b) {
        if (!$assertionsDisabled && a != 0) {
            throw new AssertionError();
        }
        b[0] = 1;
    }

    public static void selectData(double a, double[] b) {
        if (!$assertionsDisabled && a != 0.0) {
            throw new AssertionError();
        }
        b[0] = 1.0;
    }

    public static void selectData(Date a, Date[] b) {
        if (!$assertionsDisabled && !a.equals(Date.valueOf("2000-01-01"))) {
            throw new AssertionError();
        }
        b[0] = Date.valueOf("2000-01-02");
    }

    public static void selectData(BigDecimal a, BigDecimal[] b) {
        if (!$assertionsDisabled && !a.equals(new BigDecimal("1111"))) {
            throw new AssertionError();
        }
        b[0] = new BigDecimal("2222");
    }

    public static void selectData(Timestamp a, Timestamp[] b) {
        if (!$assertionsDisabled && !a.equals(Timestamp.valueOf("2000-01-01 12:00:00.0000"))) {
            throw new AssertionError();
        }
        b[0] = Timestamp.valueOf("2000-01-02 12:00:00.0000");
    }

    public static void selectData(String a, String[] b) {
        if (!$assertionsDisabled && !a.equals("00")) {
            throw new AssertionError();
        }
        b[0] = "11";
    }

    public static void selectData(Time a, Time[] b) {
        if (!$assertionsDisabled && !a.equals(Time.valueOf("12:00:00"))) {
            throw new AssertionError();
        }
        b[0] = Time.valueOf("12:00:01");
    }
}

