/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.logging;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import org.eclipse.datatools.connectivity.oda.util.logging.FileHandler;
import org.eclipse.datatools.connectivity.oda.util.logging.Handler;
import org.eclipse.datatools.connectivity.oda.util.logging.Level;
import org.eclipse.datatools.connectivity.oda.util.logging.LogFormatter;
import org.eclipse.datatools.connectivity.oda.util.logging.Logger;

public class LogManager {
    private static Hashtable m_loggers = new Hashtable();
    private static final SimpleDateFormat sm_dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");

    private LogManager() {
    }

    public static Logger createLogger(String loggerName, int logLevel, String logDirectory, String logPrefix, String formatterClassName) {
        if (m_loggers.containsKey(loggerName)) {
            throw new IllegalArgumentException("Logger with same name exists.");
        }
        LogManager.validateInput(logLevel, logDirectory, logPrefix);
        Logger logger = new Logger(loggerName);
        LogManager.setLoggerLevel(logger, logLevel);
        if (LogManager.isLogLevelOff(logger.getLevel().intValue())) {
            return logger;
        }
        LogManager.resetLoggerFileConfig(logger, logDirectory, logPrefix, formatterClassName);
        m_loggers.put(loggerName, logger);
        return logger;
    }

    private static void validateInput(int logLevel, String logDirectory, String logPrefix) {
        if (LogManager.isLogLevelOff(logLevel)) {
            return;
        }
        if (logDirectory == null || logPrefix == null) {
            throw new NullPointerException();
        }
        if (logDirectory.length() == 0 || logPrefix.length() == 0) {
            throw new IllegalArgumentException();
        }
    }

    public static Logger getLogger(String loggerName, int logLevel, String logDirectory, String logPrefix, String formatterClassName) {
        LogManager.validateInput(logLevel, logDirectory, logPrefix);
        Logger logger = LogManager.getLogger(loggerName);
        if (logger == null) {
            return LogManager.createLogger(loggerName, logLevel, logDirectory, logPrefix, formatterClassName);
        }
        LogManager.setLoggerLevel(logger, logLevel);
        if (LogManager.isLogLevelOff(logger.getLevel().intValue())) {
            logger.setHandler(null);
            return logger;
        }
        Handler handler = logger.getHandler();
        if (!(handler instanceof FileHandler)) {
            LogManager.resetLoggerFileConfig(logger, logDirectory, logPrefix, formatterClassName);
            return logger;
        }
        FileHandler fileHandler = (FileHandler)handler;
        if (LogManager.hasLoggerFileConfigChanged(logger, fileHandler, logDirectory, logPrefix)) {
            LogManager.resetLoggerFileConfig(logger, logDirectory, logPrefix, formatterClassName);
            return logger;
        }
        LogFormatter origFormatter = fileHandler.getFormatter();
        String origFormatterClassName = origFormatter.getClass().getName();
        if (origFormatterClassName.equals(formatterClassName)) {
            return logger;
        }
        try {
            LogFormatter formatter = LogManager.getLogFormatterInstance(formatterClassName);
            fileHandler.setFormatter(formatter);
        }
        catch (Exception ex) {
            logger.severe(ex);
        }
        return logger;
    }

    private static boolean hasLoggerFileConfigChanged(Logger logger, FileHandler fileHandler, String newLogDirectory, String newLogPrefix) {
        String fullFilename = fileHandler.getPreferredFilename();
        File origFile = new File(fullFilename);
        File origDir = null;
        File newDir = null;
        try {
            origDir = origFile.getParentFile().getCanonicalFile();
            newDir = new File(newLogDirectory).getCanonicalFile();
        }
        catch (IOException ex) {
            logger.severe(ex);
            return origDir == null;
        }
        if (!origDir.equals(newDir)) {
            return true;
        }
        String origFilename = origFile.getName();
        if (!origFilename.startsWith(newLogPrefix) || !origFilename.endsWith(".log")) {
            return true;
        }
        String origTimetamp = origFilename.substring(newLogPrefix.length() + 1, origFilename.length() - 4);
        if (origTimetamp.length() != 15) {
            return true;
        }
        try {
            if (sm_dateFormat.parse(origTimetamp) == null) {
                return true;
            }
        }
        catch (ParseException ex) {
            return true;
        }
        return false;
    }

    private static void setLoggerLevel(Logger logger, int logLevel) {
        Level level = new Level("", logLevel);
        logger.setLevel(level);
    }

    private static void resetLoggerFileConfig(Logger logger, String logDirectory, String logPrefix, String formatterClassName) {
        String logfileName = LogManager.generateFileName(logDirectory, logPrefix);
        Exception formatterException = null;
        FileHandler handler = null;
        try {
            LogFormatter formatter = LogManager.getLogFormatterInstance(formatterClassName);
            handler = formatter == null ? new FileHandler(logfileName) : new FileHandler(logfileName, formatter);
        }
        catch (Exception ex) {
            formatterException = ex;
            handler = new FileHandler(logfileName);
        }
        logger.setHandler(handler);
        if (formatterException != null) {
            logger.severe(formatterException);
        }
    }

    public static Logger getLogger(String loggerName) {
        return (Logger)m_loggers.get(loggerName);
    }

    private static String generateFileName(String logDirectory, String logPrefix) {
        String logfileName = logDirectory.endsWith("/") || logDirectory.endsWith("\\") ? logDirectory : logDirectory + "/";
        logfileName = logfileName + logPrefix + "-";
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        logfileName = logfileName + sm_dateFormat.format(timestamp) + ".log";
        return logfileName;
    }

    private static LogFormatter getLogFormatterInstance(String formatterClassName) throws Exception {
        if (formatterClassName == null || formatterClassName.length() == 0) {
            return null;
        }
        Class<?> formatterClass = Class.forName(formatterClassName);
        return (LogFormatter)formatterClass.newInstance();
    }

    private static boolean isLogLevelOff(int logLevel) {
        return logLevel > 1000;
    }
}

