/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public class DataTypeMapping {
    private short m_nativeTypeCode;
    private String m_nativeType;
    private String m_odaScalarType;
    private String[] m_alternativeDataTypes;

    DataTypeMapping(IConfigurationElement dataTypeMapping, String dataSetTypeName) throws OdaException {
        this.m_nativeType = dataTypeMapping.getAttribute("nativeDataType");
        if (this.m_nativeType == null) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(18, new Object[]{dataSetTypeName}));
        }
        String nativeDataTypeCode = dataTypeMapping.getAttribute("nativeDataTypeCode");
        if (nativeDataTypeCode == null) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(16, new Object[]{this.m_nativeType, dataSetTypeName}));
        }
        try {
            this.m_nativeTypeCode = Short.parseShort(nativeDataTypeCode);
        }
        catch (NumberFormatException ex) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(17, new Object[]{this.m_nativeType, nativeDataTypeCode, dataSetTypeName}));
        }
        this.m_odaScalarType = dataTypeMapping.getAttribute("odaScalarDataType");
        this.sanityCheckOdaScalarType(this.m_odaScalarType, false);
        IConfigurationElement[] alternativeDataTypes = dataTypeMapping.getChildren("alternativeOdaDataType");
        int length = alternativeDataTypes.length;
        this.m_alternativeDataTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            this.m_alternativeDataTypes[i] = alternativeDataTypes[i].getAttribute("odaScalarType");
            this.sanityCheckOdaScalarType(this.m_alternativeDataTypes[i], true);
        }
    }

    private void sanityCheckOdaScalarType(String odaScalarType, boolean isForAlternatives) throws OdaException {
        if (odaScalarType == null) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(isForAlternatives ? 20 : 19, new Object[]{this.m_nativeType}));
        }
        if (!(odaScalarType.equalsIgnoreCase("Date") || odaScalarType.equalsIgnoreCase("Double") || odaScalarType.equalsIgnoreCase("Integer") || odaScalarType.equalsIgnoreCase("String") || odaScalarType.equalsIgnoreCase("Time") || odaScalarType.equalsIgnoreCase("Timestamp") || odaScalarType.equalsIgnoreCase("Decimal") || odaScalarType.equalsIgnoreCase("Blob") || odaScalarType.equalsIgnoreCase("Clob"))) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(21, new Object[]{odaScalarType, this.m_nativeType}));
        }
    }

    public String getNativeType() {
        return this.m_nativeType;
    }

    public short getNativeTypeCode() {
        return this.m_nativeTypeCode;
    }

    public String getOdaScalarDataType() {
        return this.m_odaScalarType;
    }

    public String[] getAlternativeOdaDataTypes() {
        return this.m_alternativeDataTypes;
    }
}

