/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.ResourceCache;
import org.eclipse.datatools.connectivity.oda.util.ResourceManager;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;

public class ManifestExplorer {
    private static ManifestExplorer sm_instance = null;
    private static String sm_loggerName = ManifestExplorer.class.getPackage().getName();
    private static Logger sm_logger = Logger.getLogger(sm_loggerName);
    private static final String DTP_ODA_EXT_POINT = "org.eclipse.datatools.connectivity.oda.dataSource";

    public static ManifestExplorer getInstance() {
        if (sm_instance == null) {
            sm_instance = new ManifestExplorer();
        }
        return sm_instance;
    }

    private ManifestExplorer() {
    }

    public Properties getDataSourceIdentifiers() {
        IExtension[] extensions = this.getDataSourceExtensions();
        int length = extensions == null ? 0 : extensions.length;
        Properties extensionIds = new Properties();
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            try {
                IConfigurationElement dsElement = ManifestExplorer.getDataSourceElement(extension);
                String dataSourceId = dsElement.getAttribute("id");
                String dataSourceDisplayName = ManifestExplorer.getElementDisplayName(dsElement);
                extensionIds.setProperty(dataSourceId, dataSourceDisplayName);
                continue;
            }
            catch (OdaException ex) {
                sm_logger.log(Level.WARNING, "Ignoring invalid extension.", ex);
            }
        }
        return extensionIds;
    }

    public ExtensionManifest getExtensionManifest(String dataSourceId) throws OdaException {
        ExtensionManifest manifest = this.getExtensionManifest(dataSourceId, DTP_ODA_EXT_POINT);
        if (manifest != null) {
            return manifest;
        }
        throw new IllegalArgumentException(dataSourceId);
    }

    public ExtensionManifest getExtensionManifest(String dataSourceId, String extensionPoint) throws OdaException {
        if (dataSourceId == null || dataSourceId.length() == 0) {
            throw new IllegalArgumentException(dataSourceId);
        }
        if (extensionPoint == null || extensionPoint.length() == 0) {
            throw new IllegalArgumentException(extensionPoint);
        }
        IExtension[] extensions = this.getExtensions(extensionPoint);
        IExtension extension = this.findExtension(dataSourceId, extensions);
        if (extension != null) {
            return this.newExtensionManifest(extension);
        }
        return null;
    }

    ExtensionManifest newExtensionManifest(IExtension platformExtension) throws OdaException {
        if (platformExtension == null) {
            throw new IllegalArgumentException("null argument");
        }
        return new ExtensionManifest(platformExtension);
    }

    public ExtensionManifest[] getExtensionManifests() {
        return this.getExtensionManifests(DTP_ODA_EXT_POINT);
    }

    public ExtensionManifest[] getExtensionManifests(String extensionPoint) {
        IExtension[] extensions = this.getExtensions(extensionPoint);
        int length = extensions == null ? 0 : extensions.length;
        ArrayList<ExtensionManifest> manifestList = new ArrayList<ExtensionManifest>(length);
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            try {
                manifestList.add(this.newExtensionManifest(extension));
                continue;
            }
            catch (OdaException ex) {
                sm_logger.log(Level.WARNING, "Ignoring invalid extension.", ex);
            }
        }
        int numOfValidExtensions = manifestList.size();
        return manifestList.toArray(new ExtensionManifest[numOfValidExtensions]);
    }

    private IExtension findExtension(String dataSourceId, IExtension[] extensions) throws OdaException {
        int length = extensions == null ? 0 : extensions.length;
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            String extnDataSourceId = null;
            try {
                IConfigurationElement dataSourceElement = ManifestExplorer.getDataSourceElement(extension);
                extnDataSourceId = dataSourceElement.getAttribute("id");
            }
            catch (OdaException ex) {
                sm_logger.log(Level.WARNING, "Ignoring invalid extension.", ex);
                continue;
            }
            if (extnDataSourceId == null || !extnDataSourceId.equalsIgnoreCase(dataSourceId)) continue;
            return extension;
        }
        return null;
    }

    private IExtension[] getExtensions(String extPoint) {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(extPoint);
        if (extensionPoint == null) {
            return null;
        }
        return extensionPoint.getExtensions();
    }

    private IExtension[] getDataSourceExtensions() {
        return this.getExtensions(DTP_ODA_EXT_POINT);
    }

    static IConfigurationElement getDataSourceElement(IExtension extension) throws OdaException {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int n = configElements.length;
        for (int i = 0; i < n; ++i) {
            IConfigurationElement configElement = configElements[i];
            if (!configElement.getName().equalsIgnoreCase("dataSource")) continue;
            String dataSourceId = configElement.getAttribute("id");
            if (dataSourceId == null || dataSourceId.length() == 0) {
                throw new OdaException(ManifestExplorer.getLocalizedMessage(9));
            }
            return configElement;
        }
        throw new OdaException(ManifestExplorer.getLocalizedMessage(8));
    }

    static Hashtable getDataSetElements(IExtension extension, String dataSourceElementId) throws OdaException {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        Hashtable<String, DataSetType> dataSetElements = new Hashtable<String, DataSetType>();
        int size = configElements.length;
        for (int i = 0; i < size; ++i) {
            IConfigurationElement configElement = configElements[i];
            if (!configElement.getName().equalsIgnoreCase("dataSet")) continue;
            String dataSetTypeId = configElement.getAttribute("id");
            if (dataSetTypeId == null || dataSetTypeId.length() == 0) {
                throw new OdaException(ManifestExplorer.getLocalizedMessage(14, new Object[]{dataSourceElementId}));
            }
            dataSetElements.put(dataSetTypeId, new DataSetType(configElement));
        }
        if (dataSetElements.size() < 1) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(13, new Object[]{dataSourceElementId}));
        }
        return dataSetElements;
    }

    static String getElementDisplayName(IConfigurationElement dsElement) {
        String displayName = dsElement.getAttribute("defaultDisplayName");
        if ((displayName == null || displayName.length() == 0) && (displayName = dsElement.getAttribute("name")) == null) {
            displayName = dsElement.getAttribute("id");
        }
        return displayName;
    }

    static String getLocalizedMessage(int errorNumber) {
        ResourceManager manager = ResourceCache.instance().getResources("org.eclipse.datatools.connectivity.oda.util.OdaResources", Locale.getDefault());
        return manager != null ? manager.getString(errorNumber) : "";
    }

    static String getLocalizedMessage(int errorNumber, Object[] arguments) {
        return MessageFormat.format(ManifestExplorer.getLocalizedMessage(errorNumber), arguments);
    }
}

