/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.thirdparty.aggregation;

import java.lang.reflect.Array;
import org.eclipse.birt.data.engine.core.DataException;

public class Finance {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.thirdparty.aggregation.Finance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private Finance() {
    }

    public static double ddb(double cost, double salvage, double life, int period) throws DataException {
        double prior = 0.0;
        double depr = 0.0;
        if (life <= 0.0 || salvage < 0.0 || cost <= 0.0 || period <= 0 || life == Double.NaN || salvage == Double.NaN || cost == Double.NaN || (double)period == Double.NaN) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"DDB");
        }
        double rate = 1.0 / life * 2.0;
        int x = 0;
        while (x < period) {
            double basis = cost - prior;
            depr = Math.min(basis - salvage, basis * rate);
            prior += depr;
            ++x;
        }
        return depr;
    }

    public static double sln(double cost, double salvage, double life) throws DataException {
        if (life <= 0.0 || salvage < 0.0 || cost <= 0.0) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"SLN");
        }
        return (cost - salvage) / life;
    }

    public static double syd(double cost, double salvage, double life, int period) throws DataException {
        int denom = 0;
        double depr = 0.0;
        if (life <= 0.0 || salvage < 0.0 || cost <= 0.0 || period <= 0) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"SYD");
        }
        int i = 1;
        while ((double)i <= life) {
            denom += i;
            ++i;
        }
        int x = 1;
        while (x <= period) {
            double rate = (life - (double)x + 1.0) / (double)denom;
            depr = Math.min(cost - salvage, (cost - salvage) * rate);
            ++x;
        }
        return depr;
    }

    public static double fv(double rate, int nPer, double pmt, double pv, int due) throws DataException {
        double fv = 0.0;
        int start = 0;
        int end = 0;
        if (rate < 0.0 || nPer < 0 || due != 1 && due != 0) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"fv");
        }
        switch (due) {
            case 1: {
                start = 1;
                end = nPer;
                break;
            }
            case 0: {
                start = 0;
                end = nPer - 1;
                break;
            }
            default: {
                throw new DataException("data.engine.BadAggrFuncParam", (Object)"fv");
            }
        }
        int i = start;
        while (i <= end) {
            fv += Math.pow(1.0 + rate, i);
            ++i;
        }
        fv *= pmt;
        if (pv != 0.0) {
            fv += pv * Math.pow(1.0 + rate, new Integer(nPer).doubleValue());
        }
        return 0.0 - fv;
    }

    public static double pmt(double rate, int nper, double pv, double fv, int due) throws DataException {
        double curr;
        int start_pv = 0;
        int end_pv = 0;
        int start_fv = 0;
        int end_fv = 0;
        double pmt = 0.0;
        double df_pv = 0.0;
        double df_fv = 0.0;
        switch (due) {
            case 0: {
                start_pv = 1;
                end_pv = nper;
                start_fv = 0;
                end_fv = nper - 1;
                break;
            }
            case 1: {
                start_pv = 0;
                end_pv = nper - 1;
                start_fv = 1;
                end_fv = nper;
                break;
            }
            default: {
                throw new DataException("data.engine.BadAggrFuncParam", (Object)"pmt");
            }
        }
        int t = start_pv;
        while (t <= end_pv) {
            curr = Math.pow(1.0 + rate, new Integer(t).doubleValue());
            df_pv += 1.0 / curr;
            ++t;
        }
        t = start_fv;
        while (t <= end_fv) {
            curr = Math.pow(1.0 + rate, new Integer(t).doubleValue());
            df_fv += curr;
            ++t;
        }
        pmt = pv / df_pv + fv / df_fv;
        return -pmt;
    }

    public static double ipmt(double rate, int per, int nPer, double pv, double fv, int due) throws DataException {
        double ipmt = 0.0;
        double ppmt = 0.0;
        if (rate < 0.0 || nPer < 0 || per > nPer || due != 1 && due != 0) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"IPMT");
        }
        double pmt = Math.abs(Finance.pmt(rate, nPer, pv, fv, due));
        double principal = Math.abs(pv);
        int curper = 1;
        while (curper <= per) {
            if (curper != 1 || due == 0) {
                ipmt = rate * principal;
            }
            ppmt = pmt - ipmt;
            principal -= ppmt;
            ++curper;
        }
        if (pv > 0.0 || pv == 0.0 && fv > 0.0) {
            ipmt *= -1.0;
        }
        return ipmt;
    }

    public static double ppmt(double rate, int per, int nPer, double pv, double fv, int due) throws DataException {
        double ipmt = 0.0;
        double ppmt = 0.0;
        if (rate < 0.0 || nPer < 0 || per > nPer || due != 1 && due != 0) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"PPMT");
        }
        double pmt = Math.abs(Finance.pmt(rate, nPer, pv, fv, due));
        double principal = Math.abs(pv);
        int curper = 1;
        while (curper <= per) {
            if (curper != 1 || due == 0) {
                ipmt = rate * principal;
            }
            ppmt = pmt - ipmt;
            principal -= ppmt;
            ++curper;
        }
        if (pv > 0.0 || pv == 0.0 && fv > 0.0) {
            ppmt *= -1.0;
        }
        return ppmt;
    }

    public static int nPer(double rate, double pmt, double pv, double fv, int due) throws DataException {
        if (rate < 0.0 || pmt == 0.0 || due != 1 && due != 0 || Math.abs(pv) * rate >= Math.abs(pmt) || Math.abs(fv) * rate >= Math.abs(pmt)) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"NPER");
        }
        int FvPeriod = 0;
        int PvPeriod = 0;
        int nPer = 0;
        double currentvalue = 0.0;
        if (pv != 0.0) {
            if (pv * pmt < 0.0) {
                currentvalue = Math.abs(pv);
                if (due == 1) {
                    currentvalue -= currentvalue * rate;
                }
                while (currentvalue > 0.0) {
                    currentvalue += currentvalue * rate;
                    currentvalue -= Math.abs(pmt);
                    ++PvPeriod;
                }
            } else {
                currentvalue = Math.abs(pmt);
                if (due == 1) {
                    pv *= 1.0 + rate;
                }
                while (currentvalue < Math.abs(pv)) {
                    currentvalue += currentvalue * rate;
                    currentvalue += Math.abs(pmt);
                    --PvPeriod;
                }
            }
        }
        if (fv != 0.0) {
            if (fv * pmt < 0.0) {
                currentvalue = Math.abs(pmt);
                if (due == 0) {
                    currentvalue = 0.0;
                }
                while (currentvalue < Math.abs(fv)) {
                    currentvalue += currentvalue * rate;
                    currentvalue += Math.abs(pmt);
                    ++FvPeriod;
                }
            } else {
                FvPeriod = 1;
                currentvalue = Math.abs(fv);
                if (due == 1) {
                    currentvalue -= currentvalue * rate;
                }
                while (currentvalue > 0.0) {
                    currentvalue += currentvalue * rate;
                    currentvalue -= Math.abs(pmt);
                    --FvPeriod;
                }
            }
        }
        nPer = PvPeriod + FvPeriod;
        return nPer;
    }

    public static double pv(double rate, int nPer, double pmt, double fv, int due) throws DataException {
        double pv = 0.0;
        if (nPer < 0 || due != 1 && due != 0) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"pv");
        }
        if (rate < 0.0) {
            pv = -fv - pmt * (double)nPer;
        } else {
            double denom = Math.pow(1.0 + rate, nPer);
            double num = -fv - pmt * (1.0 + rate * (double)due) * (denom - 1.0) / rate;
            pv = num / denom;
        }
        return pv;
    }

    private static double solvePmt(int nPer, double true_pmt, double loanamt, double fv, int due, double rate, double incr, int attempt, boolean found) throws ArrayIndexOutOfBoundsException {
        try {
            double tolerance = 1.0E-7;
            if (attempt > 1000) {
                found = false;
                return -1.0;
            }
            double diff1 = true_pmt - Finance.pmt(rate + incr, nPer, loanamt, fv, due);
            if (Math.abs(diff1) <= tolerance) {
                found = true;
                return rate + incr;
            }
            double diff2 = true_pmt - Finance.pmt(rate, nPer, loanamt, fv, due);
            if (Math.abs(diff2) <= tolerance) {
                found = true;
                return rate;
            }
            if (diff1 * diff2 < 0.0) {
                incr /= 10.0;
            } else {
                rate += incr;
            }
            return Finance.solvePmt(nPer, true_pmt, loanamt, fv, due, rate, incr, ++attempt, found);
        }
        catch (Exception e) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static double rate(int nPer, double pmt, double pv, double fv, int due, double guess) throws DataException {
        try {
            double tmp;
            double incr = 0.1;
            boolean found = true;
            double result = 0.0;
            if (nPer <= 0 || due != 1 && due != 0) {
                if (nPer <= 0) {
                    throw new DataException("data.engine.BadAggrFuncParam", (Object)"rate");
                }
                throw new DataException("data.engine.BadAggrFuncParam", (Object)"rate");
            }
            int i = 5;
            double curr_guess = guess;
            --i;
            while (i > 0) {
                incr = 0.1;
                tmp = curr_guess;
                try {
                    result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new DataException("data.engine.BadParameterCount", (Throwable)e);
                }
                if (result != -1.0) {
                    return result;
                }
                curr_guess /= 2.0;
                --i;
            }
            i = 4;
            curr_guess = guess * 2.0;
            --i;
            while (i > 0) {
                tmp = curr_guess;
                incr = 0.1;
                result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
                if (result != -1.0) {
                    return result;
                }
                curr_guess *= 2.0;
                --i;
            }
            i = 5;
            curr_guess = guess;
            --i;
            while (i > 0) {
                tmp = curr_guess;
                incr = -0.1;
                result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
                if (result != -1.0) {
                    return result;
                }
                curr_guess /= 2.0;
                --i;
            }
            i = 4;
            curr_guess = guess * 2.0;
            --i;
            while (i > 0) {
                tmp = curr_guess;
                incr = -0.1;
                result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
                if (result != -1.0) {
                    return result;
                }
                curr_guess *= 2.0;
                --i;
            }
        }
        catch (ClassCastException e) {
            throw new DataException("data.engine.BadParameterType", (Throwable)e);
        }
        throw new DataException("data.engine.ResetRateGuess");
    }

    public static double percent(double denom, double num) {
        if (num == 0.0) {
            return 0.0;
        }
        if (!$assertionsDisabled && denom == 0.0) {
            throw new AssertionError();
        }
        return num / denom * 100.0;
    }

    public static double npv(double[] arptr, double rate) throws DataException {
        long arsize = Array.getLength(arptr);
        double npv = 0.0;
        double dval = 0.0;
        int i = 1;
        while ((long)i <= arsize) {
            try {
                dval = Array.getDouble(arptr, i - 1);
            }
            catch (Exception e) {
                throw new DataException("data.engine.BadAggrFuncParam", (Object)"npv");
            }
            npv += dval / Math.pow(1.0 + rate, i);
            ++i;
        }
        return npv;
    }

    private static double calcIrr(double[] cash, double intrate, double inc, int attempt) throws DataException {
        double tolerance = 1.0E-7;
        if (attempt > 1000) {
            return -1.0;
        }
        double npv1 = Finance.npv(cash, intrate + inc);
        if (Math.abs(npv1) <= tolerance) {
            return intrate + inc;
        }
        double npv2 = Finance.npv(cash, intrate);
        if (npv2 * npv1 < 0.0) {
            inc /= 10.0;
        } else {
            intrate += inc;
        }
        return Finance.calcIrr(cash, intrate, inc, ++attempt);
    }

    public static double irr(double[] cash, double intrate) throws DataException {
        double result;
        double incr;
        double tmp;
        boolean arg1Positive = true;
        long arsize = 0L;
        if (cash != null) {
            arsize = cash.length;
        }
        if ((tmp = Array.getDouble(cash, 0)) < 0.0) {
            arg1Positive = false;
        } else if (tmp > 0.0) {
            arg1Positive = true;
        } else {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"irr");
        }
        boolean found = false;
        int i = 1;
        while ((long)i <= arsize) {
            try {
                tmp = Array.getDouble(cash, i - 1);
            }
            catch (Exception e) {
                throw new DataException("data.engine.BadParameterType", (Throwable)e);
            }
            if (arg1Positive && tmp < 0.0 || !arg1Positive && tmp > 0.0) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"irr");
        }
        i = 10;
        double curr_rate = intrate;
        --i;
        while (i > 0) {
            double d;
            incr = 0.1;
            tmp = curr_rate;
            result = Finance.calcIrr(cash, tmp, incr, 0);
            if (d < 0.0) {
                return result;
            }
            curr_rate /= 2.0;
            --i;
        }
        i = 4;
        curr_rate = intrate * 2.0;
        --i;
        while (i > 0) {
            double d;
            incr = 0.1;
            tmp = curr_rate;
            result = Finance.calcIrr(cash, tmp, incr, 0);
            if (d >= 0.0) {
                return result;
            }
            curr_rate *= 2.0;
            --i;
        }
        throw new DataException("data.engine.NoIrrSolution");
    }

    private static double calcPNPV(double[] arptr, long arsize, double rate) throws IllegalArgumentException {
        double npv = 0.0;
        int i = 1;
        while ((long)i <= arsize) {
            double dval = Array.getDouble(arptr, i - 1);
            if (dval >= 0.0) {
                npv += dval / Math.pow(1.0 + rate, i);
            }
            ++i;
        }
        return npv;
    }

    private static double calcNNPV(double[] arptr, long arsize, double rate) throws IllegalArgumentException {
        double npv = 0.0;
        int i = 1;
        while ((long)i <= arsize) {
            double dval = Array.getDouble(arptr, i - 1);
            if (dval < 0.0) {
                npv += dval / Math.pow(1.0 + rate, i);
            }
            ++i;
        }
        return npv;
    }

    public static double mirr(double[] arptr, double frate, double rrate) throws DataException {
        long arsize = 0L;
        if (arptr != null) {
            arsize = arptr.length;
        }
        if (arptr == null || frate < 0.0 || rrate < 0.0) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"mirr");
        }
        long n = arsize;
        double sign = 1.0;
        double PNpv = Finance.calcPNPV(arptr, n, rrate);
        double NNpv = Finance.calcNNPV(arptr, n, frate);
        if (NNpv == 0.0) {
            throw new DataException("data.engine.BadAggrFuncParam", (Object)"mirr");
        }
        double tmp = -PNpv * Math.pow(1.0 + rrate, n) / (NNpv * (1.0 + frate));
        if (tmp < 0.0) {
            sign = -1.0;
        }
        return sign * (Math.pow(Math.abs(tmp), 1.0 / (double)(n - 1L)) - 1.0);
    }
}

