/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import org.eclipse.birt.data.oda.util.ResourceManager;

public final class ResourceCache {
    private transient int m_iMaxBundles = 15;
    private transient Hashtable m_htRC = new Hashtable(15);
    private transient LinkedList m_llRC = new LinkedList();
    private static transient ResourceCache sm_rc = null;

    private ResourceCache() {
    }

    public static final synchronized ResourceCache instance() {
        if (sm_rc == null) {
            sm_rc = new ResourceCache();
        }
        return sm_rc;
    }

    public final synchronized ResourceManager getResources(String sFQClass, Locale lo) throws IllegalArgumentException {
        RCKey k;
        ResourceManager rm;
        if (lo == null) {
            lo = Locale.getDefault();
        }
        if ((rm = (ResourceManager)this.m_htRC.get(k = new RCKey(sFQClass, lo))) == null) {
            RCKey kRemove;
            if (this.m_htRC.size() >= this.m_iMaxBundles && (kRemove = (RCKey)this.m_llRC.removeLast()) != null) {
                this.m_htRC.remove(kRemove);
            }
            rm = ResourceManager.loadResources(sFQClass, lo);
            this.m_htRC.put(k, rm);
            this.m_llRC.addFirst(k);
        } else if (this.m_htRC.size() > 1) {
            this.m_llRC.remove(k);
            this.m_llRC.addFirst(k);
        }
        return rm;
    }

    public final void flushCache() {
    }

    public final void setCacheSize(int iMaxBundles) {
        this.m_iMaxBundles = iMaxBundles;
    }

    private static final class RCKey {
        private transient String sResourceName = null;
        private transient Locale lo = null;

        RCKey(String sResourceName, Locale lo) throws IllegalArgumentException {
            this.sResourceName = sResourceName;
            if (sResourceName == null) {
                throw new IllegalArgumentException("ResourceCache : NULL value not allowed for a resource bundle name");
            }
            if (lo == null) {
                lo = Locale.getDefault();
            }
            this.lo = lo;
        }

        public int hashCode() {
            String s = this.toString();
            int hc = 0;
            int n = s.length();
            int i = 0;
            while (i < n) {
                hc += s.charAt(i) * 2;
                ++i;
            }
            return hc;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RCKey)) {
                return false;
            }
            RCKey k = (RCKey)o;
            return k.sResourceName.equals(this.sResourceName) && k.lo.toString().equals(this.lo.toString());
        }

        public String toString() {
            return String.valueOf(this.sResourceName) + " [" + this.lo.toString() + "] ";
        }
    }
}

