/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util;

import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Locale;
import org.eclipse.birt.data.oda.util.ValueNotFoundException;

public class ResourceManager {
    private Object[] m_oaValues = null;

    protected ResourceManager() {
        this.init();
    }

    protected void init() {
        this.setResourceTable(new Object[0]);
    }

    protected final void setResourceTable(Object[] oaValues) {
        this.m_oaValues = oaValues;
    }

    public final Object get(int iKey) throws ValueNotFoundException {
        if (iKey < 0 || iKey > this.m_oaValues.length) {
            throw new ValueNotFoundException("Unable to find resource for key=" + iKey);
        }
        return this.m_oaValues[iKey];
    }

    public final String getString(int iKey) throws ValueNotFoundException {
        if (iKey < 0 || iKey > this.m_oaValues.length) {
            throw new ValueNotFoundException("Unable to find resource for key=" + iKey);
        }
        return this.m_oaValues[iKey] != null ? this.m_oaValues[iKey].toString() : null;
    }

    public String[] getResourceKeyNames() {
        Class<?> cBundle = this.getClass();
        Field[] fa = null;
        try {
            fa = cBundle.getFields();
        }
        catch (SecurityException ex) {
            return null;
        }
        int[] iaRequiredMods = new int[]{1, 8, 16, 128};
        LinkedList<String> ll = new LinkedList<String>();
        int i = 0;
        while (i < fa.length) {
            int m = fa[i].getModifiers();
            boolean bInclude = true;
            int j = 0;
            while (j < iaRequiredMods.length) {
                if ((m & iaRequiredMods[j]) != iaRequiredMods[j]) {
                    bInclude = false;
                }
                ++j;
            }
            if (bInclude) {
                ll.add(fa[i].getName());
            }
            ++i;
        }
        Object[] oa = ll.toArray();
        String[] sa = new String[oa.length];
        int i2 = 0;
        while (i2 < oa.length) {
            sa[i2] = (String)oa[i2];
            ++i2;
        }
        return sa;
    }

    public static final ResourceManager loadResources(String sFQClass, Locale l) {
        if (l == null) {
            l = Locale.getDefault();
        }
        String sLanguage = l.getLanguage();
        String sCountry = l.getCountry();
        String sVariant = l.getVariant();
        int n = sLanguage.length() > 0 ? 2 : 1;
        n += sCountry.length() > 0 ? 1 : 0;
        String[] saNames = new String[n += sVariant.length() > 0 ? 1 : 0];
        String[] sa = new String[]{sFQClass, "_" + sLanguage, "_" + sCountry, "__" + sVariant};
        saNames[0] = sa[0];
        int i = 1;
        while (i < n) {
            saNames[i] = String.valueOf(saNames[i - 1]) + sa[i];
            ++i;
        }
        Class<?> c = null;
        boolean bFound = false;
        int i2 = n - 1;
        while (i2 >= 0) {
            try {
                c = Class.forName(saNames[i2]);
                bFound = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                --i2;
            }
        }
        if (!bFound) {
            return null;
        }
        try {
            ResourceManager rm = (ResourceManager)c.newInstance();
            return rm;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static final String getMediumDateFormat() {
        return ((SimpleDateFormat)SimpleDateFormat.getDateInstance(2)).toPattern();
    }

    public static final String getNumberFormat(int iFractionDigits) {
        DecimalFormat nf = (DecimalFormat)DecimalFormat.getNumberInstance();
        nf.setMinimumFractionDigits(iFractionDigits);
        nf.setMaximumFractionDigits(iFractionDigits);
        nf.setMinimumIntegerDigits(1);
        return nf.toPattern();
    }

    public static final String getCurrencyFormat(int iFractionDigits) {
        DecimalFormat nf = (DecimalFormat)DecimalFormat.getCurrencyInstance();
        nf.setMinimumFractionDigits(iFractionDigits);
        nf.setMaximumFractionDigits(iFractionDigits);
        nf.setMinimumIntegerDigits(1);
        return nf.toPattern();
    }
}

