/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util;

import java.text.MessageFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.oda.util.ResourceCache;
import org.eclipse.birt.data.oda.util.ResourceManager;

public final class StringSubstitutionUtil {
    private static String sm_loggerName;
    private static Logger sm_logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.oda.util.StringSubstitutionUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_loggerName = clazz.getName();
        sm_logger = Logger.getLogger(sm_loggerName);
    }

    private StringSubstitutionUtil() {
    }

    public static void setLogger(Logger logger) {
        sm_logger = logger;
    }

    public static void resetLogger() {
        sm_logger = null;
    }

    private static void log(String message) {
        if (sm_logger != null) {
            sm_logger.log(Level.FINEST, message);
        }
    }

    private static void log(Throwable thrown) {
        if (sm_logger != null) {
            sm_logger.log(Level.WARNING, thrown.getLocalizedMessage(), thrown);
        }
    }

    public static int getDelimitedStringCount(String text, String startDelimiter) {
        return StringSubstitutionUtil.getDelimitedStringCount(text, startDelimiter, false);
    }

    public static int getDelimitedStringCount(String text, String startDelimiter, boolean requiresNamedDelimiters) {
        String context = "StringSubstitutionUtil.getDelimitedStringCount( " + text + ", " + startDelimiter + ", " + requiresNamedDelimiters + " )\t";
        StringSubstitutionUtil.log(String.valueOf(context) + "Called.");
        StringSubstitutionUtil.sanityCheck(text, startDelimiter);
        startDelimiter = StringSubstitutionUtil.sanityCheckDelimiter(startDelimiter);
        int startDelimiterLength = startDelimiter.length();
        StringBuffer stringBuffer = new StringBuffer(text);
        int index = 0;
        int numOfDelimitedStrings = 0;
        while ((index = text.indexOf(startDelimiter, index)) >= 0) {
            StringSubstitutionUtil.log(String.valueOf(context) + "index: " + index);
            int endIndex = StringSubstitutionUtil.getDelimitedStringEndIndex(stringBuffer, index, startDelimiterLength, requiresNamedDelimiters);
            if (endIndex == -1) {
                index += startDelimiterLength;
                continue;
            }
            ++numOfDelimitedStrings;
            index = endIndex + 1;
        }
        StringSubstitutionUtil.log(String.valueOf(context) + "Exiting: " + numOfDelimitedStrings);
        return numOfDelimitedStrings;
    }

    public static int getDelimitedStringCount(String text, String startDelimiter, String endDelimiter) {
        return StringSubstitutionUtil.getDelimitedStringCount(text, startDelimiter, endDelimiter, false);
    }

    public static int getDelimitedStringCount(String text, String startDelimiter, String endDelimiter, boolean requiresNamedDelimiters) {
        String context = "StringSubstitutionUtil.getDelimitedStringCount( " + text + ", " + startDelimiter + ", " + endDelimiter + ", " + requiresNamedDelimiters + " )\t";
        StringSubstitutionUtil.log(String.valueOf(context) + "Called.");
        StringSubstitutionUtil.sanityCheck(text, startDelimiter, endDelimiter);
        startDelimiter = StringSubstitutionUtil.sanityCheckDelimiter(startDelimiter);
        endDelimiter = StringSubstitutionUtil.sanityCheckDelimiter(endDelimiter);
        int startDelimiterLength = startDelimiter.length();
        int endDelimiterLength = endDelimiter.length();
        StringBuffer stringBuffer = new StringBuffer(text);
        int startIndex = 0;
        int currIndex = 0;
        int numOfDelimitedStrings = 0;
        while ((startIndex = text.indexOf(startDelimiter, currIndex)) >= 0) {
            StringSubstitutionUtil.log(String.valueOf(context) + "startIndex: " + startIndex + ", currIndex: " + currIndex);
            currIndex = startIndex + startDelimiterLength;
            if (!StringSubstitutionUtil.isStartDelimiter(startIndex, stringBuffer)) continue;
            int endIndex = StringSubstitutionUtil.getDelimitedStringEndIndex(stringBuffer, startIndex, startDelimiterLength, endDelimiter, requiresNamedDelimiters);
            if (endIndex < 0) break;
            ++numOfDelimitedStrings;
            currIndex = endIndex += endDelimiterLength;
        }
        StringSubstitutionUtil.log(String.valueOf(context) + "Exiting: " + numOfDelimitedStrings);
        return numOfDelimitedStrings;
    }

    public static String substituteByIndex(String text, String startDelimiter, List substitutionList) {
        String context = "StringSubstitutionUtil.substituteByIndex( " + text + ", " + startDelimiter + ", " + substitutionList + " )\t";
        StringSubstitutionUtil.log(String.valueOf(context) + "Called.");
        StringSubstitutionUtil.sanityCheck(text, startDelimiter, substitutionList);
        startDelimiter = StringSubstitutionUtil.sanityCheckDelimiter(startDelimiter);
        int startDelimiterLength = startDelimiter.length();
        StringBuffer stringBuffer = new StringBuffer(text);
        int index = 0;
        ListIterator substitutionListIter = substitutionList.listIterator();
        while ((index = stringBuffer.toString().indexOf(startDelimiter, index)) >= 0) {
            StringSubstitutionUtil.log(String.valueOf(context) + "index: " + index);
            int endIndex = StringSubstitutionUtil.getDelimitedStringEndIndex(stringBuffer, index, startDelimiterLength, false);
            if (endIndex == -1) {
                index += startDelimiterLength;
                continue;
            }
            if (!substitutionListIter.hasNext()) {
                String message = StringSubstitutionUtil.getLocalizedMessage(24, new Object[]{stringBuffer.substring(index + startDelimiterLength, endIndex)});
                throw StringSubstitutionUtil.newIllegalArgumentException(message);
            }
            String replacementString = (String)substitutionListIter.next();
            if (replacementString == null) {
                String message = StringSubstitutionUtil.getLocalizedMessage(28);
                throw StringSubstitutionUtil.newIllegalArgumentException(message);
            }
            stringBuffer.replace(index, endIndex, replacementString);
            index += replacementString.length();
        }
        String ret = stringBuffer.toString();
        StringSubstitutionUtil.log(String.valueOf(context) + "Exiting: " + ret);
        return ret;
    }

    public static String substituteByIndex(String text, String startDelimiter, String endDelimiter, List substitutionList) {
        String context = "StringSubstitutionUtil.substituteByIndex( " + text + ", " + startDelimiter + ", " + endDelimiter + ", " + substitutionList + " )\t";
        StringSubstitutionUtil.log(String.valueOf(context) + "Called.");
        StringSubstitutionUtil.sanityCheck(text, startDelimiter, endDelimiter, substitutionList);
        startDelimiter = StringSubstitutionUtil.sanityCheckDelimiter(startDelimiter);
        endDelimiter = StringSubstitutionUtil.sanityCheckDelimiter(endDelimiter);
        int startDelimiterLength = startDelimiter.length();
        int endDelimiterLength = endDelimiter.length();
        StringBuffer stringBuffer = new StringBuffer(text);
        ListIterator substitutionListIter = substitutionList.listIterator();
        int startIndex = 0;
        int currIndex = 0;
        while ((startIndex = stringBuffer.toString().indexOf(startDelimiter, currIndex)) >= 0) {
            StringSubstitutionUtil.log(String.valueOf(context) + "startIndex: " + startIndex + ", currIndex: " + currIndex);
            currIndex = startIndex + startDelimiterLength;
            if (!StringSubstitutionUtil.isStartDelimiter(startIndex, stringBuffer)) continue;
            int endIndex = StringSubstitutionUtil.getDelimitedStringEndIndex(stringBuffer, startIndex, startDelimiterLength, endDelimiter, false);
            if (endIndex < 0) break;
            if (!substitutionListIter.hasNext()) {
                String message = StringSubstitutionUtil.getLocalizedMessage(24, new Object[]{stringBuffer.substring(startIndex + startDelimiterLength, endIndex)});
                throw StringSubstitutionUtil.newIllegalArgumentException(message);
            }
            String replacementString = (String)substitutionListIter.next();
            if (replacementString == null) {
                throw StringSubstitutionUtil.newIllegalArgumentException(StringSubstitutionUtil.getLocalizedMessage(28));
            }
            stringBuffer.replace(startIndex, endIndex += endDelimiterLength, replacementString);
            currIndex = startIndex + replacementString.length();
        }
        String ret = stringBuffer.toString();
        StringSubstitutionUtil.log(String.valueOf(context) + "Exiting: " + ret);
        return ret;
    }

    public static String substituteByName(String text, String startDelimiter, Map nameValues) {
        String context = "StringSubstitutionUtil.substituteByName( " + text + ", " + startDelimiter + ", " + nameValues + " )\t";
        StringSubstitutionUtil.log(String.valueOf(context) + "Called.");
        StringSubstitutionUtil.sanityCheck(text, startDelimiter, nameValues);
        startDelimiter = StringSubstitutionUtil.sanityCheckDelimiter(startDelimiter);
        int startDelimiterLength = startDelimiter.length();
        StringBuffer stringBuffer = new StringBuffer(text);
        int index = 0;
        while ((index = stringBuffer.toString().indexOf(startDelimiter, index)) >= 0) {
            StringSubstitutionUtil.log(String.valueOf(context) + "index: " + index);
            int endIndex = StringSubstitutionUtil.getDelimitedStringEndIndex(stringBuffer, index, startDelimiterLength, true);
            if (endIndex == -1) {
                index += startDelimiterLength;
                continue;
            }
            String delimitedString = stringBuffer.substring(index + startDelimiterLength, endIndex);
            String replacementString = (String)nameValues.get(delimitedString);
            if (replacementString == null) {
                String message = StringSubstitutionUtil.getLocalizedMessage(28);
                message = String.valueOf(message) + " [" + delimitedString + "]";
                throw StringSubstitutionUtil.newIllegalArgumentException(message);
            }
            stringBuffer.replace(index, endIndex, replacementString);
            index += replacementString.length();
        }
        String ret = stringBuffer.toString();
        StringSubstitutionUtil.log(String.valueOf(context) + "Exiting: " + ret);
        return ret;
    }

    public static String substituteByName(String text, String startDelimiter, String endDelimiter, Map nameValues) {
        String context = "StringSubstitutionUtil.substituteByName( " + text + ", " + startDelimiter + ", " + endDelimiter + ", " + nameValues + " )\t";
        StringSubstitutionUtil.log(String.valueOf(context) + "Called.");
        StringSubstitutionUtil.sanityCheck(text, startDelimiter, endDelimiter, nameValues);
        startDelimiter = StringSubstitutionUtil.sanityCheckDelimiter(startDelimiter);
        endDelimiter = StringSubstitutionUtil.sanityCheckDelimiter(endDelimiter);
        int startDelimiterLength = startDelimiter.length();
        int endDelimiterLength = endDelimiter.length();
        StringBuffer stringBuffer = new StringBuffer(text);
        int startIndex = 0;
        int currIndex = 0;
        while ((startIndex = stringBuffer.toString().indexOf(startDelimiter, currIndex)) >= 0) {
            StringSubstitutionUtil.log(String.valueOf(context) + "startIndex: " + startIndex + ", currIndex: " + currIndex);
            currIndex = startIndex + startDelimiterLength;
            if (!StringSubstitutionUtil.isStartDelimiter(startIndex, stringBuffer)) continue;
            int endIndex = StringSubstitutionUtil.getDelimitedStringEndIndex(stringBuffer, startIndex, startDelimiterLength, endDelimiter, true);
            if (endIndex < 0) break;
            String delimitedString = stringBuffer.substring(startIndex + startDelimiterLength, endIndex);
            String replacementString = (String)nameValues.get(delimitedString);
            if (replacementString == null) {
                String message = StringSubstitutionUtil.getLocalizedMessage(28);
                message = String.valueOf(message) + " [" + delimitedString + "]";
                throw StringSubstitutionUtil.newIllegalArgumentException(message);
            }
            stringBuffer.replace(startIndex, endIndex += endDelimiterLength, replacementString);
            currIndex = startIndex + replacementString.length();
        }
        String ret = stringBuffer.toString();
        StringSubstitutionUtil.log(String.valueOf(context) + "Exiting: " + ret);
        return ret;
    }

    private static void sanityCheck(String text, String startDelimiter, String endDelimiter, Object listOrMap) {
        StringSubstitutionUtil.sanityCheck(text, startDelimiter, endDelimiter);
        StringSubstitutionUtil.sanityCheck(listOrMap);
    }

    private static void sanityCheck(String text, String startDelimiter, Object listOrMap) {
        StringSubstitutionUtil.sanityCheck(text, startDelimiter);
        StringSubstitutionUtil.sanityCheck(listOrMap);
    }

    private static void sanityCheck(String text, String startDelimiter, String endDelimiter) {
        StringSubstitutionUtil.sanityCheck(text, startDelimiter);
        if (endDelimiter == null) {
            throw StringSubstitutionUtil.newNullPointerException(StringSubstitutionUtil.getLocalizedMessage(26));
        }
    }

    private static void sanityCheck(String text, String startDelimiter) {
        if (text == null) {
            throw StringSubstitutionUtil.newNullPointerException(StringSubstitutionUtil.getLocalizedMessage(29));
        }
        if (startDelimiter == null) {
            throw StringSubstitutionUtil.newNullPointerException(StringSubstitutionUtil.getLocalizedMessage(26));
        }
    }

    private static void sanityCheck(Object listOrMap) {
        if (listOrMap == null) {
            String message = StringSubstitutionUtil.getLocalizedMessage(listOrMap instanceof List ? 27 : 30);
            throw StringSubstitutionUtil.newNullPointerException(message);
        }
    }

    private static String sanityCheckDelimiter(String delimiter) {
        String trimmed = delimiter.trim();
        int length = trimmed.length();
        if (length == 0) {
            throw StringSubstitutionUtil.newIllegalArgumentException(StringSubstitutionUtil.getLocalizedMessage(25));
        }
        return trimmed;
    }

    private static int getDelimitedStringEndIndex(StringBuffer stringBuffer, int index, int startDelimiterLength, boolean requiresNamedDelimiters) {
        String context = "StringSubstitutionUtil.getDelimitedStringEndIndex( " + stringBuffer + ", " + index + ", " + startDelimiterLength + " )\t";
        StringSubstitutionUtil.log(String.valueOf(context) + "Called.");
        if (!StringSubstitutionUtil.isStartDelimiter(index, stringBuffer)) {
            StringSubstitutionUtil.log(String.valueOf(context) + "Not a start delimiter. Exiting: -1");
            return -1;
        }
        int endIndex = index + startDelimiterLength;
        while (endIndex < stringBuffer.length() && StringSubstitutionUtil.isStringMarkerCharacter(stringBuffer.charAt(endIndex))) {
            ++endIndex;
        }
        if (endIndex == index + startDelimiterLength && (requiresNamedDelimiters || endIndex < stringBuffer.length() && !Character.isWhitespace(stringBuffer.charAt(endIndex)))) {
            StringSubstitutionUtil.log(String.valueOf(context) + "Not an embedded marker. Exiting: -1");
            return -1;
        }
        StringSubstitutionUtil.log(String.valueOf(context) + "Exiting: " + endIndex);
        return endIndex;
    }

    private static int getDelimitedStringEndIndex(StringBuffer stringBuffer, int startIndex, int startDelimiterLength, String endDelimiter, boolean requiresNamedDelimiters) {
        String context = "StringSubstitutional.getDelimitedStringEndIndex( " + stringBuffer + ", " + startIndex + ", " + startDelimiterLength + ", " + endDelimiter + " )\t";
        StringSubstitutionUtil.log(String.valueOf(context) + "Called.");
        int currIndex = startIndex + startDelimiterLength;
        int endDelimiterLength = endDelimiter.length();
        int endIndex = -1;
        String string = stringBuffer.toString();
        while ((endIndex = string.indexOf(endDelimiter, currIndex)) >= 0) {
            StringSubstitutionUtil.log(String.valueOf(context) + "endIndex: " + endIndex + ", currIndex: " + currIndex);
            if (StringSubstitutionUtil.isEndDelimiter(startIndex + startDelimiterLength, endIndex, endDelimiterLength, string, requiresNamedDelimiters)) break;
            currIndex = endIndex + endDelimiterLength;
        }
        StringSubstitutionUtil.log(String.valueOf(context) + "Exiting: " + endIndex);
        return endIndex;
    }

    private static boolean isStringMarkerCharacter(char c) {
        return Character.isLetterOrDigit(c) || StringSubstitutionUtil.isContinuatorCharacter(c);
    }

    private static boolean isContinuatorCharacter(char c) {
        return c == '_';
    }

    private static boolean isEscapeCharacter(char c) {
        return c == '\\';
    }

    private static boolean isStartDelimiter(int startDelimiterIndex, StringBuffer stringBuffer) {
        String context = "StringSubstitutionUtil.isStartDelimiter( " + startDelimiterIndex + ", " + stringBuffer + " )\t";
        StringSubstitutionUtil.log(String.valueOf(context) + "Called.");
        if (startDelimiterIndex == 0) {
            StringSubstitutionUtil.log(String.valueOf(context) + "Beginning of string. Exiting: " + true);
            return true;
        }
        char prevChar = stringBuffer.charAt(startDelimiterIndex - 1);
        boolean ret = !StringSubstitutionUtil.isStringMarkerCharacter(prevChar) && !StringSubstitutionUtil.isEscapeCharacter(prevChar);
        StringSubstitutionUtil.log(String.valueOf(context) + "Exiting: " + ret);
        return ret;
    }

    private static boolean isEndDelimiter(int afterStartDelimiterIndex, int endIndex, int endDelimiterLength, String string, boolean requiresNamedDelimiters) {
        String context = "StringSubsitutionUtil.isEndDelimiter( " + afterStartDelimiterIndex + ", " + endIndex + ", " + endDelimiterLength + ", " + string + " )\t";
        StringSubstitutionUtil.log(String.valueOf(context) + "Called.");
        if (endIndex == afterStartDelimiterIndex && requiresNamedDelimiters) {
            StringSubstitutionUtil.log(String.valueOf(context) + "Requires a named delimiter. Exiting: " + false);
            return false;
        }
        if (endIndex - 1 >= afterStartDelimiterIndex && StringSubstitutionUtil.isEscapeCharacter(string.charAt(endIndex - 1))) {
            StringSubstitutionUtil.log(String.valueOf(context) + "End delimiter escaped. Exiting: " + false);
            return false;
        }
        boolean ret = endIndex + endDelimiterLength >= string.length() || !StringSubstitutionUtil.isStringMarkerCharacter(string.charAt(endIndex + endDelimiterLength));
        StringSubstitutionUtil.log(String.valueOf(context) + "Exiting: " + ret);
        return ret;
    }

    private static IllegalArgumentException newIllegalArgumentException(String msg) {
        IllegalArgumentException ex = new IllegalArgumentException(msg);
        StringSubstitutionUtil.log(ex);
        return ex;
    }

    private static NullPointerException newNullPointerException(String msg) {
        NullPointerException ex = new NullPointerException(msg);
        StringSubstitutionUtil.log(ex);
        return ex;
    }

    static String getLocalizedMessage(int errorNumber) {
        ResourceManager manager = ResourceCache.instance().getResources("org.eclipse.birt.data.oda.util.OdaResources", Locale.getDefault());
        return manager != null ? manager.getString(errorNumber) : "";
    }

    static String getLocalizedMessage(int errorNumber, Object[] arguments) {
        return MessageFormat.format(StringSubstitutionUtil.getLocalizedMessage(errorNumber), arguments);
    }
}

