/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util.manifest;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.data.oda.OdaException;
import org.eclipse.birt.data.oda.util.manifest.DataSetType;
import org.eclipse.birt.data.oda.util.manifest.JavaRuntimeInterface;
import org.eclipse.birt.data.oda.util.manifest.ManifestExplorer;
import org.eclipse.birt.data.oda.util.manifest.Property;
import org.eclipse.birt.data.oda.util.manifest.RuntimeInterface;
import org.eclipse.birt.data.oda.util.manifest.TraceLogging;

public class ExtensionManifest {
    private String m_namespace;
    private String m_dataSourceElementId;
    private String m_odaVersion;
    private String m_displayName;
    private RuntimeInterface m_runtime;
    private Hashtable m_dataSetTypes;
    private TraceLogging m_traceLogging;
    private Property[] m_properties = null;
    private Properties m_propsVisibility;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.oda.util.manifest.ExtensionManifest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    ExtensionManifest(IExtension dataSourceExtn) throws OdaException {
        IConfigurationElement[] propertiesElements;
        IConfigurationElement dataSourceElement = ManifestExplorer.getDataSourceElement(dataSourceExtn);
        if (!$assertionsDisabled && dataSourceElement == null) {
            throw new AssertionError();
        }
        this.m_namespace = dataSourceExtn.getNamespace();
        this.m_dataSourceElementId = dataSourceElement.getAttribute("id");
        if (this.m_dataSourceElementId == null || this.m_dataSourceElementId.length() == 0) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(9));
        }
        this.m_odaVersion = dataSourceElement.getAttribute("odaVersion");
        this.m_displayName = ManifestExplorer.getElementDisplayName(dataSourceElement);
        String driverClass = dataSourceElement.getAttribute("driverClass");
        if (driverClass == null) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(11, new Object[]{this.m_dataSourceElementId}));
        }
        String needSetThreadContextClassLoader = dataSourceElement.getAttribute("setThreadContextClassLoader");
        if (!needSetThreadContextClassLoader.equalsIgnoreCase("true") && !needSetThreadContextClassLoader.equalsIgnoreCase("false")) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(12, new Object[]{needSetThreadContextClassLoader, this.m_dataSourceElementId}));
        }
        this.m_runtime = new JavaRuntimeInterface(driverClass, Boolean.valueOf(needSetThreadContextClassLoader), this.m_namespace);
        this.m_dataSetTypes = ManifestExplorer.getDataSetElements(dataSourceExtn, this.m_dataSourceElementId);
        IConfigurationElement[] traceLogging = dataSourceElement.getChildren("traceLogging");
        int numOfTraceLogging = traceLogging.length;
        if (numOfTraceLogging > 0) {
            this.m_traceLogging = new TraceLogging(traceLogging[numOfTraceLogging - 1], this.m_dataSourceElementId);
        }
        if ((propertiesElements = dataSourceElement.getChildren("properties")).length > 0) {
            IConfigurationElement propertiesElement = propertiesElements[propertiesElements.length - 1];
            this.m_properties = ExtensionManifest.getPropertyDefinitions(propertiesElement);
            this.m_propsVisibility = ExtensionManifest.getPropertyVisibilities(propertiesElement);
        }
    }

    static Property[] getPropertyDefinitions(IConfigurationElement propertiesElement) throws OdaException {
        IConfigurationElement[] propGroupElements;
        IConfigurationElement[] propElements = propertiesElement.getChildren("property");
        int numProperties = propElements.length + (propGroupElements = propertiesElement.getChildren("propertyGroup")).length;
        if (numProperties <= 0) {
            return new Property[0];
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        int i = 0;
        int size = propElements.length;
        while (i < size) {
            IConfigurationElement propElement = propElements[i];
            properties.add(new Property(propElement));
            ++i;
        }
        int j = 0;
        int size2 = propGroupElements.length;
        while (j < size2) {
            IConfigurationElement propGroupElement = propGroupElements[j];
            String groupName = propGroupElement.getAttribute("name");
            String groupDisplayName = ManifestExplorer.getElementDisplayName(propGroupElement);
            IConfigurationElement[] groupedPropElements = propGroupElement.getChildren("property");
            int i2 = 0;
            int size3 = groupedPropElements.length;
            while (i2 < size3) {
                IConfigurationElement groupedPropElement = groupedPropElements[i2];
                properties.add(new Property(groupedPropElement, groupName, groupDisplayName));
                ++i2;
            }
            ++j;
        }
        return properties.toArray(new Property[properties.size()]);
    }

    static Properties getPropertyVisibilities(IConfigurationElement propertiesElement) throws OdaException {
        IConfigurationElement[] propVisibilityElements = propertiesElement.getChildren("propertyVisibility");
        if (propVisibilityElements.length == 0) {
            return null;
        }
        Properties propsVisibility = new Properties();
        int i = 0;
        int size = propVisibilityElements.length;
        while (i < size) {
            IConfigurationElement propVisibltyElement = propVisibilityElements[i];
            String propName = propVisibltyElement.getAttribute("name");
            String propVisbility = propVisibltyElement.getAttribute("visibility");
            propsVisibility.setProperty(propName, propVisbility);
            ++i;
        }
        return propsVisibility;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getExtensionID() {
        return this.getDataSourceElementID();
    }

    public String getDataSourceElementID() {
        return this.m_dataSourceElementId;
    }

    public URL getDriverLocation() throws IOException {
        return this.m_runtime.getLibraryLocation();
    }

    public String getOdaVersion() {
        return this.m_odaVersion;
    }

    public String getDataSourceDisplayName() {
        return this.m_displayName;
    }

    public DataSetType[] getDataSetTypes() {
        Collection dataSetTypes = this.m_dataSetTypes.values();
        int size = dataSetTypes.size();
        return dataSetTypes.toArray(new DataSetType[size]);
    }

    public String[] getDataSetTypeIDs() {
        Set dataSetTypeIDs = this.m_dataSetTypes.keySet();
        int size = dataSetTypeIDs.size();
        return dataSetTypeIDs.toArray(new String[size]);
    }

    public DataSetType getDataSetType(String dataSetElementID) throws OdaException {
        if (dataSetElementID == null) {
            if (this.m_dataSetTypes.size() != 1) {
                this.throwsIllegalArgumentOdaException(dataSetElementID);
            }
            Collection dataSetTypes = this.m_dataSetTypes.values();
            if (!$assertionsDisabled && dataSetTypes.size() != 1) {
                throw new AssertionError();
            }
            return (DataSetType)dataSetTypes.toArray()[0];
        }
        DataSetType dsType = (DataSetType)this.m_dataSetTypes.get(dataSetElementID);
        if (dsType == null) {
            this.throwsIllegalArgumentOdaException(dataSetElementID);
        }
        return dsType;
    }

    private void throwsIllegalArgumentOdaException(String arg) throws OdaException {
        IllegalArgumentException illegalArg = new IllegalArgumentException(arg);
        throw new OdaException(illegalArg.getLocalizedMessage());
    }

    public TraceLogging getTraceLogging() {
        return this.m_traceLogging;
    }

    public RuntimeInterface getRuntimeInterface() {
        return this.m_runtime;
    }

    public Property[] getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new Property[0];
        }
        return this.m_properties;
    }

    public Properties getPropertiesVisibility() {
        if (this.m_propsVisibility == null) {
            this.m_propsVisibility = new Properties();
        }
        return this.m_propsVisibility;
    }
}

