/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util.manifest;

import java.util.ArrayList;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.data.oda.util.manifest.ManifestExplorer;
import org.eclipse.birt.data.oda.util.manifest.PropertyChoice;

public class Property {
    private String m_name;
    private String m_displayName;
    private String m_groupName;
    private String m_groupDisplayName;
    private String m_type;
    private boolean m_canInherit = true;
    private String m_defaultValue;
    private boolean m_isEncryptable = false;
    private PropertyChoice[] m_choices = null;

    Property(IConfigurationElement propertyElement) {
        this.setAttributes(propertyElement, null, null);
    }

    Property(IConfigurationElement propertyElement, String groupName, String groupDisplayName) {
        this.setAttributes(propertyElement, groupName, groupDisplayName);
    }

    private void setAttributes(IConfigurationElement propertyElement, String groupName, String groupDisplayName) {
        IConfigurationElement[] choiceElements;
        int numChoices;
        this.m_name = propertyElement.getAttribute("name");
        this.m_displayName = ManifestExplorer.getElementDisplayName(propertyElement);
        this.m_groupName = groupName;
        this.m_groupDisplayName = groupDisplayName;
        this.m_type = propertyElement.getAttribute("type");
        this.m_defaultValue = propertyElement.getAttribute("defaultValue");
        this.m_isEncryptable = false;
        String encryptableValue = propertyElement.getAttribute("isEncryptable");
        if (encryptableValue != null && (encryptableValue.equalsIgnoreCase("true") || encryptableValue.equalsIgnoreCase("false"))) {
            this.m_isEncryptable = Boolean.valueOf(encryptableValue);
        }
        this.m_canInherit = true;
        String canInherit = propertyElement.getAttribute("canInherit");
        if (canInherit != null && (canInherit.equalsIgnoreCase("true") || canInherit.equalsIgnoreCase("false"))) {
            this.m_canInherit = Boolean.valueOf(canInherit);
        }
        if ((numChoices = (choiceElements = propertyElement.getChildren("choice")).length) <= 0) {
            return;
        }
        ArrayList<PropertyChoice> choices = new ArrayList<PropertyChoice>(numChoices);
        int i = 0;
        while (i < numChoices) {
            IConfigurationElement choiceElement = choiceElements[i];
            choices.add(new PropertyChoice(choiceElement));
            ++i;
        }
        this.m_choices = choices.toArray(new PropertyChoice[numChoices]);
    }

    public String getName() {
        return this.m_name;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public String getGroupDisplayName() {
        return this.m_groupDisplayName;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean canInherit() {
        return this.m_canInherit;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public boolean isEncryptable() {
        return this.m_isEncryptable;
    }

    public PropertyChoice[] getChoices() {
        if (this.m_choices == null) {
            this.m_choices = new PropertyChoice[0];
        }
        return this.m_choices;
    }
}

