
package org.eclipse.birt.report.tests.engine.api;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class Bug128854PrompttextTest extends EngineCase
{

	public Bug128854PrompttextTest( String name )
	{
		super( name );
	}

	public static Test Suite( )
	{
		return new TestSuite( Bug128854PrompttextTest.class );
	}

	public void testGetPromptText( )
	{
		IGetParameterDefinitionTask getParameterDefnTask;
		IScalarParameterDefn paramDefn;

		String report_design = this.getClassFolder( ) + "/" + INPUT_FOLDER + "/"
		+ "Bug128854_ParameterPromptText.rptdesign";

		
		try
		{
			IReportRunnable runnable = engine.openReportDesign( report_design );
			getParameterDefnTask = engine
					.createGetParameterDefinitionTask( runnable );
			paramDefn = (IScalarParameterDefn) getParameterDefnTask
					.getParameterDefn( "p1" );

			String goldText = "Parameter 1", promptText;
			promptText = paramDefn.getPromptText( );
			assertEquals( "Return wrong prompt text of p1", goldText,
					promptText );
		}
		catch ( EngineException ee )
		{
			assertFalse( "Exception occurred: " + ee.getErrorCode( ), true );
			ee.printStackTrace( );
		}

	}

}
