/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.engine.api;

import java.util.HashMap;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.tests.engine.EngineCase;


public class HTMLActionHandlerTest extends EngineCase {

	/**
	 * @param name
	 */
	public HTMLActionHandlerTest(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}

	public static Test suite(){
		return new TestSuite(HTMLActionHandlerTest.class);
	}
	
	/**
	 * Test getURL(IAction actionDefn, java.lang.Object context) method
	 *
	 */
	public void testGetURLBookmark(){
		HTMLRenderContext context = new HTMLRenderContext( );
		context.setBaseURL( "http://localhost/birt/servlet" ); //$NON-NLS-1$
		context.setImageDirectory( "image" ); //$NON-NLS-1$
		context.setBaseImageURL( "http://localhost/birt/image" ); //$NON-NLS-1$
		
		//normal bookmark
		HTMLActionHandler handler=new HTMLActionHandler();
		String bookmark = "bookmark";//$NON-NLS-1$
		IHyperlinkAction action = new ActionContent( );
		action.setBookmark( bookmark );
		IAction act = new Action( action );
		String url = handler.getURL( act, context );
		bookmark="#"+bookmark;
		assertEquals("getURL(.) should return bookmark",bookmark,url);
		
		//blank bookmark value
		bookmark="";
		action.setBookmark(bookmark);
		act=new Action(action);
		url=handler.getURL(act,context);
		bookmark="#"+bookmark;
		assertEquals("getURL(.) should return blank value",bookmark,url);

		//bookmark special character value
		bookmark="/()=?`!\"?$?:;_?????";
		action.setBookmark(bookmark);
		act=new Action(action);
		url=handler.getURL(act,context);
		bookmark="#"+bookmark;
		assertEquals("getURL(.) should return /()=?`!\"?$?:;_????? value",bookmark,url);
		
		//null bookmark
		bookmark=null;
		action.setBookmark(bookmark);
		act=new Action(action);
		url=handler.getURL(act,context);
		
		assertNull("getURL(.) should process null value",url);
	}
	
	/**
	 * Test getURL(IAction actionDefn, java.lang.Object context) method
	 *
	 */
	public void testGetURLHyperlink(){
		HTMLRenderContext context = new HTMLRenderContext( );
		context.setBaseURL( "http://localhost/birt/servlet" ); //$NON-NLS-1$
		context.setImageDirectory( "image" ); //$NON-NLS-1$
		context.setBaseImageURL( "http://localhost/birt/image" ); //$NON-NLS-1$
		
		//normal hyperlink
		HTMLActionHandler handler=new HTMLActionHandler();
		String hyperlink = "hyperlink";//$NON-NLS-1$
		String target="_blank";
		IHyperlinkAction action = new ActionContent( );
		action.setHyperlink( hyperlink,target );
		IAction act = new Action( action );
		String url = handler.getURL( act, context );
		assertEquals("getURL(.) should return hyperlink",hyperlink,url);
		
		//blank hyperlink value
		hyperlink="";
		action.setHyperlink(hyperlink,target);
		act=new Action(action);
		url=handler.getURL(act,context);
		assertEquals("getURL(.) should return blank value",hyperlink,url);

		//hyperlink special character value
		hyperlink="/()=?`!\"?$?:;_?????";
		action.setHyperlink(hyperlink,target);
		act=new Action(action);
		url=handler.getURL(act,context);
		assertEquals("getURL(.) should return /()=?`!\"?$?:;_????? value",hyperlink,url);

		//null hyperlink value
		hyperlink=null;
		action.setHyperlink(hyperlink,target);
		act=new Action(action);
		url=handler.getURL(act,context);
		assertNull("getURL(.) should return null",url);
	
	}

	/**
	 * Test getURL(IAction actionDefn, java.lang.Object context) method
	 *
	 */
/*	public void testGetURLDrillthrough(){
		HTMLRenderContext context = new HTMLRenderContext( );
		context.setBaseURL( "http://localhost/birt/servlet" ); //$NON-NLS-1$
		context.setImageDirectory( "image" ); //$NON-NLS-1$
		context.setBaseImageURL( "http://localhost/birt/image" ); //$NON-NLS-1$
		
		HTMLActionHandler handler=new HTMLActionHandler();
		String bookmark = "bookmark";//$NON-NLS-1$
		String reportName = "report";//$NON-NLS-1$
		HashMap params = new HashMap( );
		params.put( "param1", "string" );
		String goldenUrl = "http://localhost/birt/servlet?__report=report&param1=string#bookmark";

		IHyperlinkAction action = new ActionContent( );
		action.setDrillThrough( bookmark, reportName, params, null, "_blank" );//$NON-NLS-1$
		IAction act = new Action( action );
		String url = handler.getURL( act, context );

		assertEquals("getURL(.) should goldenurl value", goldenUrl, url );//$NON-NLS-1$
	}
	
*/
}
