/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.report.tests.engine.compatibility.reportdoc;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.birt.report.tests.engine.EngineCase;

/**
 * Engine report document compatibility test
 */
public class CompatibilityTest extends EngineCase
{

	/**
	 * Render previous version of report doc, test to see if it can be correctly
	 * rendered.
	 * <p>
	 * Render all the rptDocument files under input folder.
	 * 
	 * @param fileName
	 *            document file name
	 * @throws Exception
	 */

	public void testReportDoc( String fileName ) throws Exception
	{
		String output = fileName.substring( 0, fileName.lastIndexOf( '.' ) + 1 )
				+ "html"; //$NON-NLS-1$

		render_HTML( fileName, output, "All" ); //$NON-NLS-1$

		// FIXME: adjust the golden files and remove the comments.
		// assertTrue( compareHTML( output, output ));

		String outputFile = this.getClassFolder( ) + "/" + OUTPUT_FOLDER //$NON-NLS-1$
				+ "/" + output; //$NON-NLS-1$
		assertTrue( new File( outputFile ).exists( ) );
	}

	/**
	 * Check two things:
	 * <li> All rptdocuments under "input" are tested.
	 * <li> There exist an A.rptdesign or A.rpttemplate for a A.rptdocument.
	 * 
	 */
	public void sanityCheck( )
	{
		String inputdir = this.getClassFolder( ) + "/" + INPUT_FOLDER; //$NON-NLS-1$

		String[] rptdocs = new File( inputdir ).list( new FilenameFilter( ) {

			public boolean accept( File dir, String name )
			{
				return name.endsWith( ".rptdocument" ); //$NON-NLS-1$
			}
		} );

		String[] rptdesigns = new File( inputdir ).list( new FilenameFilter( ) {

			public boolean accept( File dir, String name )
			{
				return name.endsWith( ".rptdesign" ) || name.endsWith( ".rpttemplate" ); //$NON-NLS-1$ //$NON-NLS-2$
			}
		} );

		Set designSet = new HashSet( );
		for ( int i = 0; i < rptdesigns.length; i++ )
		{
			designSet.add( rptdesigns[i] );
		}

		Set testSet = new HashSet( );
		Method[] methods = this.getClass( ).getMethods( );
		for ( int i = 0; i < methods.length; i++ )
		{
			Method method = methods[i];
			String name = method.getName( );

			if ( name.startsWith( "test_" ) ) //$NON-NLS-1$
			{
				// add clob_v201 into the case set.

				testSet.add( name );
			}
		}

		for ( int i = 0; i < rptdocs.length; i++ )
		{
			String docName = rptdocs[i];
			String temp = "test_" + docName.substring( 0, docName.lastIndexOf( '.' ) ); // clob_v2.0.1
			// //$NON-NLS-1$
			temp = temp.replace( '.', '_' );

			String designName = docName
					.substring( 0, docName.lastIndexOf( '.' ) )
					+ ".rptdesign"; //$NON-NLS-1$
			String templateName = docName.substring( 0, docName
					.lastIndexOf( '.' ) )
					+ ".rpttemplate"; //$NON-NLS-1$

			if ( designSet.contains( designName ) )
			{
				System.out
						.println( "Design file: \"" + designName + "\" is  added." ); //$NON-NLS-1$//$NON-NLS-2$
			}
			else if ( designSet.contains( templateName ) )
			{
				System.out
				.println( "Template file: \"" + templateName + "\" is  added." ); //$NON-NLS-1$//$NON-NLS-2$
			}
			else
			{
				fail( "Design(or template) file: \"" + designName + "\" or \"" + templateName + "\" is not added." ); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			}

			if ( !testSet.contains( temp ) )
			{
				fail( "Test method: \"" + temp + "( )\" is not added." ); //$NON-NLS-1$//$NON-NLS-2$
			}
			else
			{
				System.out
						.println( "Test method: \"" + temp + "( )\" is  added." ); //$NON-NLS-1$//$NON-NLS-2$
			}
		}
	}

	public void test_clob_v2_0_1( ) throws Exception
	{
		testReportDoc( "clob_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_Oracle_Ds_Num_TOP_N_v2_0_1( ) throws Exception
	{
		testReportDoc( "Oracle_Ds_Num_TOP_N_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_Oracle_DS_Str_BOTTOM_N_v2_0_1( ) throws Exception
	{
		testReportDoc( "Oracle_DS_Str_BOTTOM_N_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_barchart_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_barchart_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_data_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_data_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_dynamictext_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_dynamictext_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_grid_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_grid_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_image_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_image_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_label_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_label_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_library_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_library_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_list_filter_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_list_filter_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_list_group_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_list_group_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_list_highlight_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_list_highlight_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_list_sorting_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_list_sorting_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_list_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_list_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_masterpage_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_masterpage_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_meterchart_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_meterchart_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_pie_chart_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_pie_chart_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_stockchart_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_stockchart_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_style_1_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_style_1_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_style_2_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_style_2_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_table_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_table_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_target_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_target_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_temp_lib_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_temp_lib_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_temp_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_temp_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_text_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_text_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_url_builder_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_url_builder_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}

	public void test_smoke_viewer_v2_0_1( ) throws Exception
	{
		testReportDoc( "smoke_viewer_v2.0.1.rptdocument" ); //$NON-NLS-1$
	}
}
