
package org.eclipse.birt.report.tests.engine.regression;

import org.eclipse.birt.report.tests.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * <p>
 * <b>Test description</b>
 * Test all Text HTML elements Tags:
 * <li>A(Anchor)
 * <li>B(Bold text)
 * <li>BR(line break)
 * <li>CENTER
 * <li>DIV(Generic language/style container)
 * <li>FONT
 * <li>EM
 * <li>l(Italicized text)
 * <li>PRE(preformatted text)
 * <li>P(Paragraph)
 * <li>SPAN(Generic language/style container)
 * <li>STRONG
 * <li>SUB
 * <li>SUP
 * <li>U(Underline)
 * <p>
 * 
 * Bugzilla #118761
 */

public class Reg_TextSupportedHTMLElements extends EngineCase
{

	private final static String INPUT = "text_supported_HTML_elements.rptdesign"; //$NON-NLS-1$
	private final static String GOLDEN = "text_supported_HTML_elements.html"; //$NON-NLS-1$
	private final static String OUTPUT = "text_supported_HTML_elements.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */

	public void test( ) throws Exception
	{
		runAndRender_HTML( INPUT, OUTPUT );
		assertTrue( compareHTML( GOLDEN, OUTPUT ) );
	}

}
