/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.report.tests.engine.regression;

import org.eclipse.birt.report.tests.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>Some styles set as text inline style don't work.
 * <p>
 * <b>Test description</b>
 * Test the following text styles:
 * <li>word-spacing
 * <li>letter-spacing
 * <li>text-indent
 * <li>line-height
 * <p>
 */
public class Regression_118991 extends EngineCase
{

	private final static String INPUT = "regression_118991.rptdesign"; //$NON-NLS-1$
	private final static String GOLDEN = "regression_118991.html"; //$NON-NLS-1$
	private final static String OUTPUT = "regression_118991.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */
	
	public void test( ) throws Exception
	{
		runAndRender_HTML( INPUT, OUTPUT );
		assertTrue( compareHTML( GOLDEN, OUTPUT ) );
	}
}
