/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.report.tests.engine.regression;

import org.eclipse.birt.report.tests.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * Render(PageN) task always returns empty page.
 * <p>
 * <b>Test description</b> The html output should have two pages with one label
 * on each, run the report and then retrieve the 1th page.
 * <p>
 * 
 * 
 */
public class Regression_119766 extends EngineCase
{

	private final static String INPUT = "regression_119766.rptdesign"; //$NON-NLS-1$
	private final static String GOLDEN = "regression_119766.html"; //$NON-NLS-1$
	private final static String OUTPUT = "regression_119766.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */

	public void test( ) throws Exception
	{
		runAndThenRender( INPUT, OUTPUT, "1", "html" ); //$NON-NLS-1$
		assertTrue( super.compareHTML( GOLDEN, OUTPUT ) );
	}
}
