
package org.eclipse.birt.report.tests.engine.regression;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.RunTask;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.emitter.EngineEmitterServices;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.ExecutionContext.ElementExceptionInfo;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.engine.presentation.LocalizedEmitter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.engine.EngineCase;

import com.ibm.icu.util.ULocale;

/**
 * <b>Bug description</b>
 * <p>
 * We should use TableScriptExecutor or GridScriptExecutor in
 * LocalizedEmitter.startTable.
 * <p>
 * <b>Test description</b>
 * <p>
 * This test sets contents generated from TableItemDesign and GridItemDesign as
 * argument for LocalizedEmitter.startTable to make sure they are processed by
 * TableScriptExecutor and GridScriptExecutor separately.
 * 
 */
public class Regression_121032 extends EngineCase
{

	private String separator = System.getProperty( "file.separator" ); //$NON-NLS-1$
	private String file = getClassFolder( ) + separator + INPUT_FOLDER
			+ separator + "regression_121032.rptdesign"; //$NON-NLS-1$

	public void testStartTable( )
	{
		IContentEmitter contentEmitter, localizedEmitter;
		try
		{
			ExecutionContext context = new ExecutionContext( engine, 1 );

			ExtensionManager extManager = ExtensionManager.getInstance( );
			contentEmitter = extManager.createEmitter( "html" );
			DesignSession session = new DesignSession( ULocale.getDefault( ) );
			ReportDesign design = new ReportDesign( session );
			ReportDesignHandle designHandle = new ReportDesignHandle( design );
			designHandle.setFileName( file );
			IReportRunnable runnable = engine.openReportDesign( file );
			RunTask task = new RunTask( engine, runnable );
			EngineEmitterServices service = new EngineEmitterServices( task );
			HTMLRenderOption renderOption = new HTMLRenderOption( );
			renderOption.setOutputFormat( "html" );
			service.setRenderOption( renderOption );

			ReportParser parser = new ReportParser( );
			Report report = parser.parse( designHandle );
			ReportContent reportContent = new ReportContent( report );

			TableItemDesign tableDesign = new TableItemDesign( );
			ITableContent table = reportContent.createTableContent( );
			table.setGenerateBy( tableDesign );

			GridItemDesign gridDesign = new GridItemDesign( );
			ITableContent grid = reportContent.createTableContent( );
			grid.setGenerateBy( gridDesign );

			contentEmitter.initialize( service );
			contentEmitter.start( reportContent );

			localizedEmitter = new LocalizedEmitter( context, contentEmitter );

			localizedEmitter.startTable( table );
			localizedEmitter.startTable( grid );

			// Get Errors if exist
			IContent content = context.getContent( );
			if ( content != null )
			{
				ReportItemDesign itemDesign = (ReportItemDesign) content
						.getGenerateBy( );
				DesignElementHandle handle = itemDesign.getHandle( );
				HashMap elementExceptions = new HashMap( );
				ElementExceptionInfo exInfo = (ElementExceptionInfo) elementExceptions
						.get( handle );
				ArrayList exList = exInfo.getErrorList( );
				if ( exList != null && exList.get( 0 ) != null )
				{
					fail( "LocalizedEmitter.startTable failed!" );
				}
			}
			contentEmitter.end( reportContent );

		}
		catch ( Exception e )
		{
			e.printStackTrace( );
			fail( "regression case of 121032 failed" );
		}
	}
}
