/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.report.tests.engine.regression;

import org.eclipse.birt.report.tests.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * The OnCreate row method does not appear to be getting called. If I use the
 * event class it appears to work. But putting in script does not work. I am
 * using M3.
 * <p>
 * <b>Test description</b>
 * <p>
 * This test covers the execution of onCreate(), onRender() and onPrepare(),
 * ensure they are getting called when previewed.
 * 
 */

public class Regression_121355 extends EngineCase
{

	private final static String INPUT = "regression_121355.rptdesign"; //$NON-NLS-1$
	private final static String GOLDEN = "regression_121355.html"; //$NON-NLS-1$
	private final static String OUTPUT = "regression_121355.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */

	public void test( ) throws Exception
	{
		runAndRender_HTML( INPUT, OUTPUT );
		assertTrue( compareHTML( GOLDEN, OUTPUT ) );
	}
}
