
package org.eclipse.birt.report.tests.engine.regression;

import java.io.IOException;

import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.report.tests.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * FileArchiveWriter constructor doesn't process null argument.
 * <p>
 * <b>Test description</b>
 * <p>
 * This test input null as input argument for FileArchiveWriter class to make
 * sure it is catched as IOException instead of NPE.
 * 
 */

public class Regression_121541 extends EngineCase
{

	public void test( )
	{
		try
		{
			FileArchiveWriter writer = new FileArchiveWriter( null );
		}
		catch ( IOException ioe )
		{
		}
		catch ( Exception e )
		{
			e.printStackTrace( );
			assertTrue( "Null is not processed in FileArchiveWriter", false );
		}
	}

}
