
package org.eclipse.birt.report.tests.engine.regression;

import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.instance.RowInstance;
import org.eclipse.birt.report.tests.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * RowInstance.getHeight -> return value cannot be directly referenced
 * <p>
 * <b>Test description</b>
 * <p>
 * This test make sure RowInstance.getHeight return String value instead of
 * DimensionType
 * 
 */

public class Regression_121547 extends EngineCase
{

	public void test( )
	{
		ExecutionContext context = new ExecutionContext( engine, 0 );
		RowContent content = new RowContent( new ReportContent( ) );
		RowInstance row = new RowInstance( content, context );
		row.setHeight( "6" );
		Object height = row.getHeight( );
		assertTrue( "RowInstance.getHeight return wrong type!",
				height instanceof String );
	}
}
