/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.report.tests.engine.regression;

import org.eclipse.birt.report.tests.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * 
 * <p>
 * <b>Test description</b>
 * Test page break functionality
 * <p>
 * 
 */

public class Regression_122414 extends EngineCase
{

	/**
	 * Ensure pageBreak is ignored on an empty page content
	 * <p>
	 * In the case when pageBreakBefore(Always) is encountered in the Label, the
	 * page content is empty.
	 * 
	 * @throws Exception
	 */

	public void test_pageBreak1( ) throws Exception
	{
		String INPUT = "regression_122414_1.rptdesign"; //$NON-NLS-1$
		String GOLDEN = "regression_122414_1.html"; //$NON-NLS-1$
		String OUTPUT = "regression_122414_1.html"; //$NON-NLS-1$

		runAndRender_HTML( INPUT, OUTPUT );
		assertTrue( compareHTML( GOLDEN, OUTPUT ) );
	}

	/**
	 * Ensure pageBreakBefore(always-excluding-first) works.
	 * <p>
	 * In the case, pageBreakBefore(always-excluding-first) is defined on
	 * "Label2", they shouldn't be a break as it is in the first page.
	 * 
	 * @throws Exception
	 */

	public void test_pageBreak2( ) throws Exception
	{
		String INPUT = "regression_122414_2.rptdesign"; //$NON-NLS-1$
		String GOLDEN = "regression_122414_2.html"; //$NON-NLS-1$
		String OUTPUT = "regression_122414_2.html"; //$NON-NLS-1$

		runAndRender_HTML( INPUT, OUTPUT );
		assertTrue( compareHTML( GOLDEN, OUTPUT ) );
	}

	// TODO: test pageBreakBefore(always-excluding-first) on table/list group
	
	/**
	 * Ensure pageBreakBefore(always), pageBreakAfter(always) work.
	 * <p>
	 * In the case, there lable("label1", "label2" and "label3"), "label2"
	 * defineds a break before and after, html/pdf should have 3 pages.
	 * 
	 * @throws Exception
	 */

	public void test_pageBreak3( ) throws Exception
	{
		String INPUT = "regression_122414_3.rptdesign"; //$NON-NLS-1$
		String GOLDEN = "regression_122414_3.html"; //$NON-NLS-1$
		String OUTPUT = "regression_122414_3.html"; //$NON-NLS-1$

		runAndRender_HTML( INPUT, OUTPUT );
		assertTrue( compareHTML( GOLDEN, OUTPUT ) );
	}
}
