/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.report.tests.engine.regression;

import org.eclipse.birt.report.tests.engine.EngineCase;

/**
 * <b>Bug description</b>
 * <p>
 * Space in text can't be previewed properly in PDF and html.
 * <p>
 * <b>Test description</b>
 * <p>
 * The test xml contain a text item with 3 lines, it tests:
 * <li>First white space in a line will be replaced by &nbsp;
 * <li>Last white space in a line will be replaced by &nbsp;;
 * <li>White spaces at odd position is ignored, while white spaces at even
 * position is replaced by "&nbsp;".
 * 
 */

public class Regression_124083 extends EngineCase
{

	private final static String INPUT = "regression_124083.rptdesign"; //$NON-NLS-1$
	private final static String GOLDEN = "regression_124083.html"; //$NON-NLS-1$
	private final static String OUTPUT = "regression_124083.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */

	public void test( ) throws Exception
	{
		runAndRender_HTML( INPUT, OUTPUT );
		assertTrue( compareHTML( GOLDEN, OUTPUT ) );
	}
}
