/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation. All rights reserved. This program and
 * the accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Actuate Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.birt.report.tests.engine.regression;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.birt.report.tests.engine.EngineCase;

/**
 * <b>Bug description</b>
 * Render a report using default parameter value(p1="true"), then change the value (p1="false") and
 * render again, verify the generations. 
 * 
 */
public class Regression_75549 extends EngineCase
{

	private final static String INPUT = "regression_75549.rptdesign"; //$NON-NLS-1$
	private final static String GOLDEN_1 = "regression_75549_1.html"; //$NON-NLS-1$
	private final static String GOLDEN_2 = "regression_75549_2.html"; //$NON-NLS-1$
	private final static String OUTPUT_1 = "regression_75549_1.html"; //$NON-NLS-1$
	private final static String OUTPUT_2 = "regression_75549_2.html"; //$NON-NLS-1$

	/**
	 * @throws Exception
	 */

	public void test( ) throws Exception
	{
		runAndRender_HTML( INPUT, OUTPUT_1 );
		assertTrue( super.compareHTML( GOLDEN_1, OUTPUT_1 ) );
		
		
		// set p1 to False;
		Map paramMap = new HashMap();
		paramMap.put( "p1",  Boolean.FALSE ); //$NON-NLS-1$
		
		runAndRender( INPUT, OUTPUT_2, paramMap, "html" ); //$NON-NLS-1$
		assertTrue( super.compareHTML( GOLDEN_2, OUTPUT_2 ) );
	}
}
