/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.birt.report.tests.engine.smoke.sampleReport;

import org.eclipse.birt.report.tests.engine.EngineCase;


public class SampleReportTest extends EngineCase
{
	private final String DESIGN_Corporation = "Corporation.rptdesign"; //$NON-NLS-1$
	private final String DESIGN_Payment = "Payment.rptdesign"; //$NON-NLS-1$
	private final String DESIGN_SalesByOffice = "SalesByOffice.rptdesign"; //$NON-NLS-1$
	private final String DESIGN_SalesByProducts = "SalesByProducts.rptdesign"; //$NON-NLS-1$
	private final String DESIGN_StockAnalysis = "StockAnalysis.rptdesign"; //$NON-NLS-1$
	
	public void test_Corporation() throws Exception
	{
		runAndRender_PDF(  DESIGN_Corporation, "Corporation.pdf" ); //$NON-NLS-1$
		runAndRender_HTML( DESIGN_Corporation, "Corporation.html" ); //$NON-NLS-1$
		runAndThenRender( DESIGN_Corporation, "Corporation(doc).pdf", "All", "pdf" );   //$NON-NLS-1$
		runAndThenRender( DESIGN_Corporation, "Corporation(doc).html", "All", "html" );   //$NON-NLS-1$
	}
	
	public void test_Payment() throws Exception
	{
		runAndRender_PDF(  DESIGN_Payment, "Payment.pdf" ); //$NON-NLS-1$
		runAndRender_HTML( DESIGN_Payment, "Payment.html" ); //$NON-NLS-1$
		runAndThenRender( DESIGN_Payment, "Payment(doc).pdf", "All", "pdf" );   //$NON-NLS-1$
		runAndThenRender( DESIGN_Payment, "Payment(doc).html", "All", "html" );   //$NON-NLS-1$
	}
	
	public void test_SalesByOffice() throws Exception
	{
		runAndRender_PDF(  DESIGN_SalesByOffice, "SalesByOffice.pdf" ); //$NON-NLS-1$
		runAndRender_HTML( DESIGN_SalesByOffice, "SalesByOffice.html" ); //$NON-NLS-1$
		runAndThenRender( DESIGN_SalesByOffice, "SalesByOffice(doc).pdf", "All", "pdf" );   //$NON-NLS-1$
		runAndThenRender( DESIGN_SalesByOffice, "SalesByOffice(doc).html", "All", "html" );   //$NON-NLS-1$
	}
	
	public void test_SalesByProducts() throws Exception
	{
		runAndRender_PDF(  DESIGN_SalesByProducts, "SalesByProducts.pdf" ); //$NON-NLS-1$
		runAndRender_HTML( DESIGN_SalesByProducts, "SalesByProducts.html" ); //$NON-NLS-1$
		runAndThenRender( DESIGN_SalesByProducts, "SalesByProducts(doc).pdf", "All", "pdf" );   //$NON-NLS-1$
		runAndThenRender( DESIGN_SalesByProducts, "SalesByProducts(doc).html", "All", "html" );   //$NON-NLS-1$
	}
	public void test_StockAnalysis() throws Exception
	{
		runAndRender_PDF(  DESIGN_StockAnalysis, "StockAnalysis.pdf" ); //$NON-NLS-1$
		runAndRender_HTML( DESIGN_StockAnalysis, "StockAnalysis.html" ); //$NON-NLS-1$
		runAndThenRender( DESIGN_StockAnalysis, "StockAnalysis(doc).pdf", "All", "pdf" );   //$NON-NLS-1$
		runAndThenRender( DESIGN_StockAnalysis, "StockAnalysis(doc).html", "All", "html" );   //$NON-NLS-1$
	}
	
}
