package org.eclipse.birt.report.tests.model.acceptance;

import java.util.Iterator;
import java.util.Locale;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.DesignChoiceConstants;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.elements.interfaces.IReportItemModel;
import org.eclipse.birt.report.model.elements.interfaces.IStyleModel;
import org.eclipse.birt.report.tests.model.BaseTestCase;

import com.ibm.icu.util.ULocale;


public class DataItemHandleTest extends BaseTestCase
{
	private ElementFactory factory = null;
	private DataItemHandle data = null;
	private OdaDataSetHandle dset = null;
	
	public DataItemHandleTest(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}

	public static Test suite()
	{
		return new TestSuite(DataItemHandleTest.class);
	}
	
	public void setUp( ) throws Exception
	{
		super.setUp();
		sessionHandle = DesignEngine.newSession(ULocale.ENGLISH);
		designHandle = sessionHandle.createDesign();
		design = (ReportDesign)designHandle.getModule();
		factory = new ElementFactory( design );
		dset = factory.newOdaDataSet("dset","org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
		data = factory.newDataItem("mydata");
		
		
	}
	
	public void testDataOperations() throws Exception
	{
		//add a data
		data.setDataSet(dset);
		data.setValueExpr("row[\"account_id\"]");
		designHandle.getBody().add(data);
        assertEquals("row[\"account_id\"]",((DataItemHandle)designHandle.getBody().get(0)).getValueExpr());
		
		//undo it
		assertTrue(designHandle.getCommandStack().canUndo());
	    assertFalse(designHandle.getCommandStack().canRedo());
	    designHandle.getCommandStack().undo();
	    assertEquals(0,designHandle.getBody().getCount());
	    
	    //redo it
	    assertTrue(designHandle.getCommandStack().canRedo());
	    designHandle.getCommandStack().redo();
        assertEquals("row[\"account_id\"]",((DataItemHandle)designHandle.getBody().get(0)).getValueExpr());
		
        //delete the data
	    designHandle.getBody().drop(data);
	    assertEquals(0,designHandle.getBody().getCount());
	    
	    //undo it
	    assertTrue(designHandle.getCommandStack().canUndo());
	    assertFalse(designHandle.getCommandStack().canRedo());
	    designHandle.getCommandStack().undo();
	    assertEquals("mydata",designHandle.getBody().get(0).getName());
	    
	    //redo it
	    designHandle.getCommandStack().redo();
	    assertEquals(0,designHandle.getBody().getCount());
		
		//edit the data
	    //value expression
	    designHandle.getCommandStack().undo();
	    data.setValueExpr("row[\"account_nm\"]");
	    
	    designHandle.getCommandStack().undo();
	    assertEquals("row[\"account_id\"]",((DataItemHandle)designHandle.getBody().get(0)).getValueExpr());
	    
	    designHandle.getCommandStack().redo();
	    assertEquals("row[\"account_nm\"]",((DataItemHandle)designHandle.getBody().get(0)).getValueExpr());
		
	    //others
        data.setValueExpr("abc");
	    
	    designHandle.getCommandStack().undo();
	    assertEquals("row[\"account_nm\"]",((DataItemHandle)designHandle.getBody().get(0)).getValueExpr());
	    
	    designHandle.getCommandStack().redo();
	    assertEquals("abc",((DataItemHandle)designHandle.getBody().get(0)).getValueExpr());
		
        data.setValueExpr("&#25968;&#25454;");
	    
	    designHandle.getCommandStack().undo();
	    assertEquals("abc",((DataItemHandle)designHandle.getBody().get(0)).getValueExpr());
	    
	    designHandle.getCommandStack().redo();
	    assertEquals("&#25968;&#25454;",((DataItemHandle)designHandle.getBody().get(0)).getValueExpr());
		
        data.setValueExpr("#/&");
	    
	    designHandle.getCommandStack().undo();
	    assertEquals("&#25968;&#25454;",((DataItemHandle)designHandle.getBody().get(0)).getValueExpr());
	    
	    designHandle.getCommandStack().redo();
	    assertEquals("#/&",((DataItemHandle)designHandle.getBody().get(0)).getValueExpr());
		
//	  copy & paste
	    DataItem newdata = (DataItem)data.copy();
	    assertNotNull(newdata);
	    assertEquals(data.getName(),newdata.getName());
	    design = (ReportDesign)designHandle.getModule();
	    
	    try{
	    	designHandle.getBody().add(newdata.getHandle(design));
		    fail();
	    }
	    catch (NameException e)
	    {
	      assertNotNull(e);
	    }
	    newdata.setName("mydata1");
	    designHandle.getBody().add(newdata.getHandle(design));
	    assertEquals("mydata1",designHandle.getBody().get(1).getName());
	    
	    designHandle.getCommandStack().undo();
	    assertEquals(1,designHandle.getBody().getCount());
	    
	    designHandle.getCommandStack().redo();
	    assertEquals(2,designHandle.getBody().getCount());
	    
	    //cut & paste
	    DataItem newdata1 = (DataItem)data.copy();
	    assertNotNull(newdata1);
	    assertEquals(data.getName(),newdata1.getName());
	    data.drop();
	    designHandle.getBody().add(newdata1.getHandle(design));
	    
	    designHandle.getCommandStack().undo();
	    assertEquals(1,designHandle.getBody().getCount());
	    
	    designHandle.getCommandStack().redo();
	    assertEquals(2,designHandle.getBody().getCount());
	    
	    //rename
	    newdata.setName("goldendata");
	    newdata1.setName("silverdata");
	    assertEquals("goldendata",designHandle.getBody().get(0).getName());
	    assertEquals("silverdata",designHandle.getBody().get(1).getName());
	  
	}
	  public void testDataProperties() throws Exception
	{
		//padding
		data.setProperty(IStyleModel.MARGIN_TOP_PROP,"0pt");
		
        //hyperlink
		StructureFactory factory = new StructureFactory();
	    
	    Action action = factory.createAction();
	    data.setAction(action);
	    data.getActionHandle().setLinkType( DesignChoiceConstants.ACTION_LINK_TYPE_HYPERLINK ); 
		data.getActionHandle().setURI( "%lt;" ); 
		assertEquals("%lt;",data.getActionHandle().getURI());
	
		data.getActionHandle().setURI( "&#32593;&#26684;" );
		assertEquals("&#32593;&#26684;",data.getActionHandle().getURI());
		
	    //margin
		try{
		data.setProperty(IStyleModel.MARGIN_TOP_PROP,"-1pt");
		}
		catch(SemanticException e)
		{
		  assertNotNull(e);
		}
		try{
			data.setProperty(IStyleModel.MARGIN_TOP_PROP,"apt");
			}
			catch(SemanticException e)
			{
			  assertNotNull(e);
			}
		//width
		data.setProperty(IReportItemModel.WIDTH_PROP,"0%");
		data.setProperty(IReportItemModel.WIDTH_PROP,"100%");
		
		designHandle.getCommandStack().undo();
	    assertEquals("0%",data.getStringProperty(IReportItemModel.WIDTH_PROP));
	    
	    designHandle.getCommandStack().redo();
	    assertEquals("100%",data.getStringProperty(IReportItemModel.WIDTH_PROP));
	    
		//name
	    data.setName("%lt;");
		assertEquals("%lt;",data.getName());
		
		data.setName("&#32593;&#26684;");
		assertEquals("&#32593;&#26684;",data.getName());
		
		//border
		try{
			data.setProperty(IStyleModel.BORDER_BOTTOM_WIDTH_PROP,"-1pt");
			}
			catch(SemanticException e)
			{
			  assertNotNull(e);
			}
		
			try{
				data.setProperty(IStyleModel.BORDER_BOTTOM_WIDTH_PROP,"apt");
				}
				catch(SemanticException e)
				{
				  assertNotNull(e);
				}
		
		//highlight
		PropertyHandle propHandle = data.getPropertyHandle(IStyleModel.HIGHLIGHT_RULES_PROP );
		HighlightRule highlight = StructureFactory.createHighlightRule();
		highlight.setTestExpression("row[\"account_id\"]");
		highlight.setOperator(DesignChoiceConstants.MAP_OPERATOR_EQ);
		highlight.setValue1("1");
	    highlight.setProperty(IStyleModel.FONT_FAMILY_PROP,"Arial");
	    highlight.setProperty(IStyleModel.COLOR_PROP,"blue");
	    highlight.setProperty(IStyleModel.FONT_WEIGHT_PROP,"bold");
	    propHandle.addItem(highlight);
	    
	    assertEquals("row[\"account_id\"]",highlight.getTestExpression());
	    assertEquals(DesignChoiceConstants.MAP_OPERATOR_EQ,highlight.getOperator());
	    assertEquals("1",highlight.getValue1());
	    
	    Iterator highlightHandles = propHandle.iterator();
	    HighlightRuleHandle highlightHandle = (HighlightRuleHandle) highlightHandles.next( );
	    assertEquals("Arial",highlightHandle.getFontFamilyHandle().getValue());
	    assertEquals("blue",highlightHandle.getColor().getValue());
	    assertEquals("bold",highlightHandle.getFontWeight());
	    
	    
	}
	
	
	
}
