package org.eclipse.birt.report.tests.model.acceptance;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.DesignChoiceConstants;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.elements.interfaces.IReportItemModel;
import org.eclipse.birt.report.tests.model.BaseTestCase;

import sun.security.krb5.internal.crypto.c;

public class GridElementHandleTest extends BaseTestCase
{
	String fileName = "BlankReport.xml";
	
	private String outFileName = "GridElementHandleDpt.xml"; 
	private String goldenFileName = "GridElementHandleDpt_golden.xml";
	
	public GridElementHandleTest(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(GridElementHandleTest.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	public void testGridElement( ) throws Exception
	{
		openDesign( fileName );
		
//		Nes a error grid
		try
		{
			GridHandle gridError1Handle = (GridHandle)designHandle.getElementFactory().newGridItem("errorGrid" , -1 , -1 );
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		
		
//		New a 3*3 grid without name.
		GridHandle gridHandle = (GridHandle)designHandle.getElementFactory().newGridItem( "grid" , 3, 3 );
		designHandle.getBody().add( gridHandle );
		assertEquals( 3 , gridHandle.getColumnCount() );
		assertEquals( 3 , gridHandle.getRows().getCount() );
//		Rename the grid
		gridHandle.setName("grid2");
		assertEquals("grid2" , gridHandle.getName());
		designHandle.getCommandStack().undo();
		assertEquals("grid" , gridHandle.getName());
		designHandle.getCommandStack().redo();
		assertEquals("grid2" , gridHandle.getName());
		
//		Insert a row
		RowHandle rowHandle = designHandle.getElementFactory().newTableRow();
		gridHandle.addElement( rowHandle , GridItem.ROW_SLOT );
		SlotHandle slotHandle1 = gridHandle.getRows();
		assertEquals( 4 , slotHandle1.getCount() );

		
//		Insert a column
		ColumnHandle columnHandle = designHandle.getElementFactory().newTableColumn();
		gridHandle.addElement( columnHandle , TableRow.CONTENT_SLOT );
		SlotHandle slotHandle2 = gridHandle.getColumns();
		assertEquals( 4 , slotHandle2.getCount() );

		
//		Insert a text
		CellHandle cell11 = gridHandle.getCell( 1 , 1 );
		TextItemHandle text = (TextItemHandle)designHandle.getElementFactory().newTextItem( "text" );
		cell11.addElement( text , TextItemHandle.USER_LABEL );
		
//		Copy the text
		TextItem newtext = (TextItem)text.copy();
		newtext.setName("text2");
		cell11.getContent().add(newtext);
		assertEquals( 2 , cell11.getContent().getCount() );
		
		
		
//		Insert a label
		CellHandle cell12 = gridHandle.getCell( 1 , 2 );
		LabelHandle label = (LabelHandle)designHandle.getElementFactory().newLabel( "label" );
		cell11.addElement( label , TextItemHandle.USER_LABEL );

		
//		Cut the label
		Label newlabel = (Label)label.copy();
		newlabel.setName("label2");
		cell12.getContent().add(newlabel);
		label.drop();
		assertEquals( 1,  cell12.getContent().getCount());
		
//		Insert a data
		CellHandle cell13 = gridHandle.getCell( 1 , 3 );
		DataItemHandle data = (DataItemHandle)designHandle.getElementFactory().newDataItem( "data" );
		cell11.addElement( data , DataItemHandle.USER_LABEL );
		
//		Delete one column
		SlotHandle column = gridHandle.getColumns();
		ColumnHandle gridColumn = (ColumnHandle) column.get( 3 );
		gridColumn.drop();
		assertEquals( 3 , gridHandle.getColumns().getCount() );
		
//		Delete one row
		SlotHandle rowDelete = gridHandle.getRows();
		RowHandle gridDeleteRow = (RowHandle)rowDelete.get( 3 );
		gridDeleteRow.drop();
		assertEquals( 3 , gridHandle.getRows().getCount() );
		designHandle.getCommandStack().undo();
		
//		Delete one cell
		SlotHandle cellDelete = gridHandle.getRows();
		RowHandle cellDeleteRow = (RowHandle)cellDelete.get( 1 );
		CellHandle cellDeleteCell = (CellHandle)cellDeleteRow.getCells().get( 1 );
		cellDeleteCell.drop();
		assertNotNull("Cell Alive" , cellDeleteCell);
		
//		Copy and Cut Column
		column = gridHandle.getColumns();
		ColumnHandle columncopy = (ColumnHandle) column.get( 2 );
		columncopy.copy();
		gridHandle.getColumns().add(columncopy);
		assertEquals( 4 , gridHandle.getColumns().getCount() );
		designHandle.getCommandStack().undo();
		assertEquals( 3 , gridHandle.getColumns().getCount() );
		designHandle.getCommandStack().redo();
		assertEquals( 4 , gridHandle.getColumns().getCount() );
		columncopy.drop();
		assertEquals( 3 , gridHandle.getColumnCount() );
		
//		Copy and Cut Row
		SlotHandle row = gridHandle.getRows();
		RowHandle rowcopy = (RowHandle) row.get( 2 );
		rowcopy.copy();
		gridHandle.getRows().add(rowcopy);
		assertEquals( 5 , gridHandle.getRows().getCount() );
		rowcopy.drop();
		assertEquals( 4 , gridHandle.getRows().getCount() );
		
		
		gridHandle.setWidth( "200%" );
//		Set magin bottom
		gridHandle.setProperty( StyleHandle.MARGIN_BOTTOM_PROP, "5pt" );
		assertEquals( "5pt" , gridHandle.getStringProperty( "marginBottom" ) );
		
//		Set magin top
		gridHandle.setProperty( StyleHandle.MARGIN_TOP_PROP, "5pt" );
		assertEquals( "5pt" , gridHandle.getStringProperty( "marginTop" ) );
		
//		Set magin right
		gridHandle.setProperty( StyleHandle.MARGIN_RIGHT_PROP, "5pt" );
		assertEquals( "5pt" , gridHandle.getStringProperty( "marginRight" ) );
		
//		Set magin left
		gridHandle.setProperty( StyleHandle.MARGIN_LEFT_PROP, "5pt" );
		assertEquals( "5pt" , gridHandle.getStringProperty( "marginLeft" ) );
		
		try
		{
			gridHandle.setProperty( StyleHandle.MARGIN_BOTTOM_PROP, "-1" );
		}
		catch (Exception e)
		{
			assertNotNull(e);
		}
		
		
		try
		{
			gridHandle.setProperty( StyleHandle.MARGIN_BOTTOM_PROP, "a" );
		}
		catch (Exception e)
		{
			assertNotNull(e);
		}
		
	}
	
	
	public void testGridAction( ) throws Exception
	{
		openDesign(fileName);
		
		GridHandle gridHandle = (GridHandle)designHandle.getElementFactory().newGridItem("grid2" , 4 , 4 );
		designHandle.getBody().add( gridHandle );
		assertEquals( 4 , gridHandle.getRows().getCount() );
		
//		Rename the grid
		gridHandle.setName("grid3");
		assertEquals( "grid3" , gridHandle.getName() );
		designHandle.getCommandStack().undo();
		
//		Delete a row
		RowHandle row = (RowHandle)gridHandle.getRows().get( 1 );
		row.drop();
		assertEquals( 3 , gridHandle.getRows().getCount() );
		designHandle.getCommandStack().undo();
		assertEquals( 4 , gridHandle.getRows().getCount() );
		
//		Delete a column
		ColumnHandle column1 = (ColumnHandle)gridHandle.getColumns().get( 1 );
		column1.drop();
		assertEquals( 3, gridHandle.getColumns().getCount() );
		designHandle.getCommandStack().undo();
		assertEquals( 4 , gridHandle.getColumns().getCount() );
		designHandle.getCommandStack().redo();
		assertEquals( 3, gridHandle.getColumns().getCount() );
		
//		Merge two cell
		RowHandle row1 = (RowHandle)gridHandle.getRows().get( 1 );
		RowHandle row2 = (RowHandle)gridHandle.getRows().get( 2 );
		CellHandle cell1 = (CellHandle)row1.getCells().get( 1 );
		CellHandle cell2 = (CellHandle)row1.getCells().get( 2 );
		CellHandle cell3 = (CellHandle)row2.getCells().get( 1 );
		
		cell2.drop();
		cell1.setColumnSpan( 2 );
		assertEquals( 3 , gridHandle.getColumnCount() );
		assertEquals( 2 , cell1.getColumnSpan() );
		designHandle.getCommandStack().undo();
		assertEquals( 3 , gridHandle.getColumns().getCount() );
		assertEquals( 1 , cell1.getColumnSpan() );
		
		cell3.drop();
		cell1.setRowSpan( 2 );
		assertEquals( 4 , gridHandle.getRows().getCount() );
		assertEquals( 2 , cell1.getRowSpan() );
		
//		Split cell
		cell1.setRowSpan( 1 );
		LabelHandle labelAdd = (LabelHandle)designHandle.getElementFactory().newLabel("labelAdd");
		cell3.addElement( labelAdd , LabelHandle.USER_LABEL );
		assertEquals( 1 , cell1.getRowSpan() );
		
	}
	
	public void testGridHighLight( ) throws Exception
	{
		openDesign(fileName);
		
		GridHandle gridHandle = (GridHandle)designHandle.getElementFactory().newGridItem("grid2" , 4 , 4 );
		designHandle.getBody().add( gridHandle );
		assertEquals( 4 , gridHandle.getRows().getCount() );
		
		LabelHandle label = (LabelHandle)designHandle.getElementFactory().newLabel("label");
		label.setText("label");
		RowHandle row1 = (RowHandle)gridHandle.getRows().get( 0 );
		CellHandle cell1 = (CellHandle)row1.getCells().get( 0 );
		cell1.addElement( label , CellHandle.USER_LABEL );
		
//		set highlight key for grid
		HighlightRule highLight = new HighlightRule();
		highLight.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		highLight.setTestExpression("row[\"account_id\"]");
		highLight.setValue1( "5" );
		highLight.setProperty( HighlightRule.FONT_SIZE_MEMBER , "10" );
		highLight.setProperty( HighlightRule.BACKGROUND_COLOR_MEMBER , "red");
		highLight.setProperty( HighlightRule.FONT_FAMILY_MEMBER , "Serif");
		highLight.setProperty( HighlightRule.COLOR_MEMBER , "yellow");
		highLight.setProperty( HighlightRule.FONT_WEIGHT_MEMBER , "bold");
		highLight.setProperty( HighlightRule.FONT_STYLE_MEMBER , "italic");
		highLight.setProperty( HighlightRule.TEXT_LINE_THROUGH_MEMBER , "line-through");
		highLight.setProperty( HighlightRule.TEXT_UNDERLINE_MEMBER , "underline");
		PropertyHandle highHandle = gridHandle.getPropertyHandle( StyleHandle.HIGHLIGHT_RULES_PROP );
		highHandle.addItem(highLight);
		
//		set highlight key for grid row
		highLight.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		highLight.setTestExpression("row[\"account_id\"]");
		highLight.setValue1( "5" );
		highLight.setProperty( HighlightRule.FONT_SIZE_MEMBER , "10" );
		highLight.setProperty( HighlightRule.BACKGROUND_COLOR_MEMBER , "red");
		highLight.setProperty( HighlightRule.FONT_FAMILY_MEMBER , "Serif");
		highLight.setProperty( HighlightRule.COLOR_MEMBER , "yellow");
		highLight.setProperty( HighlightRule.FONT_WEIGHT_MEMBER , "bold");
		highLight.setProperty( HighlightRule.FONT_STYLE_MEMBER , "italic");
		highLight.setProperty( HighlightRule.TEXT_LINE_THROUGH_MEMBER , "line-through");
		highLight.setProperty( HighlightRule.TEXT_UNDERLINE_MEMBER , "underline");
		PropertyHandle highRowHandle = gridHandle.getRows().get( 0 ).getPropertyHandle( StyleHandle.HIGHLIGHT_RULES_PROP );
		highHandle.addItem(highLight);
		
		
//		set highlight key for grid column
		highLight.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		highLight.setTestExpression("row[\"account_id\"]");
		highLight.setValue1( "5" );
		highLight.setProperty( HighlightRule.FONT_SIZE_MEMBER , "10" );
		highLight.setProperty( HighlightRule.BACKGROUND_COLOR_MEMBER , "red");
		highLight.setProperty( HighlightRule.FONT_FAMILY_MEMBER , "Serif");
		highLight.setProperty( HighlightRule.COLOR_MEMBER , "yellow");
		highLight.setProperty( HighlightRule.FONT_WEIGHT_MEMBER , "bold");
		highLight.setProperty( HighlightRule.FONT_STYLE_MEMBER , "italic");
		highLight.setProperty( HighlightRule.TEXT_LINE_THROUGH_MEMBER , "line-through");
		highLight.setProperty( HighlightRule.TEXT_UNDERLINE_MEMBER , "underline");
		PropertyHandle highColumnHandle = gridHandle.getColumns().get( 0 ).getPropertyHandle( StyleHandle.HIGHLIGHT_RULES_PROP );
		highHandle.addItem(highLight);
		
//		set highlight key for grid cell
		highLight.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		highLight.setTestExpression("row[\"account_id\"]");
		highLight.setValue1( "5" );
		highLight.setProperty( HighlightRule.FONT_SIZE_MEMBER , "10" );
		highLight.setProperty( HighlightRule.BACKGROUND_COLOR_MEMBER , "red");
		highLight.setProperty( HighlightRule.FONT_FAMILY_MEMBER , "Serif");
		highLight.setProperty( HighlightRule.COLOR_MEMBER , "yellow");
		highLight.setProperty( HighlightRule.FONT_WEIGHT_MEMBER , "bold");
		highLight.setProperty( HighlightRule.FONT_STYLE_MEMBER , "italic");
		highLight.setProperty( HighlightRule.TEXT_LINE_THROUGH_MEMBER , "line-through");
		highLight.setProperty( HighlightRule.TEXT_UNDERLINE_MEMBER , "underline");
		RowHandle rowHigh = (RowHandle)gridHandle.getRows().get( 0 );
		CellHandle cellHigh = (CellHandle)rowHigh.getCells().get( 0 );
		PropertyHandle highCellHandle = cellHigh.getPropertyHandle( StyleHandle.HIGHLIGHT_RULES_PROP );
		highHandle.addItem(highLight);

//		set map for table
		MapRule map =  new MapRule();
		map.setTestExpression("row[\"account_id\"]");
		map.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		map.setValue1( "5" );
		map.setDisplay( "NO" );
		PropertyHandle mapHandle = gridHandle.getPropertyHandle( StyleHandle.MAP_RULES_PROP );
		mapHandle.addItem(map);
	}
	
	public void testGridCopyCut( ) throws Exception
	{
		openDesign(fileName);
		
		GridHandle gridHandle = (GridHandle)designHandle.getElementFactory().newGridItem("grid2" , 4 , 4 );
		designHandle.getBody().add( gridHandle );
		assertEquals( 4 , gridHandle.getRows().getCount() );
		
//		Copy and cutColumn
		ColumnBandData column1 = gridHandle.copyColumn( 1 );
		gridHandle.insertAndPasteColumn( column1 , 1 );
		assertEquals( 5 , gridHandle.getColumnCount() );
		gridHandle.getColumns().get(0).drop();
		assertEquals( 4 , gridHandle.getColumnCount() );
		
//		Coopy and cut Row
		DesignElementHandle row1 = gridHandle.getRows().get(0);
		row1.copy();
		gridHandle.getRows().add(row1);
		assertEquals( 5 , gridHandle.getRows().getCount() );
		
//		Copy grid
		GridItem newGrid = (GridItem)gridHandle.copy();
		assertNotNull(newGrid);
		assertNotNull(gridHandle);
	    assertEquals(gridHandle.getName(),newGrid.getName());
	    design = (ReportDesign)designHandle.getModule();
	    
	    try{
	    	designHandle.getBody().add(newGrid.getHandle(design));
	    }
	    catch (NameException e)
	    {
	      assertNotNull(e);
	    }
	    newGrid.setName("newGrid");
	    designHandle.getBody().add(newGrid.getHandle(design));
	    assertEquals("newGrid",newGrid.getName());
	    assertEquals(2,designHandle.getBody().getCount());
//	    Cut and delete grid
	    designHandle.getBody().drop(gridHandle);
	    assertEquals(1,designHandle.getBody().getCount());
	}
	
	public void testGridProperty( ) throws Exception
	{
		openDesign(fileName);
		
		GridHandle gridHandle = (GridHandle)designHandle.getElementFactory().newGridItem("grid2" , 4 , 4 );
		designHandle.getBody().add( gridHandle );
		
//		set width
		gridHandle.setWidth("0%");
		assertEquals("0%" , gridHandle.getStringProperty(IReportItemModel.WIDTH_PROP));
		gridHandle.setWidth("100%");
		assertEquals("100%" , gridHandle.getStringProperty(IReportItemModel.WIDTH_PROP));
		designHandle.getCommandStack().undo();
		assertEquals("0%" , gridHandle.getStringProperty(IReportItemModel.WIDTH_PROP));
		designHandle.getCommandStack().redo();
		assertEquals("100%" , gridHandle.getStringProperty(IReportItemModel.WIDTH_PROP));
		
//		Rename
		gridHandle.setName("%lt");
		assertEquals("%lt" , gridHandle.getName());
		
		try
		{
		gridHandle.setStringProperty(StyleHandle.MARGIN_BOTTOM_PROP, "-1");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
		gridHandle.setStringProperty(StyleHandle.MARGIN_BOTTOM_PROP, "a");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
	}
	
	
}
