package org.eclipse.birt.report.tests.model.acceptance;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.DesignChoiceConstants;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ListElementHandleTest extends BaseTestCase
{
	private static final String SORT_DIRCTION_ASC = null;
	String fileName = "BlankReport.xml";
	public ListElementHandleTest(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(ListElementHandleTest.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	public void testList( ) throws Exception
	{
		openDesign( fileName );
		
		ListHandle listHandle = (ListHandle)designHandle.getElementFactory().newList( "list" );
		designHandle.getBody().add( listHandle );
		assertEquals( 0 , listHandle.getGroups().getCount() );
		
//		Get header cell
		SlotHandle columnHeader = listHandle.getHeader();
		
//		Get detail cell
		SlotHandle columnDetail = listHandle.getDetail();
		
//		Get footer cell
		SlotHandle columnFooter = listHandle.getHeader();
		
//		Insert List Group
		ListGroupHandle group = designHandle.getElementFactory().newListGroup();
		listHandle.getGroups().add( group );
		assertEquals( 0 , listHandle.getHeader().getCount() );
		assertNotNull( "Group has not insert" , group );
		
		
//		Insert item in group
		SlotHandle groupHeader = group.getHeader();
		LabelHandle groupLabel = (LabelHandle)designHandle.getElementFactory().newLabel("label");
		groupHeader.add(groupLabel , LabelHandle.USER_LABEL);
		assertTrue( groupHeader.getContents().get( 0 ) instanceof LabelHandle);
		
		
//		Insert and delete a label
		LabelHandle label = (LabelHandle)designHandle.getElementFactory().newLabel("label1");
		columnHeader.add( label , LabelHandle.USER_LABEL );
		assertTrue( columnHeader.getContents().get( 0 ) instanceof LabelHandle );
		label.drop();

//		Insert a data
		DataItemHandle data = (DataItemHandle)designHandle.getElementFactory().newDataItem("data1");
		columnHeader.add( data , DataItemHandle.USER_LABEL );
		assertTrue( columnHeader.getContents().get( 0 ) instanceof DataItemHandle );
		
//		Insert a text
		TextItemHandle text = (TextItemHandle)designHandle.getElementFactory().newTextItem("text1");
		columnFooter.add( text , TextItemHandle.USER_LABEL );
		assertTrue( columnFooter.getContents().get( 0 ) instanceof TextItemHandle );
		designHandle.getCommandStack().undo();
		
//		Insert a image
		ImageHandle image = (ImageHandle)designHandle.getElementFactory().newImage( "image1" );
		columnFooter.add( image , ImageHandle.USER_LABEL );
		assertTrue( columnFooter.getContents().get( 0 ) instanceof ImageHandle );
		image.drop();
		
//		Insert a list
		ListHandle listInsert = (ListHandle)designHandle.getElementFactory().newList("listInsert");
		columnFooter.add( listInsert , ListHandle.USER_LABEL );
		assertTrue( columnFooter.getContents().get( 0 ) instanceof ListHandle);
		designHandle.getCommandStack().undo();
		
		
//		Binding the list with a data set
		ListHandle list = (ListHandle)designHandle.findElement("list");
		assertNotNull(list);
		DataSetHandle ds = designHandle.findDataSet("sqlserverDS");
		assertNotNull(ds);
		list.setDataSet(ds);
		assertEquals("sqlserverDS",list.getDataSet().getName());
		
		
//		set sort key for list
		SortKey sortkey = StructureFactory.createSortKey( );
		sortkey.setKey( "row[\"account_id\"]" );
		sortkey.setDirection(DesignChoiceConstants.SORT_DIRECTION_DESC);
		PropertyHandle propHandle = list.getPropertyHandle( ListingElement.SORT_PROP );
		propHandle.addItem( sortkey );
		assertEquals("row[\"account_id\"]",sortkey.getKey());
		assertEquals(DesignChoiceConstants.SORT_DIRECTION_DESC,sortkey.getDirection());
		
//		set filter key for list
		propHandle = list.getPropertyHandle( ListingElement.FILTER_PROP );
		FilterCondition filter = StructureFactory.createFilterCond( );
		filter.setExpr( "row[\"account_id\"]" ); //$NON-NLS-1$
		filter.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		filter.setValue1( "5" );
		propHandle.addItem( filter );
		assertEquals("row[\"account_id\"]",filter.getExpr());
		assertEquals( DesignChoiceConstants.MAP_OPERATOR_GT, filter.getOperator( ) );
		assertEquals("5",filter.getValue1());
		
//		set highlight key for list
		HighlightRule highLight = new HighlightRule();
		highLight.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		highLight.setTestExpression("row[\"account_id\"]");
		highLight.setValue1( "5" );
		highLight.setProperty( HighlightRule.FONT_SIZE_MEMBER , "10" );
		highLight.setProperty( HighlightRule.BACKGROUND_COLOR_MEMBER , "red");
		highLight.setProperty( HighlightRule.FONT_FAMILY_MEMBER , "Serif");
		highLight.setProperty( HighlightRule.COLOR_MEMBER , "yellow");
		highLight.setProperty( HighlightRule.FONT_WEIGHT_MEMBER , "bold");
		highLight.setProperty( HighlightRule.FONT_STYLE_MEMBER , "italic");
		highLight.setProperty( HighlightRule.TEXT_LINE_THROUGH_MEMBER , "line-through");
		highLight.setProperty( HighlightRule.TEXT_UNDERLINE_MEMBER , "underline");
		PropertyHandle highHandle = list.getPropertyHandle( StyleHandle.HIGHLIGHT_RULES_PROP );
		highHandle.addItem(highLight);
		
//		set group for list
		ListGroupHandle listGroup = (ListGroupHandle)designHandle.getElementFactory().newListGroup();
		list.getGroups().add( listGroup );
		assertNotNull( "Group has not insert" , group );
		listGroup.setGroupStart("row[\"account_id\"]");
		listGroup.setTocExpression("new Date()");
		listGroup.setName( "listGroup " );
		listGroup.setInterval( "Interval" );
		listGroup.setIntervalRange(1);
		listGroup.setSortDirection(DesignChoiceConstants.SORT_DIRECTION_ASC);
		assertEquals( "listGroup" , listGroup.getName() );
		assertEquals( "interval" , listGroup.getInterval() );
		assertEquals( "asc" , listGroup.getSortDirection());
		
//		set map for list
		MapRule map =  new MapRule();
		map.setTestExpression("row[\"account_id\"]");
		map.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		map.setValue1( "5" );
		map.setDisplay( "NO" );
		PropertyHandle mapHandle = list.getPropertyHandle( StyleHandle.MAP_RULES_PROP );
		mapHandle.addItem(map);

	}
	
	
	public void testListAction( ) throws Exception
	{
		openDesign( fileName );
	
	
		ListHandle listHandle = (ListHandle)designHandle.getElementFactory().newList( "list" );
		designHandle.getBody().add( listHandle );
		assertEquals( 0 , listHandle.getGroups().getCount() );
		
		
//		Delete list
		designHandle.getBody().drop(listHandle);
		assertEquals(0,designHandle.getBody().getCount());
		designHandle.getCommandStack().undo();
		
//		Copy, Cut and paste list
	    ListItem newlist = (ListItem)listHandle.copy();
	    assertNotNull(newlist);
	    assertEquals(listHandle.getName(),newlist.getName());
	    design = (ReportDesign)designHandle.getModule();
	    
	    try{
	    	designHandle.getBody().add(newlist.getHandle(design));
		    fail();
	    }
	    catch (NameException e)
	    {
	      assertNotNull(e);
	    }
	    newlist.setName("newlist");
	    designHandle.getBody().add(newlist.getHandle(design));
	    assertEquals("newlist",newlist.getName());
	}
	
	public void testListProperty( ) throws Exception
	{
		openDesign(fileName);
		ListHandle listHandle = (ListHandle)designHandle.getElementFactory().newList( "list" );
		designHandle.getBody().add( listHandle );
		
		LabelHandle labelHandle = (LabelHandle)designHandle.getElementFactory().newLabel("label");
		SlotHandle listHeader1 = listHandle.getHeader();
		listHeader1.add(labelHandle);
		
//		set property
		listHandle.setStringProperty(StyleHandle.BACKGROUND_COLOR_PROP, "yellow");
		listHandle.setStringProperty(StyleHandle.FONT_FAMILY_PROP, "arial");
		listHandle.setStringProperty(StyleHandle.COLOR_PROP, "red");
		listHandle.setStringProperty(StyleHandle.BORDER_LEFT_STYLE_PROP, "dashed");
		listHandle.setStringProperty(StyleHandle.BORDER_RIGHT_STYLE_PROP, "dashed");
		
		assertEquals("yellow" , listHandle.getStringProperty(StyleHandle.BACKGROUND_COLOR_PROP));
		assertEquals("arial" , labelHandle.getStringProperty(StyleHandle.FONT_FAMILY_PROP));
		assertEquals("red" , labelHandle.getStringProperty(StyleHandle.COLOR_PROP));
		assertEquals("dashed" , listHandle.getStringProperty(StyleHandle.BORDER_LEFT_STYLE_PROP));
		assertEquals("dashed" , listHandle.getStringProperty(StyleHandle.BORDER_RIGHT_STYLE_PROP));
		
//		set other property
		try
		{
			listHandle.setStringProperty(StyleHandle.BACKGROUND_COLOR_PROP, "%$^%");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			listHandle.setStringProperty(StyleHandle.FONT_FAMILY_PROP, "-59");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			listHandle.setStringProperty(StyleHandle.FONT_SIZE_PROP, "\"^%");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
	}
}
