
package org.eclipse.birt.report.tests.model.acceptance;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.model.BaseTestCase;

import com.ibm.icu.util.ULocale;

public class MasterPageHandleTest extends BaseTestCase
{

	String fileName = "BlankReport.xml";
	private String outFileName = ".xml";
	private String goldenFileName = ".xml";

	public MasterPageHandleTest( String name )
	{
		super( name );
	}

	public static Test suite( )
	{

		return new TestSuite( MasterPageHandleTest.class );
	}

	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}

	public void testAddText( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		TextItemHandle text = factory.newTextItem( "text" );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( text );
		assertNotNull( masterpage.getPageHeader( ) );

		SlotHandle pagefooter = masterpage.getPageFooter( );
		pagefooter.add( text );
		assertNotNull( masterpage.getPageFooter( ) );
	}

	public void testAddLabel( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		LabelHandle label = factory.newLabel( "label" );
		label.setText( "Actuate" );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( label );
		assertNotNull( masterpage.getPageHeader( ) );

		SlotHandle pagefooter = masterpage.getPageFooter( );
		pagefooter.add( label );
		assertNotNull( masterpage.getPageFooter( ) );
	}

	public void testAddImage( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		ImageHandle image = factory.newImage( "image" );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( image );
		assertNotNull( masterpage.getPageHeader( ) );

		SlotHandle pagefooter = masterpage.getPageFooter( );
		pagefooter.add( image );
		assertNotNull( masterpage.getPageFooter( ) );
	}

	public void testAddData( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		DataItemHandle data = factory.newDataItem( "image" );
		data.setValueExpr( "new Date()" );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( data );
		assertNotNull( masterpage.getPageHeader( ) );

		SlotHandle pagefooter = masterpage.getPageFooter( );
		pagefooter.add( data );
		assertNotNull( masterpage.getPageFooter( ) );
	}

	public void testAddPage( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		TextItemHandle page = factory.newTextItem( "page" );
		page.setContent( "Page: <value-of>GlobalBirt.CurrentPage</value-of>" );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( page );
		assertNotNull( masterpage.getPageHeader( ) );

		SlotHandle pagefooter = masterpage.getPageFooter( );
		pagefooter.add( page );
		assertNotNull( masterpage.getPageFooter( ) );
	}

	public void testAddTextData( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		TextItemHandle textdata = factory.newTextItem( "text-data" );
		textdata.setContent( "<value-of>new Date()</value-of>" );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( textdata );
		assertNotNull( masterpage.getPageHeader( ) );

		SlotHandle pagefooter = masterpage.getPageFooter( );
		pagefooter.add( textdata );
		assertNotNull( masterpage.getPageFooter( ) );
	}

	public void testAddCreateOn( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		TextItemHandle createon = factory.newTextItem( "createon" );
		createon.setContent( "Created on: <value-of>new Date()</value-of>" );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( createon );
		assertNotNull( masterpage.getPageHeader( ) );

		SlotHandle pagefooter = masterpage.getPageFooter( );
		pagefooter.add( createon );
		assertNotNull( masterpage.getPageFooter( ) );
	}

	public void testAddCreateBy( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		TextItemHandle createby = factory.newTextItem( "createby" );
		createby
				.setContent( "Created by: Birt Eclipse Report Designer Version 1.0.1" );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( createby );
		assertNotNull( masterpage.getPageHeader( ) );

		SlotHandle pagefooter = masterpage.getPageFooter( );
		pagefooter.add( createby );
		assertNotNull( masterpage.getPageFooter( ) );
	}

	public void testAddLastPrint( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		TextItemHandle lastprint = factory.newTextItem( "lastprint" );
		lastprint.setContent( "Last printed: <value-of>new Date()</value-of>" );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( lastprint );
		assertNotNull( masterpage.getPageHeader( ) );

		SlotHandle pagefooter = masterpage.getPageFooter( );
		pagefooter.add( lastprint );
		assertNotNull( masterpage.getPageFooter( ) );
	}

	public void testAddConfidential( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		GridHandle grid = factory.newGridItem( "grid", 1, 2 );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( grid );
		assertNotNull( masterpage.getPageHeader( ) );

		CellHandle cell1 = grid.getCell( 1, 1 );
		TextItemHandle text1 = factory.newTextItem( "text1" );
		text1.setContent( "Confidential" );
		cell1.addElement( text1, TextItemHandle.USER_LABEL );

		CellHandle cell2 = grid.getCell( 1, 2 );
		TextItemHandle text2 = factory.newTextItem( "text2" );
		text2.setContent( "Page: <value-of>GlobalBirt.CurrentPage</value-of>" );

	}

	public void testAddCAuthor( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );

		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );
		GridHandle grid = factory.newGridItem( "grid", 3, 1 );

		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( grid );
		assertNotNull( masterpage.getPageHeader( ) );

		CellHandle cell1 = grid.getCell( 0, 0 );
		TextItemHandle text1 = factory.newTextItem( "text1" );
		text1.setContent( "Created by: " );
		cell1.addElement( text1, TextItemHandle.USER_LABEL );

		CellHandle cell2 = grid.getCell( 0, 1 );
		TextItemHandle text2 = factory.newTextItem( "text2" );
		text2.setContent( "Page: <value-of>pageNumber</value-of>" );
		cell2.addElement( text2, TextItemHandle.USER_LABEL );

		CellHandle cell3 = grid.getCell( 0, 2 );
		TextItemHandle text3 = factory.newTextItem( "text3" );
		text3.setContent( "<value-of>new Date()</value-of>" );
		cell3.addElement( text3, TextItemHandle.USER_LABEL );

	}

	public void testAction( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );
		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );

		// Rename the masterpage
		masterpage.setName( "MasterPage" );
		assertEquals( "MasterPage", masterpage.getName( ) );
		designHandle.getCommandStack( ).undo( );
		assertEquals( "MyPage", masterpage.getName( ) );

		// Add a label
		LabelHandle label = factory.newLabel( "label" );
		label.setText( "Actuate" );
		SlotHandle pageheader = masterpage.getPageHeader( );
		pageheader.add( label );
		assertNotNull( masterpage.getPageHeader( ) );

		// Shift item
		SlotHandle pageHeader = masterpage.getPageHeader( );
		SlotHandle pageFooter = masterpage.getPageFooter( );
		label.copy( );
		pageFooter.add( label );
		assertNotNull( masterpage.getPageFooter( ).getContents( ) );
		pageHeader.drop( label );

		// Copy item
		label.copy( );
		pageHeader.add( label );
		assertNotNull( masterpage.getPageFooter( ).getContents( ) );

	}

	public void testMasterPageProperty( ) throws Exception
	{
		openDesign( fileName );

		sessionHandle = DesignEngine.newSession( ULocale.ENGLISH );
		designHandle = sessionHandle.createDesign( );
		design = (ReportDesign) designHandle.getModule( );
		ElementFactory factory = new ElementFactory( design );
		SimpleMasterPageHandle masterpage = factory
				.newSimpleMasterPage( "MyPage" );

		// Set Name and Rename
		masterpage.setName( "abc" );
		assertEquals( "abc", masterpage.getName( ) );
		masterpage.setName( "a''bb" );
		assertEquals( "a''bb", masterpage.getName( ) );
		masterpage.setName( "cc&&||" );
		assertEquals( "cc&&||", masterpage.getName( ) );
		masterpage.setName( "aaaaaaaaaabbbbbbbbbbbbbbbbbbbbaaaaaaaaaa" );
		assertEquals( "aaaaaaaaaabbbbbbbbbbbbbbbbbbbbaaaaaaaaaa", masterpage
				.getName( ) );

		// Undo and Redo
		designHandle.getCommandStack( ).undo( );
		assertEquals( "cc&&||", masterpage.getName( ) );
		designHandle.getCommandStack( ).undo( );
		assertEquals( "a''bb", masterpage.getName( ) );
		designHandle.getCommandStack( ).redo( );
		assertEquals( "cc&&||", masterpage.getName( ) );
		designHandle.getCommandStack( ).redo( );
		assertEquals( "aaaaaaaaaabbbbbbbbbbbbbbbbbbbbaaaaaaaaaa", masterpage
				.getName( ) );

		masterpage.setStringProperty( StyleHandle.BACKGROUND_COLOR_PROP,
				"yellow" );
		assertEquals( "yellow", masterpage
				.getStringProperty( "backgroundColor" ) );
		masterpage.setStringProperty( StyleHandle.ORPHANS_PROP, "1" );
		assertEquals( "1", masterpage.getStringProperty( "orphans" ) );

	}

}
