package org.eclipse.birt.report.tests.model.acceptance;

import java.util.Iterator;
import java.util.Locale;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.DesignChoiceConstants;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.interfaces.IStyleModel;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class StyleBuilderTest extends BaseTestCase
{
String fileName = "BlankReport.xml";
	
	private String outFileName = "StyleBuilderDpt.xml"; 
	private String goldenFileName = "StyleBuilderDpt_golden.xml";
	
	public StyleBuilderTest(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(StyleBuilderTest.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	public void testStyleBuilder( ) throws Exception
	{
		openDesign( fileName );
		
		LabelHandle label = (LabelHandle)designHandle.getElementFactory().newLabel("label");
		
		StyleHandle styleHandle = (StyleHandle)designHandle.getElementFactory().newStyle("Style1");
		designHandle.getStyles().add( styleHandle );
		
//		Rename the style
		styleHandle.setName("style2");
		
//		Set Pre-define style
		
		
//		Set font properties
		styleHandle.setTextLineThrough( DesignChoiceConstants.TEXT_LINE_THROUGH_LINE_THROUGH);
		assertEquals( "line-through" , styleHandle.getStringProperty( "textLineThrough" ) );
		
		styleHandle.setStringProperty( StyleHandle.TEXT_UNDERLINE_PROP , "underline" );
		assertEquals( "underline" , styleHandle.getStringProperty( "textUnderline" ) );
		
		styleHandle.setTextOverline( DesignChoiceConstants.TEXT_OVERLINE_OVERLINE );
		assertEquals( "overline" , styleHandle.getStringProperty( "textOverline" ) );
		
		styleHandle.setProperty( StyleHandle.FONT_FAMILY_PROP , "Sans Serif" );
	    assertEquals( "sans-serif" , styleHandle.getStringProperty( "fontFamily" ));
	    
	    styleHandle.setProperty( StyleHandle.FONT_SIZE_PROP, "10pt" );
		assertEquals( "10pt" , styleHandle.getStringProperty( "fontSize" ) );
		
		styleHandle.setProperty( StyleHandle.FONT_WEIGHT_PROP, "bold" );
		assertEquals( "bold" , styleHandle.getStringProperty("fontWeight") );

		styleHandle.setProperty( StyleHandle.FONT_STYLE_PROP, "italic");
    	assertEquals( "italic" , styleHandle.getStringProperty("fontStyle") );
		
		//Set color
		ColorHandle colorHandle = styleHandle.getColor( );
		colorHandle.setRGB( 0xFF0088 );
		
//		Set background color properties
		colorHandle = styleHandle.getBackgroundColor( );
		colorHandle.setStringValue( "blue" );
		styleHandle.setProperty( StyleHandle.BACKGROUND_REPEAT_PROP , "Repeat");
		assertEquals( "repeat" , styleHandle.getStringProperty("backgroundRepeat") );
		
		styleHandle.setProperty( StyleHandle.BACKGROUND_ATTACHMENT_PROP , "Scroll");
		assertEquals( "scroll" , styleHandle.getStringProperty("backgroundAttachment") );
		
		styleHandle.setProperty( StyleHandle.BACKGROUND_IMAGE_PROP , "http://www.google.com/intl/zh-CN_ALL/images/logo.gif");
		assertEquals( "http://www.google.com/intl/zh-CN_ALL/images/logo.gif" , styleHandle.getStringProperty("backgroundImage") );
		
		styleHandle.setProperty( StyleHandle.BACKGROUND_POSITION_X_PROP , "50%");
		assertEquals( "50%" , styleHandle.getStringProperty("backgroundPositionX") );
		
		styleHandle.setProperty( StyleHandle.BACKGROUND_POSITION_Y_PROP , "50%");
		assertEquals( "50%" , styleHandle.getStringProperty("backgroundPositionY") );
		
//		Set Text Block
		styleHandle.setProperty( StyleHandle.LINE_HEIGHT_PROP , "1in");
		assertEquals( "1in" , styleHandle.getStringProperty( "lineHeight" ) );
		
		styleHandle.setProperty( StyleHandle.LETTER_SPACING_PROP , "1");
		assertEquals( "1pt" , styleHandle.getStringProperty( "letterSpacing" ) );
		
		styleHandle.setProperty( StyleHandle.WORD_SPACING_PROP , "1");
		assertEquals( "1pt" , styleHandle.getStringProperty( "wordSpacing" ) );
		
	    styleHandle.setProperty( StyleHandle.VERTICAL_ALIGN_PROP , "Baseline");
	    assertEquals( "baseline" , styleHandle.getStringProperty( "verticalAlign" ) );
	    
		styleHandle.setProperty( StyleHandle.TEXT_INDENT_PROP , "50%");
		assertEquals( "50%" , styleHandle.getStringProperty( "textIndent" ) );
		
		styleHandle.setProperty( StyleHandle.TEXT_TRANSFORM_PROP , "UpperCase");
		assertEquals( "uppercase" , styleHandle.getStringProperty( "textTransform" ) );
		
		styleHandle.setProperty( StyleHandle.WHITE_SPACE_PROP , "Normal");
		assertEquals( "normal" , styleHandle.getStringProperty( "whiteSpace" ) );
		
		styleHandle.setProperty( StyleHandle.DISPLAY_PROP , "Block");
		assertEquals( "block" , styleHandle.getStringProperty( "display" ) );
		
		styleHandle.setProperty( StyleHandle.TEXT_ALIGN_PROP , "Right" );
		assertEquals( "right" , styleHandle.getStringProperty( "textAlign" ) );
		
		
//		Set Box
		styleHandle.setProperty( StyleHandle.MARGIN_TOP_PROP, "5pt" );
		assertEquals( "5pt" , styleHandle.getStringProperty( "marginTop" ) );
		
		styleHandle.setProperty( StyleHandle.MARGIN_BOTTOM_PROP, "5pt" );
		assertEquals( "5pt" , styleHandle.getStringProperty( "marginBottom" ) );
		
		styleHandle.setProperty( StyleHandle.MARGIN_LEFT_PROP, "5pt" );
		assertEquals( "5pt" , styleHandle.getStringProperty( "marginLeft" ) );
		
		styleHandle.setProperty( StyleHandle.MARGIN_RIGHT_PROP, "5pt" );
		assertEquals( "5pt" , styleHandle.getStringProperty( "marginRight" ) );
		
		
		styleHandle.setProperty( StyleHandle.PADDING_BOTTOM_PROP, "8pt" );
		assertEquals( "8pt" , styleHandle.getStringProperty( "paddingBottom" ) );
		
		styleHandle.setProperty( StyleHandle.PADDING_TOP_PROP, "8pt" );
		assertEquals( "8pt" , styleHandle.getStringProperty( "paddingTop" ) );
		
		styleHandle.setProperty( StyleHandle.PADDING_LEFT_PROP, "8pt" );
		assertEquals( "8pt" , styleHandle.getStringProperty( "paddingLeft" ) );
		
		styleHandle.setProperty( StyleHandle.PADDING_RIGHT_PROP, "8pt" );
		assertEquals( "8pt" , styleHandle.getStringProperty( "paddingRight" ) );
		
//		Set format

		try
		{
			styleHandle.setNumberFormatCategory( "#,###,###.##" ); //$NON-NLS-1$
			fail( );
		}
		catch ( PropertyValueException e )
		{
			assertEquals(
					PropertyValueException.DESIGN_EXCEPTION_CHOICE_NOT_FOUND, e
							.getErrorCode( ) );
		}
		styleHandle.setNumberFormatCategory( DesignChoiceConstants.NUMBER_FORMAT_TYPE_CURRENCY );
		styleHandle.setNumberFormat( "$##,##" ); //$NON-NLS-1$
		assertEquals( "$##,##", styleHandle.getNumberFormat( ) ); //$NON-NLS-1$

		styleHandle.setStringFormatCategory( DesignChoiceConstants.STRING_FORMAT_TYPE_LOWERCASE );
		styleHandle.setStringFormat( "***" ); //$NON-NLS-1$
		assertEquals( "***", styleHandle.getStringFormat( ) ); //$NON-NLS-1$		

		styleHandle.setDateTimeFormatCategory( DesignChoiceConstants.DATETIEM_FORMAT_TYPE_SHORT_DATE );
		styleHandle.setDateTimeFormat( "MM/DD/YYYY" ); //$NON-NLS-1$
		assertEquals( "MM/DD/YYYY", styleHandle.getDateTimeFormat( ) );
		
//		Set boder
		ColorHandle borderbottomcolor = styleHandle.getBorderBottomColor();
		borderbottomcolor.setStringValue("red");
		
		ColorHandle bordertopcolor = styleHandle.getBorderTopColor();
		bordertopcolor.setStringValue("yellow");
		
		ColorHandle borderleftcolor = styleHandle.getBorderLeftColor();
		borderleftcolor.setStringValue("blue");
		
		ColorHandle borderrightcolor = styleHandle.getBorderRightColor();
		borderrightcolor.setStringValue("green");
		
		styleHandle.setProperty( StyleHandle.BORDER_BOTTOM_WIDTH_PROP , "5pt" );
		assertEquals( "5pt" , styleHandle.getStringProperty( "borderBottomWidth" ) );
		
		styleHandle.setProperty( StyleHandle.BORDER_TOP_WIDTH_PROP , "5pt" );
		assertEquals( "5pt" , styleHandle.getStringProperty( "borderTopWidth" ) );
		
		styleHandle.setProperty( StyleHandle.BORDER_LEFT_WIDTH_PROP , "5pt" );
		assertEquals( "5pt" , styleHandle.getStringProperty( "borderLeftWidth" ) );
		
		styleHandle.setProperty( StyleHandle.BORDER_RIGHT_WIDTH_PROP , "5pt" );
		assertEquals( "5pt" , styleHandle.getStringProperty( "borderRightWidth" ) );
		
		
//		Set Page Break
		styleHandle.setStringProperty( StyleHandle.WIDOWS_PROP , "3");
		assertEquals( "3" , styleHandle.getStringProperty( "widows" ) );
		
		styleHandle.setStringProperty( StyleHandle.ORPHANS_PROP , "3");
		assertEquals( "3" , styleHandle.getStringProperty( "orphans" ) );
		
		styleHandle.setProperty( StyleHandle.PAGE_BREAK_AFTER_PROP, "Always"); 
		assertEquals( "always" , styleHandle.getStringProperty( "pageBreakAfter" ) );
		
		styleHandle.setProperty( StyleHandle.PAGE_BREAK_BEFORE_PROP, "Always");
		assertEquals( "always" , styleHandle.getStringProperty( "pageBreakBefore" ) );
		
		styleHandle.setProperty( StyleHandle.PAGE_BREAK_INSIDE_PROP, "Avoid");
		assertEquals( "avoid" , styleHandle.getStringProperty( "pageBreakInside" ) );

		
//		set highlight
		HighlightRule highLight = new HighlightRule();
		highLight.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		highLight.setTestExpression("row[\"account_id\"]");
		highLight.setValue1( "5" );
		highLight.setProperty( HighlightRule.FONT_SIZE_MEMBER , "10" );
		highLight.setProperty( HighlightRule.BACKGROUND_COLOR_MEMBER , "red");
		highLight.setProperty( HighlightRule.FONT_FAMILY_MEMBER , "Serif");
		highLight.setProperty( HighlightRule.COLOR_MEMBER , "yellow");
		highLight.setProperty( HighlightRule.FONT_WEIGHT_MEMBER , "bold");
		highLight.setProperty( HighlightRule.FONT_STYLE_MEMBER , "italic");
		highLight.setProperty( HighlightRule.TEXT_LINE_THROUGH_MEMBER , "line-through");
		highLight.setProperty( HighlightRule.TEXT_UNDERLINE_MEMBER , "underline");
		PropertyHandle highHandle = styleHandle.getPropertyHandle( StyleHandle.HIGHLIGHT_RULES_PROP );
		highHandle.addItem(highLight);
		
//		set map for table
		MapRule map =  new MapRule();
		map.setTestExpression("row[\"account_id\"]");
		map.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		map.setValue1( "5" );
		map.setDisplay( "NO" );
		PropertyHandle mapHandle = styleHandle.getPropertyHandle( StyleHandle.MAP_RULES_PROP );
		mapHandle.addItem(map);



		
	}
	
	
	
	public void testStyleCopy( ) throws Exception
	{
		
		openDesign(fileName);
		LabelHandle label = (LabelHandle)designHandle.getElementFactory().newLabel("label");
		
		StyleHandle styleHandle = (StyleHandle)designHandle.getElementFactory().newStyle("style1");
		designHandle.getStyles().add( styleHandle );
		
//		Copy style
		DesignElement style2 =(DesignElement)styleHandle.copy();
	    assertNotNull(style2);
	    style2.setName("style2");  
	    designHandle.getStyles().add(style2.getHandle(design));
	    
//	    Cut style
	    designHandle.getStyles().drop(styleHandle);
		assertEquals( 1 , designHandle.getStyles().getCount() );
		
//		Delete style
		StyleHandle style3 = (StyleHandle)designHandle.getElementFactory().newStyle("style3");
		designHandle.getStyles().add( style3 );
		assertEquals( 2 , designHandle.getStyles().getCount());
		designHandle.getStyles().drop(style3);
		assertEquals( 1 , designHandle.getStyles().getCount());
		
//		Undo and Redo
		designHandle.getCommandStack().undo();
		assertEquals( 2 , designHandle.getStyles().getCount());
		designHandle.getCommandStack().redo();
		assertEquals( 1 , designHandle.getStyles().getCount());
		
	}
	
	public void testStyleApply( ) throws Exception
	{
		
		openDesign(fileName);
		LabelHandle label = (LabelHandle)designHandle.getElementFactory().newLabel("label");
		designHandle.getBody().add(label);
		
		TextItemHandle text = (TextItemHandle)designHandle.getElementFactory().newTextItem("text");
		designHandle.getBody().add(text);
		
		SharedStyleHandle styleHandle = designHandle.getElementFactory().newStyle("style1");
		designHandle.getStyles().add( styleHandle );
		
		styleHandle.setStringProperty(StyleHandle.BACKGROUND_COLOR_PROP, "red");
		styleHandle.setStringProperty(StyleHandle.FONT_SIZE_PROP, "1pt");
		styleHandle.setStringProperty(StyleHandle.BORDER_BOTTOM_WIDTH_PROP, "3pt");
		styleHandle.setStringProperty(StyleHandle.MARGIN_LEFT_PROP, "4pt");
		
//		Apply style
		label.setStyle(styleHandle);
		assertNotNull( label.getStyle() );
		assertEquals( "red" , label.getStringProperty("backgroundColor"));
		assertEquals( "1pt" , label.getStringProperty("fontSize"));
		assertEquals( "3pt" , label.getStringProperty("borderBottomWidth"));
		assertEquals( "4pt" , label.getStringProperty("marginLeft"));
		
//		New a Pre-define style
		SharedStyleHandle styleLabel = designHandle.getElementFactory().newStyle("text");
		
		styleLabel.setStringProperty(StyleHandle.BACKGROUND_COLOR_PROP, "yellow");
		styleLabel.setStringProperty(StyleHandle.FONT_SIZE_PROP, "5pt");
		styleLabel.setStringProperty(StyleHandle.BORDER_BOTTOM_WIDTH_PROP, "5pt");
		styleLabel.setStringProperty(StyleHandle.MARGIN_LEFT_PROP, "5pt");
		designHandle.getStyles().add( styleLabel );
		
		assertEquals( "yellow" , text.getStringProperty("backgroundColor"));
		assertEquals( "5pt" , text.getStringProperty("fontSize"));
		assertEquals( "5pt" , text.getStringProperty("borderBottomWidth"));
		assertEquals( "5pt" , text.getStringProperty("marginLeft"));
		
		assertEquals( "red" , label.getStringProperty("backgroundColor"));
		assertEquals( "1pt" , label.getStringProperty("fontSize"));
		assertEquals( "3pt" , label.getStringProperty("borderBottomWidth"));
		assertEquals( "4pt" , label.getStringProperty("marginLeft"));
	}
}
