package org.eclipse.birt.report.tests.model.acceptance;


import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.DesignChoiceConstants;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.interfaces.IReportItemModel;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class TableElementHandleTest extends BaseTestCase
{
	private static final String SORT_DIRCTION_ASC = null;
	String fileName = "BlankReport.xml";
	public TableElementHandleTest(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(TableElementHandleTest.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	public void testTable( ) throws Exception
	{
		openDesign( fileName );
		
//		New a error table
		try
		{
			TableHandle tableHandle = (TableHandle)designHandle.getElementFactory().newTableItem( "table" , -3 , 1, 1, 1 );
			designHandle.getBody().add( tableHandle );
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			TableHandle tableHandle = (TableHandle)designHandle.getElementFactory().newTableItem( "table" , -3 , 1, 1, 1 );
			designHandle.getBody().add( tableHandle );
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}		
		try
		{
			TableHandle tableHandle = (TableHandle)designHandle.getElementFactory().newTableItem( "table" , 3 , -1, 1, 1 );
			designHandle.getBody().add( tableHandle );
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}		
		try
		{
			TableHandle tableHandle = (TableHandle)designHandle.getElementFactory().newTableItem( "table" , 3 , 1, -1, 1 );
			designHandle.getBody().add( tableHandle );
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			TableHandle tableHandle = (TableHandle)designHandle.getElementFactory().newTableItem( "table" , 3 , 1, 1, -1 );
			designHandle.getBody().add( tableHandle );
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		
//		New a table
		TableHandle tableHandle = (TableHandle)designHandle.getElementFactory().newTableItem( "table" , 3 , 1, 1, 1 );
		designHandle.getBody().add( tableHandle );
		assertEquals( 3 , tableHandle.getColumns().getCount() );
		assertEquals( 1 , tableHandle.getDetail().getCount() );
		
//		Rename the table name
		tableHandle.setName("tableRename");
		assertEquals( "tableRename" , tableHandle.getName() );
		designHandle.getCommandStack().undo();

		
//		Binding the table with a data set
		TableHandle table = (TableHandle)designHandle.findElement("table");
		assertNotNull(table);
		DataSetHandle ds = designHandle.findDataSet("sqlserverDS");
		assertNotNull(ds);
		table.setDataSet(ds);
		assertEquals("sqlserverDS",table.getDataSet().getName());
		
		
//		set sort key for table
		SortKey sortkey = StructureFactory.createSortKey( );
		sortkey.setKey( "row[\"account_id\"]" );
		sortkey.setDirection(DesignChoiceConstants.SORT_DIRECTION_DESC);
		PropertyHandle propHandle = table.getPropertyHandle( ListingElement.SORT_PROP );
		propHandle.addItem( sortkey );
		assertEquals("row[\"account_id\"]",sortkey.getKey());
		assertEquals(DesignChoiceConstants.SORT_DIRECTION_DESC,sortkey.getDirection());
		
		
//		set filter key for table
		propHandle = table.getPropertyHandle( ListingElement.FILTER_PROP );
		FilterCondition filter = StructureFactory.createFilterCond( );
		filter.setExpr( "row[\"account_id\"]" ); //$NON-NLS-1$
		filter.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		filter.setValue1( "5" );
		propHandle.addItem( filter );
		assertEquals("row[\"account_id\"]",filter.getExpr());
		assertEquals( DesignChoiceConstants.MAP_OPERATOR_GT, filter.getOperator( ) );
		assertEquals("5",filter.getValue1());
		
//		set highlight key for table
		HighlightRule highLight = new HighlightRule();
		highLight.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		highLight.setTestExpression("row[\"account_id\"]");
		highLight.setValue1( "5" );
		highLight.setProperty( HighlightRule.FONT_SIZE_MEMBER , "100" );
		highLight.setProperty( HighlightRule.BACKGROUND_COLOR_MEMBER , "red");
		highLight.setProperty( HighlightRule.FONT_FAMILY_MEMBER , "Serif");
		highLight.setProperty( HighlightRule.COLOR_MEMBER , "yellow");
		highLight.setProperty( HighlightRule.FONT_WEIGHT_MEMBER , "bold");
		highLight.setProperty( HighlightRule.FONT_STYLE_MEMBER , "italic");
		highLight.setProperty( HighlightRule.TEXT_LINE_THROUGH_MEMBER , "line-through");
		highLight.setProperty( HighlightRule.TEXT_UNDERLINE_MEMBER , "underline");
		PropertyHandle highHandle = table.getPropertyHandle( StyleHandle.HIGHLIGHT_RULES_PROP );
		highHandle.addItem(highLight);
		
//		set hightlight for table row
		highLight.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		highLight.setTestExpression("row[\"account_id\"]");
		highLight.setValue1( "5" );
		highLight.setProperty( HighlightRule.FONT_SIZE_MEMBER , "100" );
		highLight.setProperty( HighlightRule.BACKGROUND_COLOR_MEMBER , "red");
		highLight.setProperty( HighlightRule.FONT_FAMILY_MEMBER , "Serif");
		highLight.setProperty( HighlightRule.COLOR_MEMBER , "yellow");
		highLight.setProperty( HighlightRule.FONT_WEIGHT_MEMBER , "bold");
		highLight.setProperty( HighlightRule.FONT_STYLE_MEMBER , "italic");
		highLight.setProperty( HighlightRule.TEXT_LINE_THROUGH_MEMBER , "line-through");
		highLight.setProperty( HighlightRule.TEXT_UNDERLINE_MEMBER , "underline");
		PropertyHandle highRowHandle = table.getHeader().get( 0 ).getPropertyHandle( StyleHandle.HIGHLIGHT_RULES_PROP );
		highRowHandle.addItem(highLight);
		
		
//		set hightlight for table column
		highLight.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		highLight.setTestExpression("row[\"account_id\"]");
		highLight.setValue1( "5" );
		highLight.setProperty( HighlightRule.FONT_SIZE_MEMBER , "100" );
		highLight.setProperty( HighlightRule.BACKGROUND_COLOR_MEMBER , "red");
		highLight.setProperty( HighlightRule.FONT_FAMILY_MEMBER , "Serif");
		highLight.setProperty( HighlightRule.COLOR_MEMBER , "yellow");
		highLight.setProperty( HighlightRule.FONT_WEIGHT_MEMBER , "bold");
		highLight.setProperty( HighlightRule.FONT_STYLE_MEMBER , "italic");
		highLight.setProperty( HighlightRule.TEXT_LINE_THROUGH_MEMBER , "line-through");
		highLight.setProperty( HighlightRule.TEXT_UNDERLINE_MEMBER , "underline");
		PropertyHandle highColumnHandle = tableHandle.getColumns().get(0).getPropertyHandle( StyleHandle.HIGHLIGHT_RULES_PROP );
		highColumnHandle.addItem(highLight);
		
		
		
//		set hightlight for table cell
		highLight.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		highLight.setTestExpression("row[\"account_id\"]");
		highLight.setValue1( "5" );
		highLight.setProperty( HighlightRule.FONT_SIZE_MEMBER , "100" );
		highLight.setProperty( HighlightRule.BACKGROUND_COLOR_MEMBER , "red");
		highLight.setProperty( HighlightRule.FONT_FAMILY_MEMBER , "Serif");
		highLight.setProperty( HighlightRule.COLOR_MEMBER , "yellow");
		highLight.setProperty( HighlightRule.FONT_WEIGHT_MEMBER , "bold");
		highLight.setProperty( HighlightRule.FONT_STYLE_MEMBER , "italic");
		highLight.setProperty( HighlightRule.TEXT_LINE_THROUGH_MEMBER , "line-through");
		highLight.setProperty( HighlightRule.TEXT_UNDERLINE_MEMBER , "underline");
		SlotHandle tableHeader = tableHandle.getHeader();
		RowHandle tableHeaderRow = (RowHandle)tableHeader.get( 0 );
		CellHandle tableHeaderCell = (CellHandle)tableHeaderRow.getCells().get(0);
		assertNotNull("cell not alive" , tableHeaderCell);
		PropertyHandle highCellHandle = tableHeaderCell.getPropertyHandle( StyleHandle.HIGHLIGHT_RULES_PROP );
		highCellHandle.addItem(highLight);
		
		
//		set group for table
		TableGroupHandle tableGroup = (TableGroupHandle)designHandle.getElementFactory().newTableGroup();
		table.getGroups().add( tableGroup );
		assertNotNull( "Group has not insert" , tableGroup );
		tableGroup.setGroupStart("row[\"account_id\"]");
		tableGroup.setTocExpression("new Date()");
		tableGroup.setSortDirection(DesignChoiceConstants.SORT_DIRECTION_ASC);
		tableGroup.setName( "tableGroup " );
		tableGroup.setInterval( "Interval" );
		tableGroup.setIntervalRange(1);
		assertEquals( "tableGroup" , tableGroup.getName() );
		assertEquals( "interval" , tableGroup.getInterval() );
		assertEquals( "asc" , tableGroup.getSortDirection());
		
//		set map for table
		MapRule map =  new MapRule();
		map.setTestExpression("row[\"account_id\"]");
		map.setOperator( DesignChoiceConstants.MAP_OPERATOR_GT );
		map.setValue1( "5" );
		map.setDisplay( "NO" );
		PropertyHandle mapHandle = table.getPropertyHandle( StyleHandle.MAP_RULES_PROP );
		mapHandle.addItem(map);
		
		
		
//		Copy Column
		ColumnBandData column = tableHandle.copyColumn( 1 );
		tableHandle.insertAndPasteColumn( column , 1);
		assertEquals( 4 , tableHandle.getColumnCount() );
		designHandle.getCommandStack().undo();
		assertEquals( 3 , tableHandle.getColumnCount() );
		designHandle.getCommandStack().redo();
		assertEquals( 4 , tableHandle.getColumnCount() );
		
//		Delete Column
		DesignElementHandle columnDelete = tableHandle.getColumns().get( 0 );
		columnDelete.drop();
		assertEquals( 3 , tableHandle.getColumnCount() );
		designHandle.getCommandStack().undo();
		assertEquals( 4 , tableHandle.getColumnCount() );
		
		
//		Insert Group
		TableGroupHandle group = newTableGroup( 1, 1, 3 );
		tableHandle.getGroups( ).add( group );
		assertEquals( 4 , tableHandle.getColumns().getCount() );
		assertEquals( 1 , tableHandle.getGroups().getCount() );
	}
	
	
	
	public void testTableInsert( ) throws Exception
	{
		openDesign(fileName);
		
		TableHandle tableElement = (TableHandle)designHandle.getElementFactory().newTableItem( "table" , 3 , 1, 1, 1 );
		designHandle.getBody().add( tableElement );
		
//		Insert a Label
		SlotHandle tableHeader = tableElement.getHeader();
		RowHandle tableHeaderRow = (RowHandle)tableHeader.get( 0 );
		CellHandle tableHeaderCell = (CellHandle)tableHeaderRow.getCells().get(1);
		LabelHandle label = (LabelHandle)designHandle.getElementFactory().newLabel( "label1" );
		tableHeaderCell.addElement( label , LabelHandle.USER_LABEL );
		DesignElementHandle tableHeaderCellContent = tableHeaderCell.getContent( ).get( 0 );
		assertTrue( tableHeaderCellContent instanceof LabelHandle );
		
//		Delete label
		label.drop();
		assertNotNull(label);
		
//		Insert a Text
		tableHeaderCell = (CellHandle)tableHeaderRow.getCells().get(2);
		TextItemHandle text = (TextItemHandle)designHandle.getElementFactory().newTextItem( "text1" );
		tableHeaderCell.addElement( text , TextItemHandle.USER_LABEL );
		tableHeaderCellContent = tableHeaderCell.getContent( ).get( 0 );
		assertTrue( tableHeaderCellContent instanceof TextItemHandle );
		
//		Insert a data
		SlotHandle tableDetail = tableElement.getDetail();
		RowHandle tableDetailRow = (RowHandle)tableDetail.get( 0 );
		CellHandle tableDetailCell = (CellHandle)tableDetailRow.getCells().get( 0 );
		DataItemHandle data = (DataItemHandle)designHandle.getElementFactory().newDataItem( "data1" );
		tableDetailCell.addElement( data , DataItemHandle.USER_LABEL );
		DesignElementHandle tableDetailCellContent = tableDetailCell.getContent().get( 0 );
		assertTrue( tableDetailCellContent instanceof DataItemHandle);
		data.drop();
		
//		Insert a image
		SlotHandle tableFooter = tableElement.getFooter();
		RowHandle tableFooterRow = (RowHandle)tableFooter.get( 0 );
		CellHandle tableFooterCell = (CellHandle)tableFooterRow.getCells().get( 0 );
		ImageHandle image = (ImageHandle)designHandle.getElementFactory().newImage( "image" );
		tableFooterCell.addElement( image , ImageHandle.USER_LABEL );
		DesignElementHandle tableFooterCellContent = tableFooterCell.getContent().get( 0 );
		assertTrue( tableFooterCellContent instanceof ImageHandle );
		
//		Insert a grid
		tableFooterCell = (CellHandle)tableFooterRow.getCells().get( 1 );
		GridHandle grid = (GridHandle)designHandle.getElementFactory().newGridItem( "grid1" );
		tableFooterCell.addElement( grid , GridHandle.USER_LABEL );
		tableFooterCellContent = tableFooterCell.getContent().get( 0 );
		assertTrue( tableFooterCellContent instanceof GridHandle );
		
//		Insert a list in detail
		tableFooterCell = (CellHandle)tableFooterRow.getCells().get( 2 );
		ListHandle list = (ListHandle)designHandle.getElementFactory().newList("list");
		tableDetailRow = (RowHandle)tableDetail.get( 0 );
		tableDetailCell = (CellHandle)tableDetailRow.getCells().get( 1 );
		tableDetailCell.addElement( list , ListHandle.USER_LABEL );
		tableDetailCellContent = tableDetailCell.getContent().get( 0 );
		assertTrue( tableDetailCellContent instanceof ListHandle);
		
		
//		Insert a table in detail
		TableHandle table = (TableHandle)designHandle.getElementFactory().newTableItem("table");
		tableDetailCell = (CellHandle)tableDetailRow.getCells().get( 2 );
		tableDetailCell.addElement( table , ListHandle.USER_LABEL );
		tableDetailCellContent = tableDetailCell.getContent().get( 0 );
		assertTrue( tableDetailCellContent instanceof TableHandle);
		
//		Insert a table row
		RowHandle rowTable = (RowHandle)designHandle.getElementFactory().newTableRow();
		table.addElement( rowTable , TableRow.CONTENT_SLOT , 0);
		assertEquals( 1 , table.getHeader().getCount() );
		
//		Delete table row
		rowTable.drop();
		assertEquals( 0, table.getHeader().getCount() );
		
//		Insert a table column
		ColumnHandle columnTable = (ColumnHandle)designHandle.getElementFactory().newTableColumn();
		table.getColumns().add(columnTable , 0);
		assertEquals( 1 , table.getColumnCount() );
		
//		Delete table column
		columnTable.drop();
		assertEquals( 0 , table.getColumnCount() );
		
//		Delete table
		designHandle.getBody().drop(tableElement);
		assertEquals(0,designHandle.getBody().getCount());
		designHandle.getCommandStack().undo();
		
//		Copy, Cut and paste table
	    TableItem newtable = (TableItem)table.copy();
	    assertNotNull(newtable);
	    assertEquals(table.getName(),newtable.getName());
	    design = (ReportDesign)designHandle.getModule();
	    
	    try{
	    	designHandle.getBody().add(newtable.getHandle(design));
		    fail();
	    }
	    catch (NameException e)
	    {
	      assertNotNull(e);
	    }
	    newtable.setName("newtable");
	    designHandle.getBody().add(newtable.getHandle(design));
	    assertEquals("newtable",newtable.getName());
		
	}
	
	
	public void testCellMerge( ) throws Exception
	{
		openDesign(fileName);
		TableHandle tableElement = (TableHandle)designHandle.getElementFactory().newTableItem( "table" , 3 , 1, 1, 1 );
		designHandle.getBody().add( tableElement );
		
		
		
//		Merge header cell
		SlotHandle rowHeader = tableElement.getHeader();
		RowHandle rowRow = (RowHandle)rowHeader.get( 0 );
		CellHandle rowCell1 = (CellHandle)rowRow.getCells().get( 0 );
		CellHandle rowCell2 = (CellHandle)rowRow.getCells().get( 1 );
		rowCell1.drop();
		rowCell2.setRowSpan( 2 );
		assertEquals( 1 , tableElement.getHeader().getCount() );
		
//		Merge detail cell
		SlotHandle rowDetail = tableElement.getDetail();
		rowRow = (RowHandle)rowDetail.get( 0 );
		rowCell1 = (CellHandle)rowRow.getCells().get( 0 );
		rowCell2 = (CellHandle)rowRow.getCells().get( 1 );
		rowCell2.drop();
		rowCell1.setRowSpan( 2 );
		assertEquals( 1 , tableElement.getDetail().getCount() );
		
		
//		Merge footer cell
		SlotHandle rowFooter = tableElement.getHeader();
		rowRow = (RowHandle)rowHeader.get( 0 );
		rowCell1 = (CellHandle)rowRow.getCells().get( 0 );
		rowCell2 = (CellHandle)rowRow.getCells().get( 1 );
		rowCell2.drop();
		rowCell1.setRowSpan( 2 );
		assertEquals( 2 , rowCell1.getRowSpan() );
		
//		Split cell
		rowCell1.setRowSpan(1);
		CellHandle cellAdd = (CellHandle)designHandle.getElementFactory().newCell();
		rowRow.addElement( cellAdd , CellHandle.USER_LABEL );
		assertEquals( 1 , tableElement.getHeader().getCount() );
	}
	
	
	
	private TableGroupHandle newTableGroup( int headerRowNum, int footerRowNum,
			int columnNum ) throws SemanticException
	{
		assert headerRowNum > 0 && footerRowNum > 0 && columnNum > 0;
		TableGroupHandle group = designHandle.getElementFactory( )
				.newTableGroup( );

		for ( int i = 0; i < headerRowNum; i++ )
			group.getHeader( ).add(
					designHandle.getElementFactory( ).newTableRow( columnNum ) );

		for ( int i = 0; i < footerRowNum; i++ )
			group.getFooter( ).add(
					designHandle.getElementFactory( ).newTableRow( columnNum ) );

		return group;
	}
	
	
	public void testTableProperty( ) throws Exception
	{
		openDesign(fileName);
		TableHandle tableHandle = (TableHandle)designHandle.getElementFactory().newTableItem( "table" , 3 , 1, 1, 1 );
		designHandle.getBody().add( tableHandle );
		
		ImageHandle image = (ImageHandle)designHandle.getElementFactory().newImage("image");
		
		tableHandle.setWidth("0%");
		assertEquals("0%" , tableHandle.getStringProperty(IReportItemModel.WIDTH_PROP));
		tableHandle.setHeight("600in");
		assertEquals("600in" , tableHandle.getStringProperty(IReportItemModel.HEIGHT_PROP));
		tableHandle.setWidth("200%");
		assertEquals("200%" , tableHandle.getStringProperty(IReportItemModel.WIDTH_PROP));
		
		
//		Undo and Redo
		designHandle.getCommandStack().undo();
		assertEquals("0%" , tableHandle.getStringProperty(IReportItemModel.WIDTH_PROP));
		designHandle.getCommandStack().redo();
		assertEquals("200%" , tableHandle.getStringProperty(IReportItemModel.WIDTH_PROP));
		
//		set porperty
		
		tableHandle.setWidth("50%");
		assertEquals("50%" , tableHandle.getStringProperty(IReportItemModel.WIDTH_PROP));
		
		tableHandle.setHeight("6in");
		assertEquals("6in" , tableHandle.getStringProperty(IReportItemModel.HEIGHT_PROP));
		
		tableHandle.setStringProperty(StyleHandle.TEXT_ALIGN_PROP, "center");
		assertEquals("center" , tableHandle.getStringProperty("textAlign"));
		
		tableHandle.setStringProperty(StyleHandle.BACKGROUND_COLOR_PROP, "yellow");
		assertEquals("yellow" , tableHandle.getStringProperty("backgroundColor"));
		
		tableHandle.setStringProperty(StyleHandle.BACKGROUND_IMAGE_PROP , "image");
		assertEquals("image" , tableHandle.getStringProperty("backgroundImage"));
		
		tableHandle.setStringProperty(StyleHandle.MARGIN_TOP_PROP , "3in");
		assertEquals("3in" , tableHandle.getStringProperty("marginTop"));
		
		tableHandle.setStringProperty(StyleHandle.MARGIN_LEFT_PROP , "10mm");
		assertEquals("10mm" , tableHandle.getStringProperty("marginLeft"));
		
		tableHandle.setStringProperty(StyleHandle.MARGIN_BOTTOM_PROP , "0%");
		assertEquals("0%" , tableHandle.getStringProperty("marginBottom"));
		
		tableHandle.setStringProperty(StyleHandle.FONT_FAMILY_PROP , "cursive");
		assertEquals("cursive" , tableHandle.getStringProperty("fontFamily"));
		
		try
		{
			tableHandle.setStringProperty(StyleHandle.FONT_SIZE_PROP , "Xlarge");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		
		tableHandle.setStringProperty(StyleHandle.FONT_WEIGHT_PROP , "bold");
		assertEquals("bold" , tableHandle.getStringProperty("fontWeight"));
		
//		set other property
		try
		{
			tableHandle.setStringProperty(StyleHandle.TEXT_ALIGN_PROP, "myAligh");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
		tableHandle.setStyleName("abc");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			tableHandle.setStringProperty(StyleHandle.BACKGROUND_COLOR_PROP , "myColor");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			tableHandle.setStringProperty(StyleHandle.MARGIN_TOP_PROP , "1000ems");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			tableHandle.setStringProperty(StyleHandle.MARGIN_LEFT_PROP , "-50points");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			tableHandle.setStringProperty(StyleHandle.MARGIN_RIGHT_PROP , "1:;");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			tableHandle.setStringProperty(StyleHandle.FONT_FAMILY_PROP , "myFont");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			tableHandle.setStringProperty(StyleHandle.FONT_SIZE_PROP , "0points");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			tableHandle.setStringProperty(StyleHandle.FONT_SIZE_PROP , "100%");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			tableHandle.setStringProperty(StyleHandle.FONT_SIZE_PROP , "-3in");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			tableHandle.setStringProperty(StyleHandle.FONT_SIZE_PROP , "my$#%^");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		try
		{
			tableHandle.setStringProperty(StyleHandle.COLOR_PROP , "(0,-1,3)");
		}
		catch(Exception e)
		{
			assertNotNull(e);
		}
		
		
		
	}
}
