/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

/**
 * Test cases for property search algorithm of cell elements.
 *  
 */

public class DataSetHandleTest extends BaseTestCase
{
 
	String fileName = "DataSetHandleTest.xml"; //$NON-NLS-1$

	/*
	 * @see TestCase#setUp()
	 */

	public DataSetHandleTest(String name){
		super(name);
	}
	public static Test suite(){
		
		return new TestSuite(DataSetHandleTest.class);
	}
	
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}

	/**
	 * Tests to get a style property of a cell element in the table.
	 * 
	 * @throws Exception
	 */

	public void testGetDataSetProperty( ) throws Exception
	{

		openDesign( fileName );

		// style property inherited from cell, row, column, table element.

		// color defined on the cell.

		DataSetHandle dataset = (DataSetHandle)designHandle.findDataSet("firstDataSet"); 
		assertNotNull("should not be null", dataset);
		
  		
   		dataset.setDataSource("myDataSource");
   		assertEquals("myDataSource", dataset.getDataSourceName());
  		
  		
   		dataset.setOnFetch("setonfetch");
   		assertEquals("setonfetch", dataset.getOnFetch());
   		
		dataset.setAfterClose("setAfterClose");
		assertEquals("setAfterClose",dataset.getAfterClose());
		
		dataset.setAfterOpen("setAfterOpen");
		assertEquals("setAfterOpen",dataset.getAfterOpen());
		
		dataset.setBeforeClose("setBeforeClose");
		assertEquals("setBeforeClose",dataset.getBeforeClose());
		
		dataset.setBeforeOpen("setBeforeOpen");
		assertEquals("setBeforeOpen",dataset.getBeforeOpen());
   		
   		
 }
}