package org.eclipse.birt.report.tests.model.api;

import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class DesignElementHandleGetXPath extends BaseTestCase
{
	String fileName = "DesignElementHandle_GetXPath.xml";
	
	public DesignElementHandleGetXPath(String name) 
	{	
		super(name);
	}
    public static Test suite()
    {
		
		return new TestSuite(DesignElementHandleGetXPath.class);
	}
	protected void setUp( ) throws Exception
	{
		super.setUp( );
	}
	
	public void testGetXPath( ) throws Exception
	{
		openDesign(fileName);
	    
		TextItemHandle textHandle = (TextItemHandle)designHandle.findElement( "myText" );
		assertNotNull("Text should not be null", textHandle); 
		TableHandle tableHandle = (TableHandle)designHandle.findElement( "myTable" );
		assertNotNull("Table should not be null", tableHandle);
		StyleHandle styleHandle = (StyleHandle)designHandle.findStyle( "myStyle" );
		assertNotNull("Style should not be null", styleHandle);
		DesignElementHandle parameterHandle = designHandle.findElement( "myPara" );
		assertNotNull("Parameter should not be null", parameterHandle);
		LabelHandle labelHandle = (LabelHandle)designHandle.findElement( "myLabel" );
		assertNotNull("Label should not be null", labelHandle);
		ImageHandle imageHandle = (ImageHandle)designHandle.findElement( "myImage" );
		assertNotNull("Image should not be null", imageHandle);
		DataItemHandle dataHandle = (DataItemHandle)designHandle.findElement( "myData" );
		assertNotNull("Data should not be null", dataHandle); 
		MasterPageHandle masterHeader = designHandle.findMasterPage( "myMasterPage" );
		assertNotNull("MasterHeader should not be null", masterHeader);
		
		assertEquals( "/report/body[1]/text[1]", textHandle.getXPath( ) ); 
		assertEquals( "/report/body[1]/table[1]", tableHandle.getXPath( ) ); 
		assertEquals( "/report/styles[1]/style[1]", styleHandle.getXPath( ) ); 
		assertEquals( "/report/body[1]/data[2]", parameterHandle.getXPath( ) ); 
		assertEquals( "/report/body[1]/label[1]", labelHandle.getXPath( ) ); 
	    assertEquals( "/report/body[1]/image[1]", imageHandle.getXPath( ) ); 
		assertEquals( "/report/body[1]/data[1]", dataHandle.getXPath( ) ); 
		assertEquals( "/report/page-setup[1]/simple-master-page[1]", masterHeader.getXPath() );
		
		
	}
}
