/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

/**
 * The test case of <code>GridItem</code> parser and writer.
 * <p>
 * <code>TableColumn</code>,<code>TableRow</code> and <code>Cell</code>
 * are also tested in this test case.
 * 
 * <p>
 * <table border="1" cellpadding="2" cellspacing="2" style="border-collapse:
 * collapse" bordercolor="#111111">
 * <th width="20%">Method</th>
 * <th width="40%">Test Case</th>
 * <th width="40%">Expected</th>
 * 
 * <tr>
 * <td>{@link #testMethods()}</td>
 * <td>Test column slot of GridItem after parsing design file</td>
 * <td>The column number in the slot is 2. And the column number is 4.</td>
 * </tr>
 * 
 * <tr>
 * <td></td>
 * <td>Test row slot of GridItem after parsing design file</td>
 * <td>The row number in the slot is 2.</td>
 * </tr>
 * 
 * </table>
 */

public class GridItemHandleTest extends BaseTestCase
{

	/**
	 * @param name
	 */
	public GridItemHandleTest(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}

	String fileName = "GridItemHandleTest.xml"; //$NON-NLS-1$

	public static Test suite(){
		return new TestSuite(GridItemHandleTest.class);
		
		
		
	}
	
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp( ) throws Exception
	{
		super.setUp( );
		openDesign( fileName );
	}

	/**
	 * Tests the column count on grids that have column definition or not.
	 * 
	 * @throws Exception
	 *  
	 */

	public void testMethods( ) throws Exception
	{

		assertEquals( 0, design.getErrorList( ).size( ) );

		GridHandle gridHandle = (GridHandle) designHandle
				.findElement( "My grid" ); //$NON-NLS-1$

		assertNotNull( gridHandle );

		// Test column properties
		assertEquals( 4, gridHandle.getColumnCount( ) );

		SlotHandle slotHandle = gridHandle.getColumns( );
		assertEquals( 2, slotHandle.getCount( ) );

		// Test on row properties.

		slotHandle = gridHandle.getRows( );
		assertEquals( 2, slotHandle.getCount( ) );

		// Test column properties

		gridHandle = (GridHandle) designHandle.findElement( "My grid 1" ); //$NON-NLS-1$

		assertEquals( 5, gridHandle.getColumnCount( ) );

		slotHandle = gridHandle.getColumns( );
		assertEquals( 0, slotHandle.getCount( ) );
		
	}
	
	/**
	 * Tests getCell().
	 *
	 */
	public void testGetCell( )
	{
		assertEquals( 0, design.getErrorList( ).size( ) );

		GridHandle gridHandle = (GridHandle) designHandle
				.findElement( "My grid" ); //$NON-NLS-1$

		assertNotNull( gridHandle );
		
		// test getCell( int, int ), the gird is 2r*4c

		gridHandle = (GridHandle) designHandle.findElement( "My grid" ); //$NON-NLS-1$
		assertEquals( 2, gridHandle.getRows().getCount( ) );
		assertEquals( 4, gridHandle.getColumnCount( ) );
		SlotHandle rows = gridHandle.getRows( );
		RowHandle row1 = (RowHandle)rows.get( 0 );
		RowHandle row2 = (RowHandle)rows.get( 1 );
			
		CellHandle cell_11 = (CellHandle)row1.getCells( ).get( 0 );
		assertEquals( 1, cell_11.getColumn( ) );
		assertEquals( 1, cell_11.getColumnSpan( ) );
		assertEquals( 1, cell_11.getRowSpan( ) );
		CellHandle cell_12 = (CellHandle)row1.getCells( ).get( 1 );
		assertEquals( 2, cell_12.getColumn( ) );
		assertEquals( 3, cell_12.getColumnSpan( ) );
		assertEquals( 1, cell_12.getRowSpan( ) );
		CellHandle cell_21 = (CellHandle)row2.getCells( ).get( 0 );
		assertEquals( 1, cell_21.getColumn( ) );
		assertEquals( 4, cell_21.getColumnSpan( ) );
		assertEquals( 1, cell_21.getRowSpan( ) );
		
		assertNull( gridHandle.getCell( 1, 5 ) );
		assertNull( gridHandle.getCell( 3, 1 ) );
		assertNull( gridHandle.getCell( 3, 5 ) );
		assertEquals( cell_11, gridHandle.getCell( 1, 1 ) );
		assertEquals( cell_12, gridHandle.getCell( 1, 2 ) );
		assertEquals( cell_12, gridHandle.getCell( 1, 3 ) );
		assertEquals( cell_12, gridHandle.getCell( 1, 4 ) );
		assertEquals( cell_21, gridHandle.getCell( 2, 1 ) );
		assertEquals( cell_21, gridHandle.getCell( 2, 2 ) );
		assertEquals( cell_21, gridHandle.getCell( 2, 3 ) );
		assertEquals( cell_21, gridHandle.getCell( 2, 4 ) );
		
		//
		gridHandle = (GridHandle) designHandle.findElement( "My grid 1" ); //$NON-NLS-1$
		assertEquals( 2, gridHandle.getRows().getCount( ) );
		assertEquals( 5, gridHandle.getColumnCount( ) );
		rows = gridHandle.getRows( );
		row1 = (RowHandle)rows.get( 0 );
		row2 = (RowHandle)rows.get( 1 );
			
		cell_11 = (CellHandle)row1.getCells( ).get( 0 );
		assertEquals( 1, cell_11.getColumn( ) );
		assertEquals( 1, cell_11.getColumnSpan( ) );
		assertEquals( 2, cell_11.getRowSpan( ) );
		cell_12 = (CellHandle)row1.getCells( ).get( 1 );
		assertEquals( 2, cell_12.getColumn( ) );
		assertEquals( 4, cell_12.getColumnSpan( ) );
		assertEquals( 1, cell_12.getRowSpan( ) );
		cell_21 = (CellHandle)row2.getCells( ).get( 0 );
		assertEquals( 2, cell_21.getColumn( ) );
		assertEquals( 2, cell_21.getColumnSpan( ) );
		assertEquals( 1, cell_21.getRowSpan( ) );
		
		assertNull( gridHandle.getCell( 1, 6 ) );
		assertNull( gridHandle.getCell( 3, 1 ) );
		assertNull( gridHandle.getCell( 3, 6 ) );
		assertEquals( cell_11, gridHandle.getCell( 1, 1 ) );
		assertEquals( cell_12, gridHandle.getCell( 1, 2 ) );
		assertEquals( cell_12, gridHandle.getCell( 1, 3 ) );
		assertEquals( cell_12, gridHandle.getCell( 1, 4 ) );
		assertEquals( cell_12, gridHandle.getCell( 1, 5 ) );
		assertEquals( cell_11, gridHandle.getCell( 2, 1 ) );
		assertEquals( cell_21, gridHandle.getCell( 2, 2 ) );
		assertEquals( cell_21, gridHandle.getCell( 2, 3 ) );
		assertEquals( null, gridHandle.getCell( 2, 4 ) );
		assertEquals( null, gridHandle.getCell( 2, 5 ) );
	}
}