
package org.eclipse.birt.report.tests.model.api;

import java.util.ArrayList;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SimpleGroupElementHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.model.BaseTestCase;

import com.ibm.icu.util.ULocale;

public class GroupElementHandleTest extends BaseTestCase
{

	ElementFactory elemFactory = null;

	public GroupElementHandleTest( String name )
	{
		super( name );
		// TODO Auto-generated constructor stub
	}

	public static Test suite( )
	{
		return new TestSuite( GroupElementHandleTest.class );

	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp( ) throws Exception
	{
		super.setUp( );
		design = (ReportDesign) DesignEngine.newSession( ULocale.ENGLISH )
				.createDesign( ).getModule( );
		designHandle = (ReportDesignHandle) design.getHandle( design );

		elemFactory = new ElementFactory( design );
	}

	public void testHasLocalPropertiesForExtendedElements( ) throws Exception
	{
		// same type of group elements
		ArrayList elements = new ArrayList( );

		LabelHandle element1 = elemFactory.newLabel( "label1" ); //$NON-NLS-1$
		LabelHandle element2 = elemFactory.newLabel( "label2" ); //$NON-NLS-1$

		elements.add( element1 );
		elements.add( element2 );
		GroupElementHandle groupElementHandle = new SimpleGroupElementHandle(
				designHandle, elements );

		assertTrue( groupElementHandle.isSameType( ) );
		assertFalse( groupElementHandle.hasLocalPropertiesForExtendedElements( ) );

		// set local property
		element1.setText( "firstlabel" );
		element2.setBookmark( "secondlabel" );

		// no extends
		assertFalse( groupElementHandle.isExtendedElements( ) );

		// has extends
		LabelHandle baseLabel = elemFactory.newLabel( "baseLabel" ); //$NON-NLS-1$
		designHandle.getComponents( ).add( baseLabel );

		element1.setExtends( baseLabel );
		element2.setExtends( baseLabel );

		assertTrue( groupElementHandle.isExtendedElements( ) );
		assertTrue( groupElementHandle.hasLocalPropertiesForExtendedElements( ) );

		// different type
		TextItemHandle element3 = elemFactory.newTextItem( "text1" );
		elements.add( element3 );
		assertFalse( groupElementHandle.isSameType( ) );

	}

	public void testClearAllProperties( ) throws Exception
	{
		ArrayList elements = new ArrayList( );

		LabelHandle element1 = elemFactory.newLabel( "label" ); //$NON-NLS-1$
		TextItemHandle element2 = elemFactory.newTextItem( "text" ); //$NON-NLS-1$

		element1.setComments( "New ReportItem" ); //$NON-NLS-1$
		element1.setHeight( "12pt" ); //$NON-NLS-1$
		element1.setWidth( "24pt" ); //$NON-NLS-1$
		element1.setAction( new Action( ) );

		element2.setComments( "New ReportItem" ); //$NON-NLS-1$
		element2.setHeight( "12pt" ); //$NON-NLS-1$
		element2.setWidth( "24mm" ); //$NON-NLS-1$
		element2.setContent( "New Text" ); //$NON-NLS-1$

		elements.add( element2 );
		elements.add( element1 );

		GroupElementHandle groupElementHandle = new SimpleGroupElementHandle(
				designHandle, elements );

		assertEquals( "12pt", groupElementHandle //$NON-NLS-1$
				.getStringProperty( ReportItemHandle.HEIGHT_PROP ) );
		assertEquals( "New ReportItem", groupElementHandle //$NON-NLS-1$
				.getStringProperty( ReportItemHandle.COMMENTS_PROP ) );
		assertNull( groupElementHandle
				.getStringProperty( ReportItemHandle.WIDTH_PROP ) );
		assertNull( groupElementHandle
				.getStringProperty( TextItemHandle.CONTENT_PROP ) );

		groupElementHandle.clearLocalProperties( );

		// common properties are cleared.

		assertNull( groupElementHandle //$NON-NLS-1$
				.getStringProperty( ReportItemHandle.HEIGHT_PROP ) );
		assertNull( groupElementHandle //$NON-NLS-1$
				.getStringProperty( ReportItemHandle.COMMENTS_PROP ) );

		assertEquals( "New Text", element2.getContent( ) ); //$NON-NLS-1$
		assertNotNull( element1.getActionHandle( ) );

		assertEquals( "New Text", element2.getContent( ) ); //$NON-NLS-1$
		assertNotNull( element1.getActionHandle( ) );

		// 2. extends property shouldn't be cleared.

		LabelHandle baseLabel1 = elemFactory.newLabel( "BaseLabel1" ); //$NON-NLS-1$
		LabelHandle baseLabel2 = elemFactory.newLabel( "BaseLabel2" ); //$NON-NLS-1$

		designHandle.getComponents( ).add( baseLabel1 );
		designHandle.getComponents( ).add( baseLabel2 );

		LabelHandle label1 = (LabelHandle) elemFactory.newElementFrom(
				baseLabel1, "Label1" ); //$NON-NLS-1$
		LabelHandle label2 = (LabelHandle) elemFactory.newElementFrom(
				baseLabel2, "Label2" ); //$NON-NLS-1$

		elements = new ArrayList( );
		elements.add( label1 );
		elements.add( label2 );

		groupElementHandle = new SimpleGroupElementHandle( designHandle,
				elements );

		groupElementHandle.clearLocalProperties( );
		assertNotNull( label1.getExtends( ) );
		assertNotNull( label2.getExtends( ) );

	}

}
